/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginGoalConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        return this.getVariants(context2).contains(s) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context2) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context2) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context2.getInvocationElement());
        if (model == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenPluginGoalConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (goal == null) continue;
            result2.add(goal);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            MavenPluginGoalConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public PsiElement resolve(String text, ConvertContext context2) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context2.getInvocationElement());
        if (model == null) {
            return null;
        }
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (!text.equals(goal)) continue;
            return each.getXmlElement();
        }
        return super.resolve((Object)text, context2);
    }

    @Override
    public boolean isSoft(@NotNull DomElement element) {
        if (element == null) {
            MavenPluginGoalConverter.$$$reportNull$$$0(2);
        }
        return MavenPluginDomUtil.getMavenPluginModel(element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSoft";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

