/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

public class MergeRootInfo {
    private String myUrl1;
    private Revision myRevision1 = Revision.HEAD;
    private String myUrl2;
    private Revision myRevision2 = Revision.HEAD;

    public MergeRootInfo(File file, SvnVcs vcs) {
        Info info2 = vcs.getInfo(file);
        this.myUrl2 = this.myUrl1 = info2 != null && info2.getUrl() != null ? info2.getUrl().toDecodedString() : "";
    }

    public Url getUrl1() {
        try {
            return SvnUtil.createUrl(this.myUrl1, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public Url getUrl2() {
        try {
            return SvnUtil.createUrl(this.myUrl2, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public Revision getRevision2() {
        return this.myRevision2;
    }

    public Revision getRevision1() {
        return this.myRevision1;
    }

    public long getResultRevision() {
        return this.myRevision2.getNumber();
    }

    public void setUrl1(String text) {
        this.myUrl1 = text;
    }

    public void setUrl2(String text) {
        this.myUrl2 = text;
    }

    public void setRevision1(Revision rev) {
        this.myRevision1 = rev;
    }

    public void setRevision2(Revision rev) {
        this.myRevision2 = rev;
    }

    public String getUrlString1() {
        return this.myUrl1;
    }

    public String getUrlString2() {
        return this.myUrl2;
    }
}

