/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilterFilePathStrings;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.rollback.SuperfluousRemover;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class ChangesChecker {
    @NotNull
    private final SuperfluousRemover myForAdds;
    @NotNull
    private final SuperfluousRemover myForDeletes;
    private final List<File> myForEdits;
    private final SvnChangeProvider myChangeProvider;
    @NotNull
    private final UnversionedAndNotTouchedFilesGroupCollector myCollector;
    private final List<SvnBindException> myExceptions;

    ChangesChecker(@NotNull SvnVcs vcs, @NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (vcs == null) {
            ChangesChecker.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            ChangesChecker.$$$reportNull$$$0(1);
        }
        this.myChangeProvider = (SvnChangeProvider)vcs.getChangeProvider();
        this.myCollector = collector;
        this.myForAdds = new SuperfluousRemover(true);
        this.myForDeletes = new SuperfluousRemover(false);
        this.myForEdits = new ArrayList<File>();
        this.myExceptions = new ArrayList<SvnBindException>();
    }

    public void gather(List<? extends Change> changes) {
        TreeMap<String, File> renames = new TreeMap<String, File>();
        HashSet<String> alsoReverted = new HashSet<String>();
        HashMap<String, FilePath> files = new HashMap<String, FilePath>();
        for (Change change : changes) {
            String key;
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            String string = key = afterRevision == null ? null : FilePathsHelper.convertWithLastSeparator((FilePath)afterRevision.getFile());
            if (SvnRollbackEnvironment.isMoveRenameReplace(change)) {
                File beforeFile = beforeRevision.getFile().getIOFile();
                renames.put(key, beforeFile);
                files.put(key, afterRevision.getFile());
                this.myCollector.markRename(beforeFile, afterRevision.getFile().getIOFile());
                continue;
            }
            if (afterRevision == null) continue;
            alsoReverted.add(key);
        }
        if (!renames.isEmpty()) {
            ArrayList paths = new ArrayList(renames.keySet());
            if (paths.size() > 1) {
                FilterFilePathStrings.getInstance().doFilter(paths);
            }
            this.myCollector.setRenamesMap(renames);
            this.myCollector.setAlsoReverted(alsoReverted);
            for (String path : paths) {
                try {
                    this.myChangeProvider.getChanges((FilePath)files.get(path), true, (ChangelistBuilder)this.myCollector);
                }
                catch (SvnBindException e) {
                    this.myExceptions.add(e);
                }
            }
        }
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            boolean checked = this.myForAdds.accept(change);
            if (checked |= this.myForDeletes.accept(change)) continue;
            this.myForEdits.add(afterRevision.getFile().getIOFile());
        }
    }

    @NotNull
    public Collection<File> getForAdds() {
        Set<File> set = this.myForAdds.getParentPaths();
        if (set == null) {
            ChangesChecker.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<File> getForDeletes() {
        Set<File> set = this.myForDeletes.getParentPaths();
        if (set == null) {
            ChangesChecker.$$$reportNull$$$0(3);
        }
        return set;
    }

    public List<SvnBindException> getExceptions() {
        return this.myExceptions;
    }

    @NotNull
    public List<File> getForEdits() {
        List<File> list = this.myForEdits;
        if (list == null) {
            ChangesChecker.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/rollback/ChangesChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/rollback/ChangesChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getForAdds";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForDeletes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForEdits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

