/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.diff.tools.combined.CombinedDiffModelBuilder;
import com.intellij.diff.tools.combined.CombinedDiffModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRCreateCombinedDiffModelKt;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0012\u0010\u0016\u001a\f0\u0004\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewVirtualFileBase;", "Lcom/intellij/diff/tools/combined/CombinedDiffModelBuilder;", "sourceId", "", "fileManagerId", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "createModel", "Lcom/intellij/diff/tools/combined/CombinedDiffModelImpl;", "id", "equals", "", "other", "", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "intellij.vcs.github"})
public final class GHPRCombinedDiffPreviewVirtualFile
extends GHPRCombinedDiffPreviewVirtualFileBase
implements CombinedDiffModelBuilder {
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRCombinedDiffPreviewVirtualFile(@NotNull String sourceId, @NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(sourceId, fileManagerId, project, repository);
        this.pullRequest = pullRequest;
    }

    @NotNull
    public String getName() {
        return "#" + this.pullRequest.getNumber() + ".diff";
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.pullRequest.getNumber()};
        String string = GithubBundle.message("pull.request.diff.editor.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getPath() {
        VirtualFileSystem virtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)virtualFileSystem).getPath(this.getFileManagerId(), this.getProject(), this.getRepository(), this.pullRequest, this.getSourceId(), true);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getRepository().toUrl() + "/pulls/" + this.pullRequest.getNumber() + ".diff";
    }

    @NotNull
    public CombinedDiffModelImpl createModel(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return GHPRCreateCombinedDiffModelKt.createCombinedDiffModel(this.getProject(), this.getRepository(), this.pullRequest);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRCombinedDiffPreviewVirtualFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((GHPRCombinedDiffPreviewVirtualFile)((Object)other)).pullRequest, (Object)this.pullRequest)) {
            return false;
        }
        return super.equals(other);
    }
}

