/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.intellij.uiDesigner.compiler.PropertyCodeGenerator;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.GeneratorAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public final class ListModelPropertyCodeGenerator
extends PropertyCodeGenerator {
    private final Type myListModelType;
    private static final Method ourInitMethod = Method.getMethod((String)"void <init>()");
    private static final Method ourAddElementMethod = Method.getMethod((String)"void addElement(java.lang.Object)");

    ListModelPropertyCodeGenerator(Class aClass) {
        this.myListModelType = Type.getType((Class)aClass);
    }

    @Override
    public void generatePushValue(GeneratorAdapter generator, Object value) {
        String[] items = (String[])value;
        int listModelLocal = generator.newLocal(this.myListModelType);
        generator.newInstance(this.myListModelType);
        generator.dup();
        generator.invokeConstructor(this.myListModelType, ourInitMethod);
        generator.storeLocal(listModelLocal);
        for (String item : items) {
            generator.loadLocal(listModelLocal);
            generator.push(item);
            generator.invokeVirtual(this.myListModelType, ourAddElementMethod);
        }
        generator.loadLocal(listModelLocal);
    }
}

