/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.Map;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements CleanableThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    @Override
    public void put(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    @Override
    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> entry2 : m.entrySet()) {
            MDC.put((String)entry2.getKey(), (String)entry2.getValue());
        }
    }

    @Override
    public String get(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void remove(String key) {
        MDC.remove((String)key);
    }

    @Override
    public void removeAll(Iterable<String> keys) {
        for (String key : keys) {
            MDC.remove((String)key);
        }
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public boolean containsKey(String key) {
        Map map = MDC.getCopyOfContextMap();
        return map != null && map.containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public boolean isEmpty() {
        Map map = MDC.getCopyOfContextMap();
        return map == null || map.isEmpty();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        Map<String, String> copy = this.getCopy();
        if (copy.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result2 = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry2 : copy.entrySet()) {
            result2.putValue(entry2.getKey(), entry2.getValue());
        }
        return result2;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

