/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.pointers;

import io.kinference.ndarray.arrays.tiled.PrimitiveTiledArray;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\"J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\"J\u000e\u0010)\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR$\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000f\u00a8\u0006*"}, d2={"Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;", "", "array", "Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "startIndex", "", "(Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;I)V", "other", "(Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;)V", "getArray", "()Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "blockNum", "getBlockNum", "()I", "setBlockNum", "(I)V", "currentBlock", "Lio/kinference/primitives/types/PrimitiveArray;", "getCurrentBlock", "()Lio/kinference/primitives/types/PrimitiveArray;", "setCurrentBlock", "(Lio/kinference/primitives/types/PrimitiveArray;)V", "indexInBlock", "getIndexInBlock", "setIndexInBlock", "value", "linearIndex", "getLinearIndex", "setLinearIndex", "blockDecrement", "", "blockIncrement", "decrement", "get", "Lio/kinference/primitives/types/PrimitiveType;", "getAndIncrement", "increment", "incrementAndGet", "isValid", "", "set", "setAndIncrement", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nPrimitivePointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitivePointer.kt\nio/kinference/ndarray/arrays/pointers/PrimitivePointer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
public final class PrimitivePointer {
    @NotNull
    private final PrimitiveTiledArray array;
    private int blockNum;
    private int indexInBlock;
    @NotNull
    private PrimitiveArray currentBlock;

    @NotNull
    public final PrimitiveTiledArray getArray() {
        return this.array;
    }

    public final int getBlockNum() {
        return this.blockNum;
    }

    public final void setBlockNum(int n) {
        this.blockNum = n;
    }

    public final int getIndexInBlock() {
        return this.indexInBlock;
    }

    public final void setIndexInBlock(int n) {
        this.indexInBlock = n;
    }

    @NotNull
    public final PrimitiveArray getCurrentBlock() {
        return this.currentBlock;
    }

    public final void setCurrentBlock(@NotNull PrimitiveArray primitiveArray) {
        Intrinsics.checkNotNullParameter((Object)primitiveArray, (String)"<set-?>");
        this.currentBlock = primitiveArray;
    }

    public PrimitivePointer(@NotNull PrimitiveTiledArray array, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(startIndex2 >= 0 && startIndex2 < array.getSize())) {
            boolean bl = false;
            String string = "Start index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.array = array;
        this.blockNum = startIndex2 / array.getBlockSize();
        this.indexInBlock = startIndex2 % array.getBlockSize();
        this.currentBlock = array.getBlocks()[this.blockNum];
    }

    public /* synthetic */ PrimitivePointer(PrimitiveTiledArray primitiveTiledArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(primitiveTiledArray, n);
    }

    public PrimitivePointer(@NotNull PrimitivePointer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.array = other.array;
        this.blockNum = other.blockNum;
        this.indexInBlock = other.indexInBlock;
        this.currentBlock = other.currentBlock;
    }

    public final int getLinearIndex() {
        return this.blockNum * this.array.getBlockSize() + this.indexInBlock;
    }

    public final void setLinearIndex(int value) {
        if (!(value >= 0 && value < this.array.getSize())) {
            boolean bl = false;
            String string = "Linear index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.blockNum = value / this.array.getBlockSize();
        this.indexInBlock = value % this.array.getBlockSize();
        this.currentBlock = this.array.getBlocks()[this.blockNum];
    }

    public final void set(@NotNull PrimitiveType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.currentBlock.set(this.indexInBlock, value);
    }

    @NotNull
    public final PrimitiveType get() {
        return this.currentBlock.get(this.indexInBlock);
    }

    public final void blockIncrement() {
        if (this.blockNum < this.array.getBlocksNum() - 1) {
            int n = this.blockNum;
            this.blockNum = n + 1;
            this.indexInBlock = 0;
            this.currentBlock = this.array.getBlocks()[this.blockNum];
        } else {
            this.indexInBlock = this.array.getBlockSize();
        }
    }

    public final void increment() {
        if (this.indexInBlock < this.array.getBlockSize() - 1) {
            int n = this.indexInBlock;
            this.indexInBlock = n + 1;
        } else {
            this.blockIncrement();
        }
    }

    public final void blockDecrement() {
        if (this.blockNum > 0) {
            int n = this.blockNum;
            this.blockNum = n + -1;
            this.indexInBlock = this.array.getBlockSize() - 1;
            this.currentBlock = this.array.getBlocks()[this.blockNum];
        } else {
            this.indexInBlock = -1;
        }
    }

    public final void decrement() {
        if (this.indexInBlock > 0) {
            int n = this.indexInBlock;
            this.indexInBlock = n + -1;
        } else {
            this.blockDecrement();
        }
    }

    @NotNull
    public final PrimitiveType incrementAndGet() {
        this.increment();
        return this.currentBlock.get(this.indexInBlock);
    }

    @NotNull
    public final PrimitiveType getAndIncrement() {
        PrimitiveType value = this.currentBlock.get(this.indexInBlock);
        this.increment();
        return value;
    }

    public final void setAndIncrement(@NotNull PrimitiveType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.currentBlock.set(this.indexInBlock, value);
        this.increment();
    }

    public final boolean isValid() {
        return this.indexInBlock < this.array.getBlockSize() && this.indexInBlock > -1;
    }
}

