/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.layer.normalization;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.data.tensor.TensorExtensionsKt;
import io.kinference.core.operators.layer.normalization.LayerNormalization;
import io.kinference.core.operators.layer.normalization.LayerNormalizationVer1;
import io.kinference.data.ONNXData;
import io.kinference.graph.Contexts;
import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.pointers.DoublePointer;
import io.kinference.ndarray.arrays.pointers.DoublePointerKt;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.FloatPointerKt;
import io.kinference.ndarray.arrays.tiled.DoubleTiledArray;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.operator.AttributeInfo;
import io.kinference.operator.IOInfo;
import io.kinference.operator.Operator;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.primitives.types.DataType;
import io.kinference.protobuf.message.AttributeProto;
import io.kinference.protobuf.message.TensorProto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJI\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\t\"\u0010\b\u0000\u0010\u0019*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lio/kinference/core/operators/layer/normalization/LayerNormalizationVer1;", "Lio/kinference/core/operators/layer/normalization/LayerNormalization;", "name", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "axis", "", "getAxis", "()I", "axis$delegate", "Lio/kinference/operator/Operator$AttributeValueDelegate;", "epsilon", "", "getEpsilon", "()F", "epsilon$delegate", "apply", "Lio/kinference/core/data/tensor/KITensor;", "D", "Lio/kinference/data/ONNXData;", "contexts", "Lio/kinference/graph/Contexts;", "(Lio/kinference/graph/Contexts;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
@SourceDebugExtension(value={"SMAP\nLayerNormalization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerNormalization.kt\nio/kinference/core/operators/layer/normalization/LayerNormalizationVer1\n+ 2 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DoublePointer.kt\nio/kinference/ndarray/arrays/pointers/DoublePointerKt\n*L\n1#1,151:1\n195#2,18:152\n2629#2:170\n2630#2,41:172\n1#3:171\n1#3:232\n195#4,18:213\n2675#4:231\n2676#4,41:233\n*S KotlinDebug\n*F\n+ 1 LayerNormalization.kt\nio/kinference/core/operators/layer/normalization/LayerNormalizationVer1\n*L\n98#1:152,18\n110#1:170\n110#1:172,41\n110#1:171\n139#1:232\n127#1:213,18\n139#1:231\n139#1:233,41\n*E\n"})
public final class LayerNormalizationVer1
extends LayerNormalization {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Operator.AttributeValueDelegate axis$delegate;
    @NotNull
    private final Operator.AttributeValueDelegate epsilon$delegate;
    @NotNull
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    @NotNull
    private static final List<AttributeInfo> ATTRIBUTES_INFO;
    @NotNull
    private static final List<IOInfo> INPUTS_INFO;
    @NotNull
    private static final List<IOInfo> OUTPUTS_INFO;
    @NotNull
    private static final VersionInfo VERSION;
    @NotNull
    private static final OperatorInfo INFO;

    public LayerNormalizationVer1(@NotNull String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(name, INFO, attributes, inputs, outputs, null);
        this.axis$delegate = Operator.attribute$default(this, null, axis.2.INSTANCE, 1, null);
        this.epsilon$delegate = Operator.attribute$default(this, null, 1, null);
    }

    private final int getAxis() {
        return ((Number)this.axis$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    private final float getEpsilon() {
        return ((Number)this.epsilon$delegate.getValue(this, $$delegatedProperties[1])).floatValue();
    }

    @Override
    @Nullable
    public <D extends ONNXData<?, ?>> Object apply(@NotNull Contexts<D> contexts, @NotNull List<KITensor> inputs, @NotNull Continuation<? super List<KITensor>> $completion) {
        KITensor kITensor = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor);
        NDArrayCore input = kITensor.getData();
        KITensor kITensor2 = inputs.get(1);
        Intrinsics.checkNotNull((Object)kITensor2);
        NDArrayCore scale = kITensor2.getData();
        KITensor kITensor3 = inputs.get(2);
        Intrinsics.checkNotNull((Object)kITensor3);
        NDArrayCore bias = kITensor3.getData();
        if (!(input.getType() == scale.getType() && input.getType() == bias.getType())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DataType type = input.getType();
        int axis2 = NDArrayUtilsKt.indexAxis(input, this.getAxis());
        int normCount = 1;
        int normSize = 1;
        int n = input.getShape().length;
        for (int i = 0; i < n; ++i) {
            if (i < axis2) {
                normCount *= input.getShape()[i];
                continue;
            }
            normSize *= input.getShape()[i];
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                (FloatNDArray)input;
                Intrinsics.checkNotNull((Object)scale, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                (FloatNDArray)scale;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                (FloatNDArray)bias;
                FloatTiledArray outputArray = FloatTiledArray.Companion.invoke(((FloatNDArray)input).getStrides());
                int var15_18 = normCount;
                for (int i = 0; i < var15_18; ++i) {
                    float b;
                    float sc;
                    float inp;
                    boolean $i$a$-acceptTriple-LayerNormalizationVer1$apply$3;
                    Object var39_76;
                    int end$iv;
                    int offset$iv;
                    float[] block$iv;
                    int offset = i * normSize;
                    float mean = 0.0f;
                    float meanSquare = 0.0f;
                    FloatPointer $this$forEach$iv = ((FloatNDArray)input).getArray().pointer(offset);
                    boolean $i$f$forEach = false;
                    for (int end$iv = normSize; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$forEach$iv.getCurrentBlock();
                        if (block$iv.length <= (offset$iv = $this$forEach$iv.getIndexInBlock()) + end$iv) {
                            $this$forEach$iv.blockIncrement();
                        } else {
                            $this$forEach$iv.setIndexInBlock($this$forEach$iv.getIndexInBlock() + end$iv);
                        }
                        int var25_51 = Math.min(block$iv.length, offset$iv + end$iv);
                        for (int index$iv = offset$iv; index$iv < var25_51; ++index$iv) {
                            float it = block$iv[index$iv];
                            boolean $i$a$-forEach-LayerNormalizationVer1$apply$2 = false;
                            mean += it;
                            meanSquare += it * it;
                        }
                    }
                    meanSquare = (float)Math.sqrt(meanSquare / (float)normSize - (mean /= (float)normSize) * mean + this.getEpsilon());
                    FloatPointer scalePointer = FloatTiledArray.pointer$default(((FloatNDArray)scale).getArray(), 0, 1, null);
                    FloatPointer biasPointer = FloatTiledArray.pointer$default(((FloatNDArray)bias).getArray(), 0, 1, null);
                    FloatPointer inputPointer = ((FloatNDArray)input).getArray().pointer(offset);
                    FloatPointer $this$acceptTriple$iv = outputArray.pointer(offset);
                    boolean $i$f$acceptTriple = false;
                    if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, inputPointer, normSize)) {
                        boolean $i$a$-require-FloatPointerKt$acceptTriple$25$iv2 = false;
                        String $i$a$-require-FloatPointerKt$acceptTriple$25$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$25$iv2.toString());
                    }
                    if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, scalePointer, normSize)) {
                        boolean $i$a$-require-FloatPointerKt$acceptTriple$26$iv2 = false;
                        String $i$a$-require-FloatPointerKt$acceptTriple$26$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$26$iv2.toString());
                    }
                    if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, biasPointer, normSize)) {
                        boolean $i$a$-require-FloatPointerKt$acceptTriple$27$iv2 = false;
                        String $i$a$-require-FloatPointerKt$acceptTriple$27$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$27$iv2.toString());
                    }
                    if (FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, inputPointer) && FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, scalePointer) && FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, biasPointer)) {
                        int dstOffset$iv;
                        float[] dstBlock$iv;
                        for (end$iv = normSize; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                            dstBlock$iv = $this$acceptTriple$iv.getCurrentBlock();
                            dstOffset$iv = $this$acceptTriple$iv.getIndexInBlock();
                            float[] fstBlock$iv = inputPointer.getCurrentBlock();
                            float[] sndBlock$iv = scalePointer.getCurrentBlock();
                            float[] trdBlock$iv = biasPointer.getCurrentBlock();
                            if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                $this$acceptTriple$iv.blockIncrement();
                                inputPointer.blockIncrement();
                                scalePointer.blockIncrement();
                                biasPointer.blockIncrement();
                            } else {
                                $this$acceptTriple$iv.setIndexInBlock($this$acceptTriple$iv.getIndexInBlock() + end$iv);
                                inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                                scalePointer.setIndexInBlock(scalePointer.getIndexInBlock() + end$iv);
                                biasPointer.setIndexInBlock(biasPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int var31_67 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                            while (index$iv < var31_67) {
                                dstBlock$iv[index$iv];
                                float var32_69 = trdBlock$iv[index$iv];
                                float var33_71 = sndBlock$iv[index$iv];
                                float var34_72 = fstBlock$iv[index$iv];
                                int var40_78 = index$iv++;
                                var39_76 = dstBlock$iv;
                                $i$a$-acceptTriple-LayerNormalizationVer1$apply$3 = false;
                                float var42_82 = (inp - mean) / meanSquare * sc + b;
                                var39_76[var40_78] = var42_82;
                            }
                        }
                        continue;
                    }
                    while (end$iv > 0) {
                        $this$acceptTriple$iv.get();
                        b = biasPointer.getAndIncrement();
                        sc = scalePointer.getAndIncrement();
                        inp = inputPointer.getAndIncrement();
                        var39_76 = $this$acceptTriple$iv;
                        $i$a$-acceptTriple-LayerNormalizationVer1$apply$3 = false;
                        float var40_79 = (inp - mean) / meanSquare * sc + b;
                        ((FloatPointer)var39_76).set(var40_79);
                        $this$acceptTriple$iv.increment();
                        --end$iv;
                    }
                }
                yield CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor$default(new FloatNDArray(outputArray, ((FloatNDArray)input).getStrides()), null, 1, null));
            }
            case 2 -> {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                (DoubleNDArray)input;
                Intrinsics.checkNotNull((Object)scale, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                (DoubleNDArray)scale;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                (DoubleNDArray)bias;
                DoubleTiledArray outputArray = DoubleTiledArray.Companion.invoke(((DoubleNDArray)input).getStrides());
                int var15_19 = normCount;
                for (int i = 0; i < var15_19; ++i) {
                    double sc;
                    double inp;
                    boolean $i$a$-acceptTriple-LayerNormalizationVer1$apply$5;
                    Object var39_77;
                    double b;
                    int end$iv;
                    int offset$iv;
                    double[] block$iv;
                    int offset = i * normSize;
                    double mean = 0.0;
                    double meanSquare = 0.0;
                    DoublePointer $this$forEach$iv = ((DoubleNDArray)input).getArray().pointer(offset);
                    boolean $i$f$forEach = false;
                    for (int end$iv = normSize; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$forEach$iv.getCurrentBlock();
                        if (block$iv.length <= (offset$iv = $this$forEach$iv.getIndexInBlock()) + end$iv) {
                            $this$forEach$iv.blockIncrement();
                        } else {
                            $this$forEach$iv.setIndexInBlock($this$forEach$iv.getIndexInBlock() + end$iv);
                        }
                        end$iv = Math.min(block$iv.length, offset$iv + end$iv);
                        for (int index$iv = offset$iv; index$iv < end$iv; ++index$iv) {
                            double it = block$iv[index$iv];
                            boolean $i$a$-forEach-LayerNormalizationVer1$apply$4 = false;
                            mean += it;
                            meanSquare += it * it;
                        }
                    }
                    meanSquare = Math.sqrt(meanSquare / (double)normSize - (mean /= (double)normSize) * mean + (double)this.getEpsilon());
                    DoublePointer scalePointer = DoubleTiledArray.pointer$default(((DoubleNDArray)scale).getArray(), 0, 1, null);
                    DoublePointer biasPointer = DoubleTiledArray.pointer$default(((DoubleNDArray)bias).getArray(), 0, 1, null);
                    DoublePointer inputPointer = ((DoubleNDArray)input).getArray().pointer(offset);
                    DoublePointer $this$acceptTriple$iv = outputArray.pointer(offset);
                    boolean $i$f$acceptTriple = false;
                    if (!DoublePointerKt.isCompatibleBySize($this$acceptTriple$iv, inputPointer, normSize)) {
                        boolean $i$a$-require-DoublePointerKt$acceptTriple$28$iv2 = false;
                        String $i$a$-require-DoublePointerKt$acceptTriple$28$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-DoublePointerKt$acceptTriple$28$iv2.toString());
                    }
                    if (!DoublePointerKt.isCompatibleBySize($this$acceptTriple$iv, scalePointer, normSize)) {
                        boolean $i$a$-require-DoublePointerKt$acceptTriple$29$iv2 = false;
                        String $i$a$-require-DoublePointerKt$acceptTriple$29$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-DoublePointerKt$acceptTriple$29$iv2.toString());
                    }
                    if (!DoublePointerKt.isCompatibleBySize($this$acceptTriple$iv, biasPointer, normSize)) {
                        boolean $i$a$-require-DoublePointerKt$acceptTriple$30$iv2 = false;
                        String $i$a$-require-DoublePointerKt$acceptTriple$30$iv2 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-DoublePointerKt$acceptTriple$30$iv2.toString());
                    }
                    if (DoublePointerKt.isCompatibleWith($this$acceptTriple$iv, inputPointer) && DoublePointerKt.isCompatibleWith($this$acceptTriple$iv, scalePointer) && DoublePointerKt.isCompatibleWith($this$acceptTriple$iv, biasPointer)) {
                        int dstOffset$iv;
                        double[] dstBlock$iv;
                        for (end$iv = normSize; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                            dstBlock$iv = $this$acceptTriple$iv.getCurrentBlock();
                            dstOffset$iv = $this$acceptTriple$iv.getIndexInBlock();
                            double[] fstBlock$iv = inputPointer.getCurrentBlock();
                            double[] sndBlock$iv = scalePointer.getCurrentBlock();
                            double[] trdBlock$iv = biasPointer.getCurrentBlock();
                            if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                $this$acceptTriple$iv.blockIncrement();
                                inputPointer.blockIncrement();
                                scalePointer.blockIncrement();
                                biasPointer.blockIncrement();
                            } else {
                                $this$acceptTriple$iv.setIndexInBlock($this$acceptTriple$iv.getIndexInBlock() + end$iv);
                                inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                                scalePointer.setIndexInBlock(scalePointer.getIndexInBlock() + end$iv);
                                biasPointer.setIndexInBlock(biasPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int var31_68 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                            while (index$iv < var31_68) {
                                dstBlock$iv[index$iv];
                                b = trdBlock$iv[index$iv];
                                double inp = sndBlock$iv[index$iv];
                                double $i$a$-acceptTriple-LayerNormalizationVer1$apply$3 = fstBlock$iv[index$iv];
                                int var40_80 = index$iv++;
                                var39_77 = dstBlock$iv;
                                $i$a$-acceptTriple-LayerNormalizationVer1$apply$5 = false;
                                double var42_83 = (inp - mean) / meanSquare * sc + b;
                                var39_77[var40_80] = var42_83;
                            }
                        }
                        continue;
                    }
                    while (end$iv > 0) {
                        $this$acceptTriple$iv.get();
                        b = biasPointer.getAndIncrement();
                        sc = scalePointer.getAndIncrement();
                        inp = inputPointer.getAndIncrement();
                        var39_77 = $this$acceptTriple$iv;
                        $i$a$-acceptTriple-LayerNormalizationVer1$apply$5 = false;
                        double var40_81 = (inp - mean) / meanSquare * sc + b;
                        ((DoublePointer)var39_77).set(var40_81);
                        $this$acceptTriple$iv.increment();
                        --end$iv;
                    }
                }
                yield CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor$default(new DoubleNDArray(outputArray, ((DoubleNDArray)input).getStrides()), null, 1, null));
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LayerNormalizationVer1.class, "axis", "getAxis()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LayerNormalizationVer1.class, "epsilon", "getEpsilon()F", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new TensorProto.DataType[]{TensorProto.DataType.FLOAT, TensorProto.DataType.DOUBLE, TensorProto.DataType.FLOAT16, TensorProto.DataType.BFLOAT16};
        TYPE_CONSTRAINTS = SetsKt.setOf((Object[])objectArray);
        objectArray = new AttributeInfo[]{new AttributeInfo("axis", SetsKt.setOf((Object)AttributeProto.AttributeType.INT), false, -1), new AttributeInfo("epsilon", SetsKt.setOf((Object)AttributeProto.AttributeType.FLOAT), false, Float.valueOf(1.0E-5f))};
        ATTRIBUTES_INFO = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IOInfo[]{new IOInfo(0, TYPE_CONSTRAINTS, "X", false, null, false, null, 112, null), new IOInfo(1, TYPE_CONSTRAINTS, "scale", false, null, false, null, 112, null), new IOInfo(2, TYPE_CONSTRAINTS, "B", false, null, false, null, 112, null)};
        INPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IOInfo[]{new IOInfo(0, TYPE_CONSTRAINTS, "Y", false, null, false, null, 112, null), new IOInfo(1, TYPE_CONSTRAINTS, "mean", true, null, false, null, 112, null), new IOInfo(2, TYPE_CONSTRAINTS, "inv_std_var", true, null, false, null, 112, null)};
        OUTPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        VERSION = new VersionInfo(1, 0, 2, null);
        INFO = new OperatorInfo("LayerNormalization", (Collection<AttributeInfo>)ATTRIBUTES_INFO, INPUTS_INFO, OUTPUTS_INFO, VERSION, "com.microsoft");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/kinference/core/operators/layer/normalization/LayerNormalizationVer1$Companion;", "", "()V", "ATTRIBUTES_INFO", "", "Lio/kinference/operator/AttributeInfo;", "INFO", "Lio/kinference/operator/OperatorInfo;", "INPUTS_INFO", "Lio/kinference/operator/IOInfo;", "OUTPUTS_INFO", "TYPE_CONSTRAINTS", "", "Lio/kinference/protobuf/message/TensorProto$DataType;", "VERSION", "Lio/kinference/operator/VersionInfo;", "getVERSION$inference_core", "()Lio/kinference/operator/VersionInfo;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionInfo getVERSION$inference_core() {
            return VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.FLOAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

