/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.customize.transferSettings.controllers.TransferSettingsListener;
import com.intellij.ide.customize.transferSettings.models.IdeVersion;
import com.intellij.ide.customize.transferSettings.models.Settings;
import com.intellij.ide.customize.transferSettings.providers.PluginInstallationState;
import com.intellij.ide.customize.transferSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferServiceKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener;", "Lcom/intellij/ide/customize/transferSettings/controllers/TransferSettingsListener;", "()V", "importFailed", "", "ideVersion", "Lcom/intellij/ide/customize/transferSettings/models/IdeVersion;", "settings", "Lcom/intellij/ide/customize/transferSettings/models/Settings;", "throwable", "", "importPerformed", "context", "Lcom/intellij/ide/customize/transferSettings/providers/TransferSettingsPerformContext;", "importStarted", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nSettingTransferService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingTransferService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n8#2:210\n8#2:211\n8#2:212\n*S KotlinDebug\n*F\n+ 1 SettingTransferService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n*L\n172#1:210\n176#1:211\n181#1:212\n*E\n"})
public final class TransferSettingsWizardListener
implements TransferSettingsListener {
    public void importStarted(@NotNull IdeVersion ideVersion, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Settings import from " + ideVersion.getName() + " has been started.");
    }

    public void importFailed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Setting import error from " + ideVersion.getName() + ".", throwable);
        SettingTransferServiceKt.access$showImportErrorNotification(throwable);
    }

    public void importPerformed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull TransferSettingsPerformContext context2) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Setting import error from " + ideVersion.getName() + " has been finished, plugin state: " + context2.getPluginInstallationState() + ".");
        SettingsService.Companion.getInstance().getDoClose().fire((Object)Unit.INSTANCE);
        if (context2.getPluginInstallationState() == PluginInstallationState.RestartRequired) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }
}

