/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.time;

import ai.grazie.utils.mpp.time.Duration;
import ai.grazie.utils.mpp.time.TimePeriod;
import ai.grazie.utils.mpp.time.Timestamp;
import ai.grazie.utils.mpp.time.TimestampKt;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0010H\u0002J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lai/grazie/utils/mpp/time/TimeUtils;", "", "()V", "atStartOf", "Lai/grazie/utils/mpp/time/Timestamp;", "timestamp", "period", "Lai/grazie/utils/mpp/time/TimePeriod;", "minus", "number", "", "ofFullDate", "value", "", "plus", "toTimestamp", "Ljava/time/LocalDate;", "Ljava/time/LocalDateTime;", "toUTC", "Ljava/util/Date;", "utils-common"})
public final class TimeUtils {
    @NotNull
    public static final TimeUtils INSTANCE = new TimeUtils();

    private TimeUtils() {
    }

    @NotNull
    public final Timestamp atStartOf(@NotNull Timestamp timestamp, @NotNull TimePeriod period) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        Date date = TimestampKt.toDate(timestamp);
        LocalDateTime start2 = switch (WhenMappings.$EnumSwitchMapping$0[period.ordinal()]) {
            case 1 -> this.toUTC(date).truncatedTo(ChronoUnit.SECONDS);
            case 2 -> this.toUTC(date).truncatedTo(ChronoUnit.MINUTES);
            case 3 -> this.toUTC(date).truncatedTo(ChronoUnit.HOURS);
            case 4 -> this.toUTC(date).truncatedTo(ChronoUnit.DAYS);
            case 5 -> this.toUTC(date).truncatedTo(ChronoUnit.MONTHS);
            case 6 -> this.toUTC(date).truncatedTo(ChronoUnit.YEARS);
            default -> throw new NoWhenBranchMatchedException();
        };
        return new Timestamp(start2.toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    @NotNull
    public final Timestamp plus(@NotNull Timestamp timestamp, @NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return switch (WhenMappings.$EnumSwitchMapping$0[period.ordinal()]) {
            case 1 -> timestamp.plus(Duration.Companion.seconds(number));
            case 2 -> timestamp.plus(Duration.Companion.minutes(number));
            case 3 -> timestamp.plus(Duration.Companion.hours(number));
            case 4 -> timestamp.plus(Duration.Companion.days(number));
            case 5 -> {
                LocalDateTime v1 = this.toUTC(TimestampKt.toDate(timestamp)).plusMonths(number);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"timestamp.toDate().toUTC\u2026usMonths(number.toLong())");
                yield this.toTimestamp(v1);
            }
            case 6 -> {
                LocalDateTime v2 = this.toUTC(TimestampKt.toDate(timestamp)).plusYears(number);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"timestamp.toDate().toUTC\u2026lusYears(number.toLong())");
                yield this.toTimestamp(v2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Timestamp minus(@NotNull Timestamp timestamp, @NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return switch (WhenMappings.$EnumSwitchMapping$0[period.ordinal()]) {
            case 1 -> timestamp.minus(Duration.Companion.seconds(number));
            case 2 -> timestamp.minus(Duration.Companion.minutes(number));
            case 3 -> timestamp.minus(Duration.Companion.hours(number));
            case 4 -> timestamp.minus(Duration.Companion.days(number));
            case 5 -> {
                LocalDateTime v1 = this.toUTC(TimestampKt.toDate(timestamp)).minusMonths(number);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"timestamp.toDate().toUTC\u2026usMonths(number.toLong())");
                yield this.toTimestamp(v1);
            }
            case 6 -> {
                LocalDateTime v2 = this.toUTC(TimestampKt.toDate(timestamp)).minusYears(number);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"timestamp.toDate().toUTC\u2026nusYears(number.toLong())");
                yield this.toTimestamp(v2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Timestamp ofFullDate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LocalDate localDate = LocalDate.parse(value);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(value)");
        return this.toTimestamp(localDate);
    }

    private final LocalDateTime toUTC(Date $this$toUTC) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant($this$toUTC.toInstant(), ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(toInstant(), ZoneOffset.UTC)");
        return localDateTime;
    }

    private final Timestamp toTimestamp(LocalDate $this$toTimestamp) {
        return new Timestamp($this$toTimestamp.toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC) * (long)1000);
    }

    private final Timestamp toTimestamp(LocalDateTime $this$toTimestamp) {
        return new Timestamp($this$toTimestamp.toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimePeriod.values().length];
            try {
                nArray[TimePeriod.Second.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimePeriod.Minute.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimePeriod.Hour.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimePeriod.Day.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimePeriod.Month.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimePeriod.Year.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

