/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.AbiSignatures;
import org.jetbrains.kotlin.library.abi.AbiTypeParameter;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.impl.FlagFieldEx;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@ExperimentalLibraryAbiReader
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 +2\u00020\u0001:\u0001+BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiConstructorImpl;", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "qualifiedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "signatures", "Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "annotations", "", "isInline", "", "contextReceiverParametersCount", "", "valueParameters", "", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameter;", "(Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;Lorg/jetbrains/kotlin/library/abi/AbiSignatures;Ljava/util/Set;ZILjava/util/List;)V", "getContextReceiverParametersCount", "()I", "flags", "hasExtensionReceiverParameter", "getHasExtensionReceiverParameter", "()Z", "isConstructor", "isSuspend", "modality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "getModality", "()Lorg/jetbrains/kotlin/library/abi/AbiModality;", "getQualifiedName", "()Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "returnType", "", "getReturnType", "()Ljava/lang/Void;", "getSignatures", "()Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "typeParameters", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParameter;", "getTypeParameters", "()Ljava/util/List;", "getValueParameters", "hasAnnotation", "annotationClassName", "Companion", "kotlin-util-klib-abi"})
public final class AbiConstructorImpl
implements AbiFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbiQualifiedName qualifiedName;
    @NotNull
    private final AbiSignatures signatures;
    @NotNull
    private final Set<AbiQualifiedName> annotations;
    @NotNull
    private final List<AbiValueParameter> valueParameters;
    private final int flags;
    private static final Flags.BooleanFlagField IS_INLINE;
    @NotNull
    private static final FlagFieldEx<Integer> CONTEXT_RECEIVERS_COUNT;

    public AbiConstructorImpl(@NotNull AbiQualifiedName qualifiedName, @NotNull AbiSignatures signatures2, @NotNull Set<AbiQualifiedName> annotations2, boolean isInline, int contextReceiverParametersCount, @NotNull List<? extends AbiValueParameter> valueParameters2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)signatures2, (String)"signatures");
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter(valueParameters2, (String)"valueParameters");
        this.qualifiedName = qualifiedName;
        this.signatures = signatures2;
        this.annotations = annotations2;
        this.valueParameters = valueParameters2;
        this.flags = IS_INLINE.toFlags(Boolean.valueOf(isInline)) | CONTEXT_RECEIVERS_COUNT.toFlags(contextReceiverParametersCount);
    }

    @Override
    @NotNull
    public AbiQualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @NotNull
    public AbiSignatures getSignatures() {
        return this.signatures;
    }

    @Override
    @NotNull
    public List<AbiValueParameter> getValueParameters() {
        return this.valueParameters;
    }

    @Override
    @NotNull
    public AbiModality getModality() {
        return AbiModality.FINAL;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isInline() {
        Boolean bl = IS_INLINE.get(this.flags);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        return bl;
    }

    @Override
    public boolean isSuspend() {
        return false;
    }

    @Override
    public boolean getHasExtensionReceiverParameter() {
        return false;
    }

    @Override
    public int getContextReceiverParametersCount() {
        return ((Number)CONTEXT_RECEIVERS_COUNT.get(this.flags)).intValue();
    }

    @Nullable
    public Void getReturnType() {
        return null;
    }

    @Override
    @NotNull
    public List<AbiTypeParameter> getTypeParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean hasAnnotation(@NotNull AbiQualifiedName annotationClassName) {
        Intrinsics.checkNotNullParameter((Object)annotationClassName, (String)"annotationClassName");
        return this.annotations.contains(annotationClassName);
    }

    static {
        Flags.BooleanFlagField booleanFlagField = IS_INLINE = Flags.FlagField.booleanFirst();
        Intrinsics.checkNotNullExpressionValue((Object)booleanFlagField, (String)"IS_INLINE");
        CONTEXT_RECEIVERS_COUNT = FlagFieldEx.Companion.intAfter((Flags.FlagField)booleanFlagField, 8);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiConstructorImpl$Companion;", "", "()V", "CONTEXT_RECEIVERS_COUNT", "Lorg/jetbrains/kotlin/library/abi/impl/FlagFieldEx;", "", "IS_INLINE", "Lorg/jetbrains/kotlin/metadata/deserialization/Flags$BooleanFlagField;", "kotlin.jvm.PlatformType", "kotlin-util-klib-abi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

