/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a'\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u000e\b\u0004\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u000e\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0002\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\r\u001a\u001b\u0010\u0012\u001a\u00020\u0010*\u00020\u000e\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION", "", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "script", "Lkotlin/script/experimental/api/SourceCode;", "runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "isKotlinFileType", "", "isNonScript", "isScript", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin-scripting-compiler-impl"})
@SourceDebugExtension(value={"SMAP\ndefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 definitions.kt\norg/jetbrains/kotlin/scripting/definitions/DefinitionsKt\n*L\n1#1,103:1\n29#1:104\n*S KotlinDebug\n*F\n+ 1 definitions.kt\norg/jetbrains/kotlin/scripting/definitions/DefinitionsKt\n*L\n61#1:104\n*E\n"})
public final class DefinitionsKt {
    @NotNull
    private static final String JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION = ".class";

    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runReadAction = false;
        return (T)ApplicationManager.getApplication().runReadAction(new Computable(runnable){
            final /* synthetic */ Function0<T> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
        });
    }

    public static final boolean isScript(@NotNull PsiFile $this$isScript) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        Intrinsics.checkNotNullParameter((Object)$this$isScript, (String)"<this>");
        if (!($this$isScript instanceof KtFile)) {
            return false;
        }
        VirtualFile virtualFile4 = ((KtFile)$this$isScript).getVirtualFile();
        if (virtualFile4 == null) {
            virtualFile4 = virtualFile3 = ((KtFile)$this$isScript).getOriginalFile().getVirtualFile();
        }
        if (virtualFile4 == null) {
            VirtualFile virtualFile5 = ((KtFile)$this$isScript).getViewProvider().getVirtualFile();
            virtualFile3 = virtualFile5;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"getVirtualFile(...)");
        }
        return !DefinitionsKt.isNonScript(virtualFile2 = virtualFile3);
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull PsiFile $this$findScriptDefinition) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        if (DefinitionsKt.isScript($this$findScriptDefinition)) {
            Project project2 = ((KtFile)$this$findScriptDefinition).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            scriptDefinition = DefinitionsKt.findScriptDefinition(project2, new KtFileScriptSource((KtFile)$this$findScriptDefinition, null, 2, null));
        } else {
            scriptDefinition = null;
        }
        return scriptDefinition;
    }

    @Deprecated(message="Use PsiFile.findScriptDefinition() instead")
    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull VirtualFile $this$findScriptDefinition, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!$this$findScriptDefinition.isValid() || DefinitionsKt.isNonScript($this$findScriptDefinition)) {
            return null;
        }
        boolean $i$f$runReadAction = false;
        if (ApplicationManager.getApplication().runReadAction(new Computable(project2, $this$findScriptDefinition){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $this_findScriptDefinition$inlined;
            {
                this.$project$inlined = project2;
                this.$this_findScriptDefinition$inlined = virtualFile2;
            }

            public final T compute() {
                boolean bl = false;
                PsiFile psiFile2 = PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$this_findScriptDefinition$inlined);
                return (T)(psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null);
            }
        }) == null) {
            return null;
        }
        return DefinitionsKt.findScriptDefinition(project2, new VirtualFileScriptSource($this$findScriptDefinition, null, 2, null));
    }

    @NotNull
    public static final ScriptDefinition findScriptDefinition(@NotNull Project project2, @NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project2);
        if (scriptDefinitionProvider == null) {
            throw new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.".toString());
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        ScriptDefinition scriptDefinition = scriptDefinitionProvider2.findDefinition(script);
        if (scriptDefinition == null) {
            ScriptDefinition scriptDefinition2;
            ScriptDefinition it = scriptDefinition2 = scriptDefinitionProvider2.getDefaultDefinition();
            boolean bl = false;
            Logger.getInstance((String)"org.jetbrains.kotlin.scripting.definitions").debug("Default definition is used for " + script.getLocationId());
            scriptDefinition = scriptDefinition2;
        }
        return scriptDefinition;
    }

    public static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNonScript, (String)"<this>");
        if ($this$isNonScript instanceof VirtualFileWindow) {
            bl = !DefinitionsKt.isKotlinFileType($this$isNonScript);
        } else if ($this$isNonScript.isDirectory()) {
            bl = true;
        } else {
            CharSequence charSequence = $this$isNonScript.getNameSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
            CharSequence nameSeq = charSequence;
            bl = StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION, (boolean)false, (int)2, null) || !DefinitionsKt.isKotlinFileType($this$isNonScript);
        }
        return bl;
    }

    private static final boolean isKotlinFileType(VirtualFile $this$isKotlinFileType) {
        CharSequence charSequence = $this$isKotlinFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)KotlinParserDefinition.STD_SCRIPT_EXT, (boolean)false, (int)2, null)) {
            return true;
        }
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFile($this$isKotlinFileType), (Object)KotlinFileType.INSTANCE) || Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), (Object)KotlinFileType.INSTANCE);
    }
}

