/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.symbols.UtilsKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKParenthesizedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKSuperExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.types.JKJavaPrimitiveType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/EqualsOperatorConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "kotlin.j2k.new"})
public final class EqualsOperatorConversion
extends RecursiveApplicableConversionBase {
    public EqualsOperatorConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        JKExpression right;
        JKExpression left;
        block11: {
            block10: {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (!(element3 instanceof JKQualifiedExpression)) {
                    return this.recurse(element3);
                }
                if (((JKQualifiedExpression)element3).getReceiver() instanceof JKSuperExpression) {
                    return this.recurse(element3);
                }
                JKExpression jKExpression = ((JKQualifiedExpression)element3).getSelector();
                JKCallExpression jKCallExpression = jKExpression instanceof JKCallExpression ? (JKCallExpression)jKExpression : null;
                if (jKCallExpression == null) {
                    return this.recurse(element3);
                }
                JKCallExpression selector2 = jKCallExpression;
                List<JKArgument> arguments2 = selector2.getArguments().getArguments();
                String functionFqName = UtilsKt.deepestFqName(selector2.getIdentifier());
                if (Intrinsics.areEqual((Object)functionFqName, (Object)"java.lang.Object.equals") && arguments2.size() == 1) {
                    pair = TuplesKt.to((Object)((JKQualifiedExpression)element3).getReceiver(), (Object)arguments2.get(0).getValue());
                } else if (Intrinsics.areEqual((Object)functionFqName, (Object)"java.util.Objects.equals") && arguments2.size() == 2) {
                    pair = TuplesKt.to((Object)arguments2.get(0).getValue(), (Object)arguments2.get(1).getValue());
                } else {
                    return this.recurse(element3);
                }
                Pair pair2 = pair;
                left = (JKExpression)pair2.component1();
                right = (JKExpression)pair2.component2();
                JKElement jKElement = left.getParent();
                Intrinsics.checkNotNull((Object)jKElement);
                left.detach(jKElement);
                JKElement jKElement2 = right.getParent();
                Intrinsics.checkNotNull((Object)jKElement2);
                right.detach(jKElement2);
                JKType jKType = left.calculateType(this.getTypeFactory());
                JKJavaPrimitiveType leftType = jKType != null ? TypesUtilsKt.asPrimitiveType(jKType) : null;
                JKType jKType2 = right.calculateType(this.getTypeFactory());
                JKJavaPrimitiveType rightType = jKType2 != null ? TypesUtilsKt.asPrimitiveType(jKType2) : null;
                JKJavaPrimitiveType jKJavaPrimitiveType = leftType;
                if (jKJavaPrimitiveType != null ? TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType) : false) break block10;
                JKJavaPrimitiveType jKJavaPrimitiveType2 = rightType;
                boolean bl = jKJavaPrimitiveType2 != null ? TypesUtilsKt.isFloatingPoint(jKJavaPrimitiveType2) : false;
                if (!bl) break block11;
            }
            return this.recurse(element3);
        }
        return this.recurse((JKTreeElement)new JKParenthesizedExpression(ExpressionsKt.equalsExpression(left, right, this.getTypeFactory()), null, false, 6, null));
    }
}

