/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spellchecker;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/spellchecker/KotlinSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "()V", "emptyTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lcom/intellij/psi/PsiElement;", "plainTextTokenizer", "getTokenizer", "element", "kotlin.spellchecker"})
public final class KotlinSpellcheckingStrategy
extends SpellcheckingStrategy {
    @NotNull
    private final Tokenizer<PsiElement> plainTextTokenizer = (Tokenizer)new TokenizerBase((Splitter)PlainTextSplitter.getInstance());
    @NotNull
    private final Tokenizer<PsiElement> emptyTokenizer;

    public KotlinSpellcheckingStrategy() {
        Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        this.emptyTokenizer = tokenizer;
    }

    @NotNull
    public Tokenizer<? extends PsiElement> getTokenizer(@Nullable PsiElement element3) {
        Tokenizer tokenizer;
        if (element3 instanceof PsiComment) {
            Tokenizer tokenizer2 = super.getTokenizer(element3);
            tokenizer = tokenizer2;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer2, (String)"getTokenizer(...)");
        } else if (element3 instanceof KtParameter) {
            PsiElement psiElement2 = ((KtParameter)element3).getParent();
            KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
            PsiElement psiElement3 = ktParameterList != null ? ktParameterList.getParent() : null;
            KtNamedFunction function2 = psiElement3 instanceof KtNamedFunction ? (KtNamedFunction)psiElement3 : null;
            KtNamedFunction ktNamedFunction = function2;
            boolean bl = ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false;
            if (bl) {
                tokenizer = this.emptyTokenizer;
            } else {
                Tokenizer tokenizer3 = super.getTokenizer(element3);
                tokenizer = tokenizer3;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer3, (String)"getTokenizer(...)");
            }
        } else if (element3 instanceof PsiNameIdentifierOwner) {
            if (element3 instanceof KtModifierListOwner && ((KtModifierListOwner)element3).hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                tokenizer = this.emptyTokenizer;
            } else {
                Tokenizer tokenizer4 = super.getTokenizer(element3);
                tokenizer = tokenizer4;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer4, (String)"getTokenizer(...)");
            }
        } else {
            tokenizer = element3 instanceof KtLiteralStringTemplateEntry && !SpellcheckingStrategy.isInjectedLanguageFragment((PsiElement)((KtLiteralStringTemplateEntry)element3).getParent()) ? this.plainTextTokenizer : this.emptyTokenizer;
        }
        return tokenizer;
    }
}

