/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.codeInsight.compiler.KtCompilerFacilityUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 J5\u0010!\u001a\u00020\u001e2\b\b\u0001\u0010\"\u001a\u00020\u00182!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u001e0$H\u0002J \u0010(\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\fH\u0002JL\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0006\u0010/\u001a\u00020\u001eJ.\u00100\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compileFileToTempDir", "Ljava/io/File;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "createCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "createFileWithLightClassSupport", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "execute", "", "callback", "Lkotlin/Function0;", "executeInBackground", "title", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "indicator", "reportError", "e", "", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScratchSourceFile", "stop", "tryRunCommandLine", "Companion", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKtScratchExecutionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchExecutionSession.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n27#2,2:215\n55#3:217\n69#3,8:218\n1549#4:226\n1620#4,3:227\n*S KotlinDebug\n*F\n+ 1 KtScratchExecutionSession.kt\norg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession\n*L\n158#1:215,2\n158#1:217\n158#1:218,8\n206#1:226\n206#1:227,3\n*E\n"})
public final class KtScratchExecutionSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchFile file;
    @NotNull
    private final KtCompilingExecutor executor;
    @Nullable
    private volatile ProgressIndicator backgroundProcessIndicator;
    private static final int TIMEOUT_MS = 30000;

    public KtScratchExecutionSession(@NotNull ScratchFile file2, @NotNull KtCompilingExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.file = file2;
        this.executor = executor;
    }

    public final void execute(@NotNull Function0<Unit> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        KtFile ktFile = this.file.getKtScratchFile();
        if (ktFile == null) {
            ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
            return;
        }
        KtFile psiFile2 = ktFile;
        List<ScratchExpression> expressions2 = this.file.getExpressions();
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return;
        }
        KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtScratchSourceFileProcessor.Result>(expressions2){
            final /* synthetic */ List<ScratchExpression> $expressions;
            {
                this.$expressions = $expressions;
                super(0);
            }

            @NotNull
            public final KtScratchSourceFileProcessor.Result invoke() {
                return new KtScratchSourceFileProcessor().process(this.$expressions);
            }
        }));
        if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
            ScratchExecutor.errorOccurs$default(this.executor, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
            return;
        }
        if (result2 instanceof KtScratchSourceFileProcessor.Result.OK) {
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            this.executeInBackground(KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this, result2, psiFile2, callback2){
                final /* synthetic */ KtScratchExecutionSession this$0;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ Function0<Unit> $callback;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$psiFile = $psiFile;
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    KtScratchExecutionSession.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    KtFile modifiedScratchSourceFile = KtScratchExecutionSession.access$createFileWithLightClassSupport(this.this$0, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$psiFile);
                    KtScratchExecutionSession.access$tryRunCommandLine(this.this$0, modifiedScratchSourceFile, this.$psiFile, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$callback);
                }
            }));
        }
    }

    private final void executeInBackground(@NlsContexts.ProgressTitle String title, Function1<? super ProgressIndicator, Unit> block2) {
        Project project2 = this.file.getProject();
        new Task.Backgroundable(title, block2, project2){
            final /* synthetic */ Function1<ProgressIndicator, Unit> $block;
            {
                this.$block = $block;
                super($super_call_param$1, $title, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$block.invoke((Object)indicator);
            }
        }.queue();
    }

    private final KtFile createFileWithLightClassSupport(KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        return (KtFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(psiFile2, result2){
            final /* synthetic */ KtFile $psiFile;
            final /* synthetic */ KtScratchSourceFileProcessor.Result.OK $result;
            {
                this.$psiFile = $psiFile;
                this.$result = $result;
                super(0);
            }

            @NotNull
            public final KtFile invoke() {
                return KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)this.$psiFile), (boolean)false, (int)2, null).createPhysicalFile("tmp.kt", this.$result.getCode());
            }
        }));
    }

    private final void tryRunCommandLine(KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0<Unit> callback2) {
        boolean bl;
        boolean bl2 = bl = this.backgroundProcessIndicator != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            Project project2 = this.file.getProject();
            List<ScratchExpression> list2 = this.file.getExpressions();
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            this.runCommandLine(project2, modifiedScratchSourceFile, list2, psiFile2, result2, progressIndicator, callback2);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.reportError(result2, e, psiFile2);
        }
    }

    private final void reportError(KtScratchSourceFileProcessor.Result.OK result2, Throwable e, KtFile psiFile2) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), result2.getCode());
        String string = e.getMessage();
        if (string == null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
            string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
        }
        this.executor.errorOccurs(string, e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runCommandLine(Project project2, KtFile modifiedScratchSourceFile, List<ScratchExpression> expressions2, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback2) {
        File file2 = (File)DumbService.Companion.getInstance(project2).runReadActionInSmartMode(() -> KtScratchExecutionSession.runCommandLine$lambda$0(this, modifiedScratchSourceFile, expressions2));
        if (file2 == null) {
            return;
        }
        File tempDir = file2;
        try {
            Module module2 = this.file.getModule();
            String string = result2.getMainClassName();
            String string2 = tempDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = this.createCommandLine(psiFile2, module2, string, string2);
            TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine commandLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment = environmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
            String commandLinePresentation = commandLine.getCommandPresentation(environment);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), commandLinePresentation);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(environment.createProcess(commandLine, indicator), null, commandLinePresentation);
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
            ProcessOutput executionResult = processOutput;
            if (executionResult.isTimeout()) {
                Object[] objectArray = new Object[]{30000};
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", objectArray), null, false, 6, null);
            } else if (!executionResult.isCancelled()) {
                this.executor.parseOutput(executionResult, expressions2);
            }
        }
        finally {
            tempDir.delete();
            callback2.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File compileFileToTempDir(KtFile psiFile2, List<ScratchExpression> expressions2) {
        Object result2;
        Object object;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return null;
        }
        File file2 = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(...)");
        File tmpDir = file2;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + tmpDir.getPath());
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)psiFile2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        void var8_8 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)psiFile2);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            Object object2;
            KtAnalysisSession $this$compileFileToTempDir_u24lambda_u242 = analysisSession$iv$iv$iv;
            boolean bl = false;
            CompilerConfiguration $this$compileFileToTempDir_u24lambda_u242_u24lambda_u241 = object2 = new CompilerConfiguration();
            boolean bl2 = false;
            Module containingModule = GenericPsiUtils.getModule((PsiElement)psiFile2);
            if (containingModule != null) {
                $this$compileFileToTempDir_u24lambda_u242_u24lambda_u241.put(CommonConfigurationKeys.MODULE_NAME, (Object)containingModule.getName());
            }
            $this$compileFileToTempDir_u24lambda_u242_u24lambda_u241.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)psiFile2));
            CompilerConfiguration configuration2 = object2;
            try {
                ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
                Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"BINARIES");
                KtCompilerTarget.Jvm compilerTarget = new KtCompilerTarget.Jvm(classBuilderFactory);
                Function1 allowedErrorFilter2 = compileFileToTempDir.result.1.allowedErrorFilter.1.INSTANCE;
                object2 = KtCompilerFacilityUtils.compileToDirectory($this$compileFileToTempDir_u24lambda_u242, psiFile2, configuration2, compilerTarget, (Function1<? super KtDiagnostic, Boolean>)allowedErrorFilter2, tmpDir);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ScratchUtilsKt.getLOG().error(e);
                File file3 = null;
                this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                return file3;
            }
            object = object2;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        Object object3 = result2 = object;
        if (object3 instanceof KtCompilationResult.Failure) {
            ScratchUtilsKt.getLOG().warn("Errors found on analyzing the scratch file. Compilation aborted");
            return null;
        }
        if (object3 instanceof KtCompilationResult.Success) {
            return tmpDir;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TargetEnvironmentRequest, TargetedCommandLine> createCommandLine(KtFile originalFile2, Module module2, String mainClassName, String tempOutDir) {
        WslTargetEnvironmentConfiguration wslConfiguration;
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        Project project2 = originalFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        JavaParameters javaParameters = new JavaParametersBuilder(project2).withSdkFrom(module2, true).withMainClassName(mainClassName).build();
        javaParameters.getClassPath().add(tempOutDir);
        if (module2 != null) {
            javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module2));
        }
        Project project3 = originalFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = ScriptConfigurationManager.Companion.getInstance(project3).getConfiguration(originalFile2);
        if (scriptCompilationConfigurationWrapper != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper;
            boolean bl = false;
            Iterable iterable = it.getDependenciesClassPath();
            PathsList pathsList = javaParameters.getClassPath();
            boolean $i$f$map = false;
            void var13_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void f2;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(f2.getAbsolutePath());
            }
            pathsList.addAll((List)destination$iv$iv);
        }
        if ((wslTargetEnvironmentConfiguration = (wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk()))) == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(originalFile2.getProject())) == null) {
            wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        WslTargetEnvironmentConfiguration request2 = wslTargetEnvironmentConfiguration;
        return TuplesKt.to((Object)request2, (Object)javaParameters.toCommandLine((TargetEnvironmentRequest)request2).build());
    }

    private static final File runCommandLine$lambda$0(KtScratchExecutionSession this$0, KtFile $modifiedScratchSourceFile, List $expressions) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifiedScratchSourceFile, (String)"$modifiedScratchSourceFile");
        Intrinsics.checkNotNullParameter((Object)$expressions, (String)"$expressions");
        return this$0.compileFileToTempDir($modifiedScratchSourceFile, $expressions);
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtScratchExecutionSession $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ KtFile access$createFileWithLightClassSupport(KtScratchExecutionSession $this, KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        return $this.createFileWithLightClassSupport(result2, psiFile2);
    }

    public static final /* synthetic */ void access$tryRunCommandLine(KtScratchExecutionSession $this, KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0 callback2) {
        $this.tryRunCommandLine(modifiedScratchSourceFile, psiFile2, result2, (Function0<Unit>)callback2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "()V", "TIMEOUT_MS", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

