/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceProvider;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceRegistrar;
import org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0011R\"\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtIdeReferenceProviderService;", "Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "originalProvidersBinding", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/references/KotlinPsiReferenceProvider;", "providersBindingCache", "", "", "doGetKotlinReferencesFromProviders", "", "Lcom/intellij/psi/PsiReference;", "context", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getReferences", "psiElement", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nKtIdeReferenceProviderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtIdeReferenceProviderService.kt\norg/jetbrains/kotlin/idea/references/KtIdeReferenceProviderService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n37#2,2:74\n*S KotlinDebug\n*F\n+ 1 KtIdeReferenceProviderService.kt\norg/jetbrains/kotlin/idea/references/KtIdeReferenceProviderService\n*L\n57#1:74,2\n*E\n"})
public final class KtIdeReferenceProviderService
extends KotlinReferenceProvidersService {
    @NotNull
    private final MultiMap<Class<? extends PsiElement>, KotlinPsiReferenceProvider> originalProvidersBinding;
    @NotNull
    private final Map<Class<? extends PsiElement>, List<KotlinPsiReferenceProvider>> providersBindingCache;

    public KtIdeReferenceProviderService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KotlinPsiReferenceRegistrar registrar2 = new KotlinPsiReferenceRegistrar();
        KotlinReferenceProviderContributor.Companion.getInstance(project2).registerReferenceProviders(registrar2);
        this.originalProvidersBinding = registrar2.getProviders();
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> KtIdeReferenceProviderService._init_$lambda$0((Function1)new Function1<Class<? extends PsiElement>, List<? extends KotlinPsiReferenceProvider>>(){

            public final List<KotlinPsiReferenceProvider> invoke(Class<? extends PsiElement> klass2) {
                SmartList result2 = new SmartList();
                for (Class bindingClass : originalProvidersBinding.keySet()) {
                    if (!bindingClass.isAssignableFrom(klass2)) continue;
                    result2.addAll(originalProvidersBinding.get((Object)bindingClass));
                }
                return (List)result2;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.providersBindingCache = concurrentMap;
    }

    private final PsiReference[] doGetKotlinReferencesFromProviders(PsiElement context2) {
        List<KotlinPsiReferenceProvider> providers2 = this.providersBindingCache.get(context2.getClass());
        Collection collection = providers2;
        if (collection == null || collection.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (KotlinPsiReferenceProvider provider2 : providers2) {
            try {
                CollectionsKt.addAll((Collection)((Collection)result2), (Object[])provider2.getReferencesByElement(context2));
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        }
        if (result2.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Collection $this$toTypedArray$iv = (Collection)result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        if (psiElement2 instanceof ContributedReferenceHost) {
            PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)psiElement2, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesFromProviders(...)");
            return psiReferenceArray;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)psiElement2, () -> KtIdeReferenceProviderService.getReferences$lambda$1(this, psiElement2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (PsiReference[])object;
    }

    private static final List _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getReferences$lambda$1(KtIdeReferenceProviderService this$0, PsiElement $psiElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiElement, (String)"$psiElement");
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.doGetKotlinReferencesFromProviders($psiElement), (Object[])objectArray);
    }
}

