/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameLightElementsHelper;", "", "()V", "renameFacadeLightClass", "Lcom/intellij/psi/PsiElement;", "classForFacade", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForFacade;", "name", "", "renameLightMethod", "", "lightMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameLightElementsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameLightElementsHelper.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameLightElementsHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n179#2,2:94\n*S KotlinDebug\n*F\n+ 1 RenameLightElementsHelper.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameLightElementsHelper\n*L\n79#1:94,2\n*E\n"})
public final class RenameLightElementsHelper {
    @NotNull
    public static final RenameLightElementsHelper INSTANCE = new RenameLightElementsHelper();

    private RenameLightElementsHelper() {
    }

    public final void renameLightMethod(@NotNull KtLightMethod lightMethod, @NotNull String name2) {
        KtStringTemplateExpression nameExpression2;
        String demangledName;
        String string;
        Intrinsics.checkNotNullParameter((Object)lightMethod, (String)"lightMethod");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PsiAnnotation jvmNameAnnotation = lightMethod.getModifierList().findAnnotation(JvmStandardClassIds.JVM_NAME.asString());
        String string2 = lightMethod.isMangled() ? KotlinRenameRefactoringSupport.Companion.getInstance().demangleInternalName(name2) : null;
        if (string2 == null) {
            string2 = name2;
        }
        if ((string = LightClassUtilsKt.propertyNameByAccessor((String)(demangledName = string2), (KtLightMethod)lightMethod)) == null) {
            string = demangledName;
        }
        String newNameForOrigin = string;
        KtDeclaration ktDeclaration2 = (KtDeclaration)lightMethod.getKotlinOrigin();
        if (Intrinsics.areEqual((Object)newNameForOrigin, (Object)(ktDeclaration2 != null ? ktDeclaration2.getName() : null))) {
            PsiAnnotation psiAnnotation = jvmNameAnnotation;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
            return;
        }
        PsiAnnotation psiAnnotation = jvmNameAnnotation;
        PsiElement psiElement2 = psiAnnotation != null && (psiAnnotation = psiAnnotation.findAttributeValue("name")) != null ? LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)psiAnnotation)) : null;
        KtStringTemplateExpression ktStringTemplateExpression = nameExpression2 = psiElement2 instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)psiElement2 : null;
        if (nameExpression2 != null) {
            Project project2 = lightMethod.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            nameExpression2.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createStringTemplate(name2));
        } else {
            KtElement ktElement = lightMethod.getKotlinOrigin();
            PsiNamedElement psiNamedElement = ktElement instanceof PsiNamedElement ? (PsiNamedElement)ktElement : null;
            if (psiNamedElement == null) {
                return;
            }
            PsiNamedElement toRename = psiNamedElement;
            toRename.setName(newNameForOrigin);
        }
    }

    @NotNull
    public final PsiElement renameFacadeLightClass(@NotNull KtLightClassForFacade classForFacade, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)classForFacade, (String)"classForFacade");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        for (KtFile file2 : classForFacade.getFiles()) {
            KtStringTemplateExpression jvmNameExpression;
            KtAnnotationEntry jvmNameEntry = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve((KtFile)file2, (String)JvmStandardClassIds.INSTANCE.getJVM_NAME_SHORT());
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (Intrinsics.areEqual((Object)PackagePartClassUtils.getFilePartShortName((String)string), (Object)name2)) {
                KtAnnotationEntry ktAnnotationEntry = jvmNameEntry;
                if (ktAnnotationEntry != null) {
                    ktAnnotationEntry.delete();
                }
                continue;
            }
            if (jvmNameEntry == null) {
                Object v5;
                KtFileAnnotationList newFileAnnotationList;
                block7: {
                    String newFileName = PackagePartClassUtils.getFileNameByFacadeName((String)name2);
                    PsiDirectory facadeDir = file2.getParent();
                    if (newFileName != null && facadeDir != null && facadeDir.findFile(newFileName) == null) {
                        file2.setName(newFileName);
                        continue;
                    }
                    Project project2 = classForFacade.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
                    String annotationText2 = JvmStandardClassIds.INSTANCE.getJVM_NAME_SHORT() + "(\"" + name2 + "\")";
                    newFileAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(annotationText2);
                    KtFileAnnotationList annotationList = file2.getFileAnnotationList();
                    if (annotationList != null) {
                        List list2 = newFileAnnotationList.getAnnotationEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                        annotationList.add((PsiElement)CollectionsKt.first((List)list2));
                        continue;
                    }
                    PsiElement psiElement2 = file2.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
                    Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings$default((PsiElement)psiElement2, (boolean)false, (boolean)false, (int)3, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                        v5 = element$iv;
                        break block7;
                    }
                    v5 = null;
                }
                PsiElement anchor = v5;
                file2.addBefore((PsiElement)newFileAnnotationList, anchor);
                continue;
            }
            List list3 = jvmNameEntry.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
            ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list3);
            KtExpression ktExpression = valueArgument != null ? valueArgument.getArgumentExpression() : null;
            if ((ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null) == null) continue;
            jvmNameExpression = jvmNameExpression;
            ElementManipulators.handleContentChange((PsiElement)((PsiElement)jvmNameExpression), (String)name2);
        }
        return (PsiElement)classForFacade;
    }
}

