/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticFileRenamer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "()V", "createRenamer", "Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamer;", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "getOptionName", "isApplicable", "", "isEnabled", "setEnabled", "", "enabled", "kotlin.refactorings.common"})
public class AutomaticFileRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof KtNamedFunction) && !(element3 instanceof KtVariableDeclaration)) {
            return false;
        }
        PsiFile psiFile2 = element3.getContainingFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        Object object = CollectionsKt.singleOrNull((List)file2.getDeclarations());
        KtNamedDeclaration ktNamedDeclaration = object instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        return Intrinsics.areEqual((Object)declaration2.getName(), (Object)file2.getVirtualFile().getNameWithoutExtension()) && Intrinsics.areEqual((Object)element3, (Object)declaration2);
    }

    @NotNull
    public AutomaticFileRenamer createRenamer(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        PsiFile psiFile2 = element3.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return new AutomaticFileRenamer((KtFile)psiFile2, newName2);
    }

    public boolean isEnabled() {
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRenameFileNames();
    }

    public void setEnabled(boolean enabled2) {
        KotlinCommonRefactoringSettings.Companion.getInstance().setRenameFileNames(enabled2);
    }

    @Nullable
    public String getOptionName() {
        return KotlinBundle.message("rename.file", new Object[0]);
    }
}

