/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.unifier.KotlinPsiRange;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a(\u0010\r\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"processDuplicates", "", "duplicateReplacers", "", "Lorg/jetbrains/kotlin/idea/base/psi/unifier/KotlinPsiRange;", "Lkotlin/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "scopeDescription", "", "usageDescription", "processDuplicatesSilently", "highlight", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "preview", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nduplicateUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 duplicateUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/DuplicateUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n3792#2:115\n4307#2,2:116\n77#3:118\n77#3:119\n1#4:120\n1855#5,2:121\n*S KotlinDebug\n*F\n+ 1 duplicateUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/DuplicateUtilKt\n*L\n39#1:115\n39#1:116,2\n65#1:118\n93#1:119\n43#1:121,2\n*E\n"})
public final class DuplicateUtilKt {
    @Nullable
    public static final RangeHighlighter highlight(@NotNull KotlinPsiRange $this$highlight, @NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)$this$highlight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextRange textRange = IntroduceUtilKt.getPhysicalTextRange($this$highlight);
        ArrayList highlighters = new ArrayList();
        HighlightManager.getInstance((Project)project2).addRangeHighlight(editor2, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, (Collection)highlighters);
        return (RangeHighlighter)CollectionsKt.firstOrNull((List)highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangeHighlighter preview(@NotNull KotlinPsiRange $this$preview, @NotNull Project project2, @NotNull Editor editor2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$preview, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        RangeHighlighter rangeHighlighter = DuplicateUtilKt.highlight($this$preview, project2, editor2);
        if (rangeHighlighter == null) {
            return null;
        }
        RangeHighlighter highlight = rangeHighlighter;
        int startOffset = IntroduceUtilKt.getPhysicalTextRange($this$preview).getStartOffset();
        FoldRegion[] foldRegionArray = CodeFoldingManager.getInstance((Project)project2).getFoldRegionsAtOffset(editor2, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getFoldRegionsAtOffset(...)");
        Object[] objectArray = foldRegionArray;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            FoldRegion it = (FoldRegion)element$iv$iv;
            boolean bl = false;
            if (!(!it.isExpanded())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List foldedRegions = (List)destination$iv$iv;
        if (!foldedRegions.isEmpty()) {
            editor2.getFoldingModel().runBatchFoldingOperation(() -> DuplicateUtilKt.preview$lambda$2(foldedRegions));
        }
        editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
        return highlight;
    }

    public static final void processDuplicates(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers2, @NotNull Project project2, @NotNull Editor editor2, @NotNull String scopeDescription, @NotNull String usageDescription) {
        int answer;
        Intrinsics.checkNotNullParameter(duplicateReplacers2, (String)"duplicateReplacers");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scopeDescription, (String)"scopeDescription");
        Intrinsics.checkNotNullParameter((Object)usageDescription, (String)"usageDescription");
        int size = duplicateReplacers2.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            DuplicateUtilKt.preview((KotlinPsiRange)CollectionsKt.first((Iterable)duplicateReplacers2.keySet()), project2, editor2);
        }
        boolean $i$f$isUnitTestMode2 = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            v0 = 0;
        } else {
            Object[] $i$f$isUnitTestMode2 = new Object[4];
            Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getProductName(), (String)"getProductName(...)");
            $i$f$isUnitTestMode2[1] = duplicateReplacers2.size();
            $i$f$isUnitTestMode2[2] = scopeDescription;
            $i$f$isUnitTestMode2[3] = usageDescription;
            v0 = answer = Messages.showYesNoDialog((Project)project2, (String)KotlinBundle.message("0.has.detected.1.code.fragments.in.2.that.can.be.replaced.with.3", $i$f$isUnitTestMode2), (String)KotlinBundle.message("text.process.duplicates", new Object[0]), (Icon)Messages.getQuestionIcon());
        }
        if (answer != 0) {
            return;
        }
        boolean showAll = false;
        Iterator<Map.Entry<KotlinPsiRange, ? extends Function0<Unit>>> iterator2 = duplicateReplacers2.entrySet().iterator();
        int n = 0;
        block5: while (iterator2.hasNext()) {
            int i2 = n++;
            Map.Entry<KotlinPsiRange, ? extends Function0<Unit>> entry = iterator2.next();
            KotlinPsiRange pattern2 = entry.getKey();
            Function0<Unit> replacer = entry.getValue();
            if (!pattern2.isValid()) continue;
            RangeHighlighter highlighter = DuplicateUtilKt.preview(pattern2, project2, editor2);
            boolean $i$f$isUnitTestMode3 = false;
            if (!ApplicationManager.getApplication().isUnitTestMode() && size > 1 && !showAll) {
                Object[] objectArray = new Object[]{i2 + 1, size};
                ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, JavaRefactoringBundle.message((String)"process.duplicates.title", (Object[])objectArray), project2);
                promptDialog.show();
                switch (promptDialog.getExitCode()) {
                    case 3: {
                        showAll = true;
                        break;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            if (highlighter != null) {
                RangeHighlighter it;
                boolean bl = false;
                HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(editor2, it);
            }
            String string = MethodDuplicatesHandler.getRefactoringName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefactoringName(...)");
            ApplicationUtilsKt.executeWriteCommand(project2, string, replacer);
        }
    }

    public static /* synthetic */ void processDuplicates$default(Map map2, Project project2, Editor editor2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string = "this file";
        }
        if ((n & 0x10) != 0) {
            string2 = "a usage of extracted declaration";
        }
        DuplicateUtilKt.processDuplicates(map2, project2, editor2, string, string2);
    }

    public static final void processDuplicatesSilently(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(duplicateReplacers2, (String)"duplicateReplacers");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = MethodDuplicatesHandler.getRefactoringName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefactoringName(...)");
        ApplicationUtilsKt.executeWriteCommand(project2, string, (Function0<Unit>)((Function0)new Function0<Unit>(duplicateReplacers2){
            final /* synthetic */ Map<KotlinPsiRange, Function0<Unit>> $duplicateReplacers;
            {
                this.$duplicateReplacers = $duplicateReplacers;
                super(0);
            }

            public final void invoke() {
                Iterable $this$forEach$iv = this.$duplicateReplacers.values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }));
    }

    private static final void preview$lambda$2(List $foldedRegions) {
        Intrinsics.checkNotNullParameter((Object)$foldedRegions, (String)"$foldedRegions");
        Iterable $this$forEach$iv = $foldedRegions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it = (FoldRegion)element$iv;
            boolean bl = false;
            it.setExpanded(true);
        }
    }
}

