/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineAnonymousFunctionHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "()V", "canInlineKotlinFunction", "", "function", "inlineKotlinFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class KotlinInlineAnonymousFunctionHandler
extends AbstractKotlinInlineFunctionHandler<KtFunction> {
    @Override
    public boolean canInlineKotlinFunction(@NotNull KtFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return ExpressionExtKt.isAnonymousFunction((PsiElement)function2) || function2 instanceof KtFunctionLiteral;
    }

    @Override
    public void inlineKotlinFunction(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFunction function2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        KtExpression call = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function2);
        if (call == null) {
            String string;
            if (function2 instanceof KtFunctionLiteral) {
                var6_5 = new Object[]{this.getRefactoringName()};
                string = KotlinBundle.message("refactoring.cannot.be.applied.to.lambda.expression.without.invocation", var6_5);
            } else {
                var6_5 = new Object[]{this.getRefactoringName()};
                string = KotlinBundle.message("refactoring.cannot.be.applied.to.anonymous.function.without.invocation", var6_5);
            }
            String message2 = string;
            this.showErrorHint(project2, editor2, message2);
            return;
        }
        new KotlinInlineAnonymousFunctionProcessor(function2, call, editor2, project2).run();
    }
}

