/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.sealedSubClassToObject;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.intentions.ConvertSecondaryConstructorToPrimaryIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u0004*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\u0004*\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\u001b\u001a\u00020\fH\u0002J&\u0010\u001c\u001a\u00020\u0004*\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u00020\u0004*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "changeDeclaration", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtClass;", "changeInstances", "getFamilyName", "", "mapReferencesByLanguage", "", "Lcom/intellij/lang/Language;", "", "Lcom/intellij/psi/PsiElement;", "startInWriteAction", "", "changeToObject", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "replaceJava", "klass", "replaceKotlin", "transformToObject", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertSealedSubClassToObjectFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertSealedSubClassToObjectFix.kt\norg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n125#2:130\n1855#3,2:131\n766#3:133\n857#3,2:134\n1855#3,2:136\n766#3:138\n857#3,2:139\n1855#3,2:141\n*S KotlinDebug\n*F\n+ 1 ConvertSealedSubClassToObjectFix.kt\norg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix\n*L\n41#1:130\n62#1:131,2\n107#1:133\n107#1:134,2\n108#1:136,2\n121#1:138\n121#1:139,2\n122#1:141,2\n*E\n"})
public final class ConvertSealedSubClassToObjectFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final Language JAVA_LANG = Language.findLanguageByID((String)"JAVA");
    @Nullable
    private static final Language KOTLIN_LANG = Language.findLanguageByID((String)"kotlin");

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("convert.sealed.subclass.to.object.fix.family.name", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
        PsiElement psiElement3 = psiElement2;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
        if (ktClass2 == null) {
            return;
        }
        KtClass klass2 = ktClass2;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)klass2));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer ktClassSmartPointer = smartPsiElementPointer;
        this.changeInstances((SmartPsiElementPointer<KtClass>)ktClassSmartPointer);
        this.changeDeclaration((SmartPsiElementPointer<KtClass>)ktClassSmartPointer);
    }

    private final void changeDeclaration(SmartPsiElementPointer<KtClass> pointer) {
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(pointer, this){
            final /* synthetic */ SmartPsiElementPointer<KtClass> $pointer;
            final /* synthetic */ ConvertSealedSubClassToObjectFix this$0;
            {
                this.$pointer = $pointer;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                KtClass ktClass2 = (KtClass)this.$pointer.getElement();
                if (ktClass2 == null) {
                    return;
                }
                KtClass element3 = ktClass2;
                Project project2 = element3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
                ConvertSealedSubClassToObjectFix.access$changeToObject(this.this$0, element3, psiFactory);
                ConvertSealedSubClassToObjectFix.access$transformToObject(this.this$0, element3, psiFactory);
            }
        }));
    }

    private final void changeToObject(KtClass $this$changeToObject, KtPsiFactory factory2) {
        block4: {
            KtExpression ktExpression;
            Iterable $this$forEach$iv = $this$changeToObject.getSecondaryConstructors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                boolean bl = false;
                new ConvertSecondaryConstructorToPrimaryIntention().applyTo(it, (Editor)null);
            }
            KtPrimaryConstructor ktPrimaryConstructor = $this$changeToObject.getPrimaryConstructor();
            if (ktPrimaryConstructor != null) {
                ktPrimaryConstructor.delete();
            }
            PsiElement psiElement2 = $this$changeToObject.getClassOrInterfaceKeyword();
            if (psiElement2 == null) break block4;
            if (!$this$changeToObject.isData() && LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$changeToObject).supportsFeature(LanguageFeature.DataObjects)) {
                ktExpression = (KtExpression)CreateByPatternKt.createDeclarationByPattern$default((KtPsiFactory)factory2, (String)(KtTokens.DATA_KEYWORD.getValue() + " " + KtTokens.OBJECT_KEYWORD.getValue()), (Object[])new Object[0], (boolean)false, (int)4, null);
            } else {
                String string = KtTokens.OBJECT_KEYWORD.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                ktExpression = factory2.createExpression(string);
            }
            psiElement2.replace((PsiElement)ktExpression);
        }
    }

    private final void transformToObject(KtClass $this$transformToObject, KtPsiFactory factory2) {
        String string = $this$transformToObject.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$transformToObject.replace((PsiElement)factory2.createObject(string));
    }

    private final void changeInstances(SmartPsiElementPointer<KtClass> pointer) {
        Map<Language, List<PsiElement>> map2;
        Map<Language, List<PsiElement>> $this$changeInstances_u24lambda_u241 = map2 = this.mapReferencesByLanguage(pointer);
        boolean bl = false;
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(pointer, this, $this$changeInstances_u24lambda_u241){
            final /* synthetic */ SmartPsiElementPointer<KtClass> $pointer;
            final /* synthetic */ ConvertSealedSubClassToObjectFix this$0;
            final /* synthetic */ Map<Language, List<PsiElement>> $this_apply;
            {
                this.$pointer = $pointer;
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
                super(0);
            }

            public final void invoke() {
                KtClass ktClass2 = (KtClass)this.$pointer.getElement();
                if (ktClass2 == null) {
                    return;
                }
                KtClass ktClass3 = ktClass2;
                ConvertSealedSubClassToObjectFix.access$replaceKotlin(this.this$0, this.$this_apply, ktClass3);
                ConvertSealedSubClassToObjectFix.access$replaceJava(this.this$0, this.$this_apply, ktClass3);
            }
        }));
    }

    private final Map<Language, List<PsiElement>> mapReferencesByLanguage(SmartPsiElementPointer<KtClass> pointer) {
        Project project2 = pointer.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Map map2 = (Map)ProgressUtilsKt.runSynchronouslyWithProgressIfEdt(project2, KotlinBundle.message("progress.looking.up.sealed.subclass.usage", new Object[0]), true, (Function0)new Function0<Map<Language, ? extends List<? extends PsiElement>>>(pointer){
            final /* synthetic */ SmartPsiElementPointer<KtClass> $pointer;
            {
                this.$pointer = $pointer;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Language, List<PsiElement>> invoke() {
                Map map2;
                KtClass ktClass2 = (KtClass)this.$pointer.getElement();
                if (ktClass2 != null) {
                    void $this$groupByTo$iv$iv;
                    KtClass ktClass3 = ktClass2;
                    boolean bl = false;
                    Query query = ReferencesSearch.search((PsiElement)((PsiElement)ktClass3));
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                    Iterable $this$groupBy$iv = (Iterable)query;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        void it;
                        Object object;
                        Language key$iv$iv;
                        PsiReference it2 = (PsiReference)element$iv$iv;
                        boolean $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$1$1$32 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2.getElement().getLanguage(), (String)"getLanguage(...)");
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        PsiReference $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$1$1$32 = (PsiReference)element$iv$iv;
                        List list2 = list$iv$iv;
                        boolean bl3 = false;
                        list2.add(it.getElement().getParent());
                    }
                    map2 = destination$iv$iv;
                } else {
                    map2 = MapsKt.emptyMap();
                }
                return map2;
            }
        });
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceKotlin(Map<Language, ? extends List<? extends PsiElement>> $this$replaceKotlin, KtClass klass2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        List<? extends PsiElement> list2 = $this$replaceKotlin.get(KOTLIN_LANG);
        if (list2 == null) {
            return;
        }
        List<? extends PsiElement> list3 = list2;
        Project project2 = klass2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtExpression singletonCall2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(klass2){
            final /* synthetic */ KtClass $klass;
            {
                this.$klass = $klass;
                super(1);
            }

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$this$buildExpression");
                Name name2 = this.$klass.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
                $this$buildExpression.appendName(name2);
            }
        }), (int)1, null);
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.replace((PsiElement)singletonCall2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceJava(Map<Language, ? extends List<? extends PsiElement>> $this$replaceJava, KtClass klass2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        List<? extends PsiElement> list2 = $this$replaceJava.get(JAVA_LANG);
        if (list2 == null) {
            return;
        }
        List<? extends PsiElement> list3 = list2;
        PsiElement psiElement2 = (PsiElement)CollectionsKt.firstOrNull(list3);
        if (psiElement2 == null) {
            return;
        }
        PsiElement first2 = psiElement2;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)klass2.getProject());
        PsiExpression psiExpression = elementFactory.createExpressionFromText(klass2.getName() + ".INSTANCE", first2);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        PsiExpression javaSingletonCall = psiExpression;
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JavaElementType.NEW_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getParent().getNode().getElementType(), (Object)JavaElementType.EXPRESSION_STATEMENT)) {
                it.delete();
                continue;
            }
            it.replace((PsiElement)javaSingletonCall);
        }
    }

    public static final /* synthetic */ void access$changeToObject(ConvertSealedSubClassToObjectFix $this, KtClass $receiver, KtPsiFactory factory2) {
        $this.changeToObject($receiver, factory2);
    }

    public static final /* synthetic */ void access$transformToObject(ConvertSealedSubClassToObjectFix $this, KtClass $receiver, KtPsiFactory factory2) {
        $this.transformToObject($receiver, factory2);
    }

    public static final /* synthetic */ void access$replaceKotlin(ConvertSealedSubClassToObjectFix $this, Map $receiver, KtClass klass2) {
        $this.replaceKotlin($receiver, klass2);
    }

    public static final /* synthetic */ void access$replaceJava(ConvertSealedSubClassToObjectFix $this, Map $receiver, KtClass klass2) {
        $this.replaceJava($receiver, klass2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix$Companion;", "", "()V", "JAVA_LANG", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/Nullable;", "getJAVA_LANG", "()Lcom/intellij/lang/Language;", "KOTLIN_LANG", "getKOTLIN_LANG", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Language getJAVA_LANG() {
            return JAVA_LANG;
        }

        @Nullable
        public final Language getKOTLIN_LANG() {
            return KOTLIN_LANG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

