/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J#\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002J(\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "doRemove", "", "mode", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "element", "rhs", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "showDialog", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "RemoveMode", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRemoveUnusedValueFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveUnusedValueFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,89:1\n77#2:90\n*S KotlinDebug\n*F\n+ 1 RemoveUnusedValueFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix\n*L\n30#1:90\n*E\n"})
public final class RemoveUnusedValueFix
extends KotlinQuickFixAction<KtBinaryExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RemoveUnusedValueFix(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    private final void showDialog(KtProperty variable2, Project project2, KtBinaryExpression element3, KtExpression rhs) {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doRemove(RemoveMode.KEEP_INITIALIZE, element3, rhs);
            return;
        }
        Object[] objectArray = new Object[]{String.valueOf(variable2.getName())};
        String message2 = "<html><body>" + KotlinBundle.message("there.are.possible.side.effects.found.in.expressions.assigned.to.the.variable.0", objectArray) + "</body></html>";
        ApplicationManager.getApplication().invokeLater(() -> RemoveUnusedValueFix.showDialog$lambda$1(variable2, message2, project2, this, element3, rhs));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("remove.redundant.assignment", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    private final void doRemove(RemoveMode mode, KtBinaryExpression element3, KtExpression rhs) {
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                element3.delete();
                break;
            }
            case 2: {
                element3.replace((PsiElement)rhs);
            }
        }
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        boolean isSideEffectFree;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)this.getElement();
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element3 = ktBinaryExpression;
        KtExpression ktExpression = element3.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhs = ktSimpleNameExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression rhs = ktExpression2;
        PsiElement psiElement2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)lhs).resolve();
        KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty variable2 = ktProperty;
        Pseudocode pseudocode2 = PseudocodeUtilsKt.getContainingPseudocode((KtElement)((KtElement)rhs), (BindingContext)ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL));
        Pseudocode pseudocode3 = pseudocode2;
        boolean bl = pseudocode3 != null && (pseudocode3 = pseudocode3.getElementValue((KtElement)rhs)) != null && (pseudocode3 = pseudocode3.getCreatedAt()) != null ? PseudocodeUtilsKt.getSideEffectFree((Instruction)((Instruction)pseudocode3)) : (isSideEffectFree = false);
        if (!isSideEffectFree) {
            this.showDialog(variable2, project2, element3, rhs);
        } else {
            this.doRemove(RemoveMode.REMOVE_ALL, element3, rhs);
        }
    }

    private static final void showDialog$lambda$1$lambda$0(RemoveUnusedValueFix this$0, int $exitCode, KtBinaryExpression $element, KtExpression $rhs) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)$rhs, (String)"$rhs");
        this$0.doRemove(RemoveMode.values()[$exitCode], $element, $rhs);
    }

    private static final void showDialog$lambda$1(KtProperty $variable, String $message, Project $project, RemoveUnusedValueFix this$0, KtBinaryExpression $element, KtExpression $rhs) {
        Intrinsics.checkNotNullParameter((Object)$variable, (String)"$variable");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)$rhs, (String)"$rhs");
        int exitCode = Messages.showYesNoCancelDialog((Project)$variable.getProject(), (String)$message, (String)QuickFixBundle.message((String)"side.effects.warning.dialog.title", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.remove", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.transform", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        WriteCommandAction.runWriteCommandAction((Project)$project, () -> RemoveUnusedValueFix.showDialog$lambda$1$lambda$0(this$0, exitCode, $element, $rhs));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((DiagnosticWithParameters2)Errors.UNUSED_VALUE.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-psiElement>(...)");
            KtBinaryExpression expression2 = (KtBinaryExpression)psiElement2;
            if (!KtPsiUtil.isAssignment((PsiElement)((PsiElement)expression2))) {
                return null;
            }
            if (!(expression2.getLeft() instanceof KtSimpleNameExpression)) {
                return null;
            }
            return new RemoveUnusedValueFix(expression2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "", "(Ljava/lang/String;I)V", "REMOVE_ALL", "KEEP_INITIALIZE", "CANCEL", "kotlin.idea"})
    public static final class RemoveMode
    extends Enum<RemoveMode> {
        public static final /* enum */ RemoveMode REMOVE_ALL = new RemoveMode();
        public static final /* enum */ RemoveMode KEEP_INITIALIZE = new RemoveMode();
        public static final /* enum */ RemoveMode CANCEL = new RemoveMode();
        private static final /* synthetic */ RemoveMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RemoveMode[] values() {
            return (RemoveMode[])$VALUES.clone();
        }

        public static RemoveMode valueOf(String value2) {
            return Enum.valueOf(RemoveMode.class, value2);
        }

        @NotNull
        public static EnumEntries<RemoveMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = removeModeArray = new RemoveMode[]{RemoveMode.REMOVE_ALL, RemoveMode.KEEP_INITIALIZE, RemoveMode.CANCEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RemoveMode.values().length];
            try {
                nArray[RemoveMode.REMOVE_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoveMode.KEEP_INITIALIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

