/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.configuration.AddRequiresDirectiveFacility;
import org.jetbrains.kotlin.idea.fe10.inspections.KotlinInspectionsFe10Bundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinAddRequiredModuleFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "module", "Lcom/intellij/psi/PsiJavaModule;", "requiredName", "", "(Lcom/intellij/psi/PsiJavaModule;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "startInWriteAction", "Companion", "kotlin.inspections-fe10"})
public final class KotlinAddRequiredModuleFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String requiredName;

    public KotlinAddRequiredModuleFix(@NotNull PsiJavaModule module2, @NotNull String requiredName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredName, (String)"requiredName");
        super((PsiElement)module2);
        this.requiredName = requiredName;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinInspectionsFe10Bundle.message("kotlin.add.required.module.fix.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.requiredName};
        String string = QuickFixBundle.message((String)"module.info.add.requires.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement2, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement2, (String)"endElement");
        return PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)file2)) && startElement2 instanceof PsiJavaModule && startElement2.getManager().isInProject(startElement2) && AddRequiresDirectiveFacility.INSTANCE.canAddModuleRequirement((PsiJavaModule)startElement2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement2, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement2, (String)"endElement");
        AddRequiresDirectiveFacility.INSTANCE.addModuleRequirement((PsiJavaModule)startElement2, this.requiredName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinAddRequiredModuleFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.inspections-fe10"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression expression2 = ktExpression;
            PsiJavaModule psiJavaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)expression2));
            if (psiJavaModule == null) {
                return null;
            }
            PsiJavaModule javaModule = psiJavaModule;
            UnboundDiagnostic unboundDiagnostic = (UnboundDiagnostic)diagnostic;
            DiagnosticFactory[] diagnosticFactoryArray = new DiagnosticFactory[1];
            Intrinsics.checkNotNullExpressionValue((Object)ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE, (String)"JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE");
            DiagnosticWithParameters1 dependDiagnostic = (DiagnosticWithParameters1)DiagnosticFactory.Companion.cast(unboundDiagnostic, diagnosticFactoryArray);
            Object object = dependDiagnostic.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            String moduleName2 = (String)object;
            return (IntentionAction)new KotlinAddRequiredModuleFix(javaModule, moduleName2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

