/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0019J8\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper;", "", "()V", "calculateTextForFix", "", "T", "", "importInfos", "", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportInfo;", "suggestions", "Lorg/jetbrains/kotlin/name/FqName;", "calculateWeightBasedOnFqName", "", "fqName", "sourceDeclaration", "Lcom/intellij/psi/PsiElement;", "createListPopupWithImportVariants", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "variants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "addImport", "Lkotlin/Function1;", "", "getVariantSelectionPopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "ImportInfo", "ImportKind", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nImportFixHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportFixHelper.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,181:1\n1490#2:182\n1520#2,3:183\n1523#2,3:193\n1477#2:196\n1502#2,3:197\n1505#2,3:207\n1549#2:210\n1620#2,3:211\n1477#2:214\n1502#2,3:215\n1505#2,3:225\n372#3,7:186\n372#3,7:200\n372#3,7:218\n*S KotlinDebug\n*F\n+ 1 ImportFixHelper.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixHelper\n*L\n40#1:182\n40#1:183,3\n40#1:193,3\n47#1:196\n47#1:197,3\n47#1:207,3\n65#1:210\n65#1:211,3\n65#1:214\n65#1:215,3\n65#1:225,3\n40#1:186,7\n47#1:200,7\n65#1:218,7\n*E\n"})
public final class ImportFixHelper {
    @NotNull
    public static final ImportFixHelper INSTANCE = new ImportFixHelper();

    private ImportFixHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @IntentionName
    @NotNull
    public final <T extends Comparable<? super T>> String calculateTextForFix(@NotNull Iterable<ImportInfo<T>> importInfos, @NotNull Iterable<FqName> suggestions2) {
        String string;
        Iterable<FqName> it;
        Collection<String> collection;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(importInfos, (String)"importInfos");
        Intrinsics.checkNotNullParameter(suggestions2, (String)"suggestions");
        Iterable<ImportInfo<T>> $this$groupBy$iv = importInfos;
        boolean $i$f$groupBy = false;
        Iterable<ImportInfo<T>> iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ImportInfo it2 = (ImportInfo)element$iv$iv;
            boolean $i$a$-groupBy-ImportFixHelper$calculateTextForFix$importNamesGroupedByKind$332 = false;
            ImportKind key$iv$iv = it2.getKind();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object v = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (v == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = v;
            }
            List list$iv$iv = (List)object;
            ImportInfo $i$a$-groupBy-ImportFixHelper$calculateTextForFix$importNamesGroupedByKind$332 = (ImportInfo)element$iv$iv;
            collection = list$iv$iv;
            boolean bl = false;
            collection.add((String)((Object)it));
        }
        Map importNamesGroupedByKind = destination$iv$iv;
        if (importNamesGroupedByKind.size() == 1) {
            boolean singlePackage;
            Object[] $this$groupByTo$iv$iv2;
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)importNamesGroupedByKind.entrySet());
            ImportKind kind2 = (ImportKind)((Object)entry.getKey());
            List names2 = (List)entry.getValue();
            Function1[] $i$f$groupByTo22 = new Function1[]{calculateTextForFix.sortedImportInfos.1.INSTANCE, calculateTextForFix.sortedImportInfos.2.INSTANCE};
            TreeSet sortedImportInfos2 = new TreeSet(ComparisonsKt.compareBy((Function1[])$i$f$groupByTo22));
            sortedImportInfos2.addAll(names2);
            String firstName = ((ImportInfo)sortedImportInfos2.first()).getName();
            Iterable<FqName> $this$groupBy$iv2 = suggestions2;
            boolean $i$f$groupBy2 = false;
            it = $this$groupBy$iv2;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo3 = false;
            for (Object t : $this$groupByTo$iv$iv2) {
                Object object;
                FqName it3 = (FqName)t;
                boolean bl3 = false;
                FqName fqName2 = FqNamesUtilKt.parentOrNull((FqName)it3);
                if (fqName2 == null) {
                    fqName2 = FqName.ROOT;
                }
                FqName key$iv$iv = fqName2;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(t);
            }
            boolean bl = singlePackage = destination$iv$iv2.size() == 1;
            if (singlePackage) {
                sortedByName = CollectionsKt.toSortedSet((Iterable)sortedImportInfos2, (Comparator)new Comparator(){

                    public final int compare(T a, T b2) {
                        ImportInfo it = (ImportInfo)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (ImportInfo)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                int size = sortedByName.size();
                if (size == 2) {
                    $this$groupByTo$iv$iv2 = new Object[]{kind2.toText(size), ((ImportInfo)sortedByName.first()).getName(), ((ImportInfo)sortedByName.last()).getName()};
                    string = KotlinBundle.message("fix.import.kind.0.name.1.and.name.2", $this$groupByTo$iv$iv2);
                } else {
                    $this$groupByTo$iv$iv2 = new Object[]{kind2.toText(size), firstName, size - 1};
                    string = KotlinBundle.message("fix.import.kind.0.name.1.2", $this$groupByTo$iv$iv2);
                }
            } else if (kind2.getGroupedByPackage()) {
                sortedByName = new Object[]{kind2.toText(1), firstName, 0};
                string = KotlinBundle.message("fix.import.kind.0.name.1.2", (Object[])sortedByName);
            } else {
                void $this$groupByTo$iv$iv3;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = sortedImportInfos2;
                boolean $i$f$map = false;
                destination$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it4;
                    ImportInfo bl3 = (ImportInfo)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl4 = false;
                    collection.add(it4.getName());
                }
                Iterable $this$groupBy$iv3 = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv3));
                boolean $i$f$groupBy3 = false;
                $this$mapTo$iv$iv = $this$groupBy$iv3;
                Map destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$groupByTo4 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
                    Object object;
                    String it5 = (String)element$iv$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)it5);
                    String key$iv$iv = StringsKt.substringBefore$default((String)it5, (char)'.', null, (int)2, null);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl6 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map groupBy = destination$iv$iv4;
                List value2 = (List)((Map.Entry)CollectionsKt.first((Iterable)groupBy.entrySet())).getValue();
                String first2 = (String)CollectionsKt.first((List)value2);
                int multiple = value2.size() == 1 ? 0 : 1;
                if (groupBy.size() != 1) {
                    var14_24 = new Object[3];
                    var14_24[0] = kind2.toText(1);
                    Intrinsics.checkNotNull((Object)first2);
                    var14_24[1] = StringsKt.substringAfter$default((String)first2, (char)'.', null, (int)2, null);
                    var14_24[2] = multiple;
                    string = KotlinBundle.message("fix.import.kind.0.name.1.2", var14_24);
                } else if (value2.size() == 2) {
                    var14_24 = new Object[3];
                    var14_24[0] = kind2.toText(value2.size());
                    Intrinsics.checkNotNull((Object)first2);
                    var14_24[1] = first2;
                    Intrinsics.checkNotNullExpressionValue((Object)CollectionsKt.last((List)value2), (String)"last(...)");
                    string = KotlinBundle.message("fix.import.kind.0.name.1.and.name.2", var14_24);
                } else {
                    var14_24 = new Object[3];
                    var14_24[0] = kind2.toText(1);
                    Intrinsics.checkNotNull((Object)first2);
                    var14_24[1] = first2;
                    var14_24[2] = multiple;
                    string = KotlinBundle.message("fix.import.kind.0.name.1.2", var14_24);
                }
            }
        } else {
            string = KotlinBundle.message("fix.import", new Object[0]);
        }
        return string;
    }

    public final int calculateWeightBasedOnFqName(@NotNull FqName fqName2, @Nullable PsiElement sourceDeclaration) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        String string = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqNameString = string;
        if (StringsKt.startsWith$default((String)fqNameString, (String)"kotlin.", (boolean)false, (int)2, null)) {
            n = 6;
        } else if (StringsKt.startsWith$default((String)fqNameString, (String)"kotlinx.", (boolean)false, (int)2, null)) {
            n = 5;
        } else if (StringsKt.startsWith$default((String)fqNameString, (String)"java.", (boolean)false, (int)2, null)) {
            n = 2;
        } else if (sourceDeclaration != null) {
            PsiFile psiFile2 = sourceDeclaration.getContainingFile();
            VirtualFile virtualFile2 = psiFile2 != null ? psiFile2.getVirtualFile() : null;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)sourceDeclaration.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex2 = projectFileIndex;
            n = virtualFile2 != null && fileIndex2.isInSourceContent(virtualFile2) ? 7 : 0;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final ListPopup createListPopupWithImportVariants(@NotNull Project project2, @NotNull List<? extends AutoImportVariant> variants2, @NotNull Function1<? super AutoImportVariant, Unit> addImport2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(variants2, (String)"variants");
        Intrinsics.checkNotNullParameter(addImport2, (String)"addImport");
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup(project2, (ListPopupStep)this.getVariantSelectionPopup(project2, variants2, addImport2), arg_0 -> ImportFixHelper.createListPopupWithImportVariants$lambda$6(createListPopupWithImportVariants.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        return listPopup;
    }

    private final BaseListPopupStep<AutoImportVariant> getVariantSelectionPopup(Project project2, List<? extends AutoImportVariant> variants2, Function1<? super AutoImportVariant, Unit> addImport2) {
        String string = KotlinBundle.message("action.add.import.chooser.title", new Object[0]);
        return (BaseListPopupStep)new BaseListPopupStep<AutoImportVariant>(variants2, project2, addImport2, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<AutoImportVariant, Unit> $addImport;
            {
                this.$project = $project;
                this.$addImport = $addImport;
                super($super_call_param$1, $variants);
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public PopupStep<String> onChosen(@Nullable AutoImportVariant selectedValue, boolean finalChoice) {
                if (selectedValue == null || this.$project.isDisposed()) {
                    return null;
                }
                if (finalChoice) {
                    this.$addImport.invoke((Object)selectedValue);
                    return null;
                }
                List list2 = AddImportAction.getAllExcludableStrings((String)selectedValue.getFqName().asString());
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllExcludableStrings(...)");
                List toExclude = list2;
                return (PopupStep)new BaseListPopupStep<String>((List<String>)toExclude, this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(null, $toExclude);
                    }

                    @NotNull
                    public String getTextFor(@NotNull String value2) {
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        Object[] objectArray = new Object[]{value2};
                        return KotlinBundle.message("fix.import.exclude", objectArray);
                    }

                    @Nullable
                    public PopupStep<Object> onChosen(@NotNull String selectedValue, boolean finalChoice) {
                        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                        if (finalChoice && !this.$project.isDisposed()) {
                            AddImportAction.excludeFromImport((Project)this.$project, (String)selectedValue);
                        }
                        return null;
                    }
                };
            }

            public boolean hasSubstep(@Nullable AutoImportVariant selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getHint();
            }

            @Nullable
            public Icon getIconFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getIcon();
            }
        };
    }

    private static final ListCellRenderer createListPopupWithImportVariants$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ListCellRenderer)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportInfo;", "T", "", "", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "name", "", "priority", "(Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;Ljava/lang/String;Ljava/lang/Comparable;)V", "getKind", "()Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "getName", "()Ljava/lang/String;", "getPriority", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "kotlin.fir.frontend-independent"})
    public static final class ImportInfo<T extends Comparable<? super T>> {
        @NotNull
        private final ImportKind kind;
        @NotNull
        private final String name;
        @NotNull
        private final T priority;

        public ImportInfo(@NotNull ImportKind kind2, @NotNull String name2, @NotNull T priority) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(priority, (String)"priority");
            this.kind = kind2;
            this.name = name2;
            this.priority = priority;
        }

        @NotNull
        public final ImportKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final T getPriority() {
            return this.priority;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "", "key", "", "groupedByPackage", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getGroupedByPackage", "()Z", "toText", "number", "", "CLASS", "TYPE_ALIAS", "PROPERTY", "OBJECT", "FUNCTION", "EXTENSION_PROPERTY", "EXTENSION_FUNCTION", "OPERATOR", "kotlin.fir.frontend-independent"})
    public static final class ImportKind
    extends Enum<ImportKind> {
        @NotNull
        private final String key;
        private final boolean groupedByPackage;
        public static final /* enum */ ImportKind CLASS = new ImportKind("text.class.0", true);
        public static final /* enum */ ImportKind TYPE_ALIAS = new ImportKind("text.type.alias.0", true);
        public static final /* enum */ ImportKind PROPERTY = new ImportKind("PROPERTY", 2, "text.property.0", false, 2, null);
        public static final /* enum */ ImportKind OBJECT = new ImportKind("text.object.0", true);
        public static final /* enum */ ImportKind FUNCTION = new ImportKind("FUNCTION", 4, "text.function.0", false, 2, null);
        public static final /* enum */ ImportKind EXTENSION_PROPERTY = new ImportKind("EXTENSION_PROPERTY", 5, "text.extension.property.0", false, 2, null);
        public static final /* enum */ ImportKind EXTENSION_FUNCTION = new ImportKind("EXTENSION_FUNCTION", 6, "text.extension.function.0", false, 2, null);
        public static final /* enum */ ImportKind OPERATOR = new ImportKind("OPERATOR", 7, "text.operator.0", false, 2, null);
        private static final /* synthetic */ ImportKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ImportKind(String key, boolean groupedByPackage) {
            this.key = key;
            this.groupedByPackage = groupedByPackage;
        }

        /* synthetic */ ImportKind(String string, int n, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(string2, bl);
        }

        public final boolean getGroupedByPackage() {
            return this.groupedByPackage;
        }

        @NotNull
        public final String toText(int number) {
            Object[] objectArray = new Object[]{number == 1 ? 1 : 2};
            return KotlinBundle.message(this.key, objectArray);
        }

        public static ImportKind[] values() {
            return (ImportKind[])$VALUES.clone();
        }

        public static ImportKind valueOf(String value2) {
            return Enum.valueOf(ImportKind.class, value2);
        }

        @NotNull
        public static EnumEntries<ImportKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = importKindArray = new ImportKind[]{ImportKind.CLASS, ImportKind.TYPE_ALIAS, ImportKind.PROPERTY, ImportKind.OBJECT, ImportKind.FUNCTION, ImportKind.EXTENSION_PROPERTY, ImportKind.EXTENSION_FUNCTION, ImportKind.OPERATOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

