/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.PsiElementSuitabilityCheckers;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixesPsiBasedFactory;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB=\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Kind", "TypeVarianceConflictFactory", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public class AddAnnotationFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    private final ClassId annotationClassId;
    @NotNull
    private final Kind kind;
    @Nullable
    private final FqName argumentClassFqName;
    @Nullable
    private final SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry;

    public AddAnnotationFix(@NotNull KtElement element3, @NotNull ClassId annotationClassId, @NotNull Kind kind2, @Nullable FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        super((PsiElement)element3);
        this.annotationClassId = annotationClassId;
        this.kind = kind2;
        this.argumentClassFqName = argumentClassFqName;
        this.existingAnnotationEntry = existingAnnotationEntry;
    }

    public /* synthetic */ AddAnnotationFix(KtElement ktElement, ClassId classId, Kind kind2, FqName fqName2, SmartPsiElementPointer smartPsiElementPointer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kind2 = Kind.Self.INSTANCE;
        }
        if ((n & 8) != 0) {
            fqName2 = null;
        }
        if ((n & 0x10) != 0) {
            smartPsiElementPointer = null;
        }
        this(ktElement, classId, kind2, fqName2, (SmartPsiElementPointer<KtAnnotationEntry>)smartPsiElementPointer);
    }

    @NotNull
    public String getText() {
        String string;
        Object object;
        block14: {
            block13: {
                object = this.argumentClassFqName;
                if (object == null || (object = object.shortName()) == null) break block13;
                Object it = object;
                boolean bl = false;
                String string2 = "(" + (Name)it + "::class)";
                object = string2;
                if (string2 != null) break block14;
            }
            object = "";
        }
        Object annotationArguments = object;
        String annotationCall = this.annotationClassId.getShortClassName().asString() + (String)annotationArguments;
        Kind kind2 = this.kind;
        if (Intrinsics.areEqual((Object)kind2, (Object)Kind.Self.INSTANCE)) {
            Object[] objectArray = new Object[]{annotationCall};
            string = KotlinBundle.message("fix.add.annotation.text.self", objectArray);
        } else if (Intrinsics.areEqual((Object)kind2, (Object)Kind.Constructor.INSTANCE)) {
            Object[] objectArray = new Object[]{annotationCall};
            string = KotlinBundle.message("fix.add.annotation.text.constructor", objectArray);
        } else if (kind2 instanceof Kind.Declaration) {
            Object[] objectArray = new Object[2];
            objectArray[0] = annotationCall;
            String string3 = ((Kind.Declaration)this.kind).getName();
            if (string3 == null) {
                string3 = "?";
            }
            objectArray[1] = string3;
            string = KotlinBundle.message("fix.add.annotation.text.declaration", objectArray);
        } else if (kind2 instanceof Kind.ContainingClass) {
            Object[] objectArray = new Object[2];
            objectArray[0] = annotationCall;
            String string4 = ((Kind.ContainingClass)this.kind).getName();
            if (string4 == null) {
                string4 = "?";
            }
            objectArray[1] = string4;
            string = KotlinBundle.message("fix.add.annotation.text.containing.class", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.annotation.family", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        String annotationInnerText;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element3 = ktElement;
        SmartPsiElementPointer<KtAnnotationEntry> smartPsiElementPointer = this.existingAnnotationEntry;
        KtAnnotationEntry annotationEntry2 = smartPsiElementPointer != null ? (KtAnnotationEntry)smartPsiElementPointer.getElement() : null;
        FqName fqName2 = this.argumentClassFqName;
        if (fqName2 != null) {
            FqName it = fqName2;
            boolean bl = false;
            v3 = RenderingUtilsKt.render((FqName)it) + "::class";
        } else {
            v3 = annotationInnerText = null;
        }
        if (annotationEntry2 != null) {
            if (annotationInnerText == null) {
                return;
            }
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            KtValueArgumentList ktValueArgumentList = annotationEntry2.getValueArgumentList();
            PsiElement psiElement2 = ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.addArgument(psiFactory.createArgument(annotationInnerText))) != null ? (PsiElement)ktValueArgumentList : annotationEntry2.addAfter((PsiElement)psiFactory.createCallArguments("(" + annotationInnerText + ")"), annotationEntry2.getLastChild());
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)annotationEntry2);
        } else {
            AnnotationModificationUtilsKt.addAnnotation(element3, this.annotationClassId, annotationInnerText, false);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "", "()V", "Constructor", "ContainingClass", "Declaration", "Self", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Constructor;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$ContainingClass;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Declaration;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Self;", "kotlin.fir.frontend-independent"})
    public static abstract class Kind {
        private Kind() {
        }

        public /* synthetic */ Kind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Constructor;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "()V", "kotlin.fir.frontend-independent"})
        public static final class Constructor
        extends Kind {
            @NotNull
            public static final Constructor INSTANCE = new Constructor();

            private Constructor() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$ContainingClass;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "kotlin.fir.frontend-independent"})
        public static final class ContainingClass
        extends Kind {
            @Nullable
            private final String name;

            public ContainingClass(@Nullable String name2) {
                super(null);
                this.name = name2;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Declaration;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "kotlin.fir.frontend-independent"})
        public static final class Declaration
        extends Kind {
            @Nullable
            private final String name;

            public Declaration(@Nullable String name2) {
                super(null);
                this.name = name2;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind$Self;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "()V", "kotlin.fir.frontend-independent"})
        public static final class Self
        extends Kind {
            @NotNull
            public static final Self INSTANCE = new Self();

            private Self() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$TypeVarianceConflictFactory;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "()V", "doCreateQuickFix", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "psiElement", "kotlin.fir.frontend-independent"})
    public static final class TypeVarianceConflictFactory
    extends QuickFixesPsiBasedFactory<PsiElement> {
        @NotNull
        public static final TypeVarianceConflictFactory INSTANCE = new TypeVarianceConflictFactory();

        private TypeVarianceConflictFactory() {
            super(Reflection.getOrCreateKotlinClass(PsiElement.class), PsiElementSuitabilityCheckers.INSTANCE.getALWAYS_SUITABLE());
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateQuickFix(@NotNull PsiElement psiElement2) {
            Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            KtTypeReference ktTypeReference = psiElement3 instanceof KtTypeReference ? (KtTypeReference)psiElement3 : null;
            if (ktTypeReference == null) {
                return CollectionsKt.emptyList();
            }
            KtTypeReference typeReference2 = ktTypeReference;
            return CollectionsKt.listOf((Object)new AddAnnotationFix((KtElement)typeReference2, ClassId.Companion.topLevel(StandardNames.FqNames.unsafeVariance), Kind.Self.INSTANCE, null, null, 24, null));
        }
    }
}

