/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectConfiguration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.projectConfiguration.CustomLibraryDescriptionWithDeferredConfig;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001&B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0004J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016R\u0018\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/projectConfiguration/CustomLibraryDescriptionWithDeferredConfig;", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "project", "Lcom/intellij/openapi/project/Project;", "configuratorName", "", "libraryName", "libraryKind", "Lcom/intellij/openapi/roots/libraries/LibraryKind;", "suitableLibraryKinds", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/roots/libraries/LibraryKind;Ljava/util/Set;)V", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "configureKotlinSettings", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createConfigurationFromPluginPaths", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "createNewLibrary", "parentComponent", "Ljavax/swing/JComponent;", "contextDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNewLibraryWithDefaultSettings", "finishLibConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "isNewProject", "", "getSuitableLibraryKinds", "MyLibraryConfiguration", "kotlin.project-configuration"})
public abstract class CustomLibraryDescriptionWithDeferredConfig
extends CustomLibraryDescription {
    @Nullable
    private final Project project;
    @NotNull
    private final String configuratorName;
    @NotNull
    private final String libraryName;
    @NotNull
    private final LibraryKind libraryKind;
    @NotNull
    private final Set<LibraryKind> suitableLibraryKinds;

    public CustomLibraryDescriptionWithDeferredConfig(@Nullable Project project2, @NotNull String configuratorName, @NotNull String libraryName, @NotNull LibraryKind libraryKind, @NotNull Set<? extends LibraryKind> suitableLibraryKinds) {
        Intrinsics.checkNotNullParameter((Object)configuratorName, (String)"configuratorName");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)libraryKind, (String)"libraryKind");
        Intrinsics.checkNotNullParameter(suitableLibraryKinds, (String)"suitableLibraryKinds");
        this.project = project2;
        this.configuratorName = configuratorName;
        this.libraryName = libraryName;
        this.libraryKind = libraryKind;
        this.suitableLibraryKinds = suitableLibraryKinds;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Set<LibraryKind> getSuitableLibraryKinds() {
        return this.suitableLibraryKinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishLibConfiguration(@NotNull Module module2, @NotNull ModifiableRootModel rootModel, boolean isNewProject) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.configureKotlinSettings(project2, rootModel.getSdk());
        if (isNewProject) {
            Project project3 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project3).update(finishLibConfiguration.1.INSTANCE);
            OrderEnumerator orderEnumerator = rootModel.orderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"orderEntries(...)");
            Library library2 = ProjectStructureUtils.findLibrary(orderEnumerator, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(this){
                final /* synthetic */ CustomLibraryDescriptionWithDeferredConfig this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Library library2) {
                    Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                    LibraryPresentationManager libraryPresentationManager = LibraryPresentationManager.getInstance();
                    VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                    List classFiles = ArraysKt.toList((Object[])virtualFileArray);
                    return libraryPresentationManager.isLibraryOfKind(classFiles, CustomLibraryDescriptionWithDeferredConfig.access$getLibraryKind$p(this.this$0));
                }
            }));
            LibraryEx libraryEx = library2 instanceof LibraryEx ? (LibraryEx)library2 : null;
            if (libraryEx == null) {
                return;
            }
            LibraryEx library3 = libraryEx;
            LibraryEx.ModifiableModelEx modifiableModelEx = library3.getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"getModifiableModel(...)");
            LibraryEx.ModifiableModelEx model2 = modifiableModelEx;
            try {
                Project project4 = module2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                NotificationMessageCollector collector2 = NotificationMessageCollector.Companion.create(project4);
                LibraryJarDescriptor descriptorWithSdk = this.getConfigurator().getLibraryJarDescriptor();
                if (descriptorWithSdk.findExistingJar((Library)library3) != null) {
                    KotlinWithLibraryConfigurator<?> kotlinWithLibraryConfigurator = this.getConfigurator();
                    Project project5 = module2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
                    KotlinWithLibraryConfigurator.configureLibraryJar$default(kotlinWithLibraryConfigurator, project5, model2, descriptorWithSdk, collector2, null, 16, null);
                }
                collector2.showNotification();
            }
            finally {
                model2.commit();
            }
        }
    }

    public static /* synthetic */ void finishLibConfiguration$default(CustomLibraryDescriptionWithDeferredConfig customLibraryDescriptionWithDeferredConfig, Module module2, ModifiableRootModel modifiableRootModel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: finishLibConfiguration");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        customLibraryDescriptionWithDeferredConfig.finishLibConfiguration(module2, modifiableRootModel, bl);
    }

    protected void configureKotlinSettings(@NotNull Project project2, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
    }

    @Nullable
    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        return this.createConfigurationFromPluginPaths();
    }

    private final KotlinWithLibraryConfigurator<?> getConfigurator() {
        KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator = (KotlinWithLibraryConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(this.configuratorName);
        if (kotlinWithLibraryConfigurator == null) {
            throw new IllegalStateException(("Configurator with name " + this.configuratorName + " should exists").toString());
        }
        return kotlinWithLibraryConfigurator;
    }

    @Nullable
    public NewLibraryConfiguration createNewLibraryWithDefaultSettings(@Nullable VirtualFile contextDirectory) {
        return this.createConfigurationFromPluginPaths();
    }

    @NotNull
    protected final NewLibraryConfiguration createConfigurationFromPluginPaths() {
        Project project2 = this.project;
        if (project2 == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        return new MyLibraryConfiguration(project2, this.libraryName, this.getConfigurator());
    }

    public static final /* synthetic */ LibraryKind access$getLibraryKind$p(CustomLibraryDescriptionWithDeferredConfig $this) {
        return $this.libraryKind;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/projectConfiguration/CustomLibraryDescriptionWithDeferredConfig$MyLibraryConfiguration;", "P", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "libraryName", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addRoots", "", "editor", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditor;", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nCustomLibraryDescriptionWithDeferredConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomLibraryDescriptionWithDeferredConfig.kt\norg/jetbrains/kotlin/idea/projectConfiguration/CustomLibraryDescriptionWithDeferredConfig$MyLibraryConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1855#2,2:116\n*S KotlinDebug\n*F\n+ 1 CustomLibraryDescriptionWithDeferredConfig.kt\norg/jetbrains/kotlin/idea/projectConfiguration/CustomLibraryDescriptionWithDeferredConfig$MyLibraryConfiguration\n*L\n109#1:116,2\n*E\n"})
    private static final class MyLibraryConfiguration<P extends LibraryProperties<?>>
    extends NewLibraryConfiguration {
        @NotNull
        private final Project project;
        @NotNull
        private final KotlinWithLibraryConfigurator<P> configurator;

        public MyLibraryConfiguration(@NotNull Project project2, @NotNull String libraryName, @NotNull KotlinWithLibraryConfigurator<P> configurator) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
            super(libraryName, configurator.getLibraryType(), configurator.getLibraryProperties());
            this.project = project2;
            this.configurator = configurator;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void addRoots(@NotNull LibraryEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            RepositoryLibraryProperties repositoryLibraryProperties = this.configurator.getLibraryJarDescriptor().getRepositoryLibraryProperties();
            Collection collection = JarRepositoryManager.loadDependenciesModal((Project)this.project, (RepositoryLibraryProperties)repositoryLibraryProperties, (boolean)true, (boolean)true, null, null);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"loadDependenciesModal(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrderRoot it = (OrderRoot)element$iv;
                boolean bl = false;
                editor2.addRoot(it.getFile(), it.getType());
            }
        }
    }
}

