/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.ModuleEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\f\rB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/project/ModulePlatformCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "calculate", "key", "checkKeyValidity", "", "subscribe", "Companion", "ModelChangeListener", "kotlin.base.facet"})
public final class ModulePlatformCache
extends SynchronizedFineGrainedEntityCache<Module, TargetPlatform> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ModulePlatformCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, false, 4, null);
    }

    @Override
    protected void subscribe() {
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener(this.getProject()));
    }

    @Override
    protected void checkKeyValidity(@NotNull Module key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (key.isDisposed()) {
            throw new IllegalStateException("Module " + key.getName() + " is already disposed");
        }
    }

    @Override
    @NotNull
    public TargetPlatform calculate(@NotNull Module key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Project project2 = key.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project2);
        if (kotlinFacetSettingsProvider == null || (kotlinFacetSettingsProvider = kotlinFacetSettingsProvider.getInitializedSettings(key)) == null || (kotlinFacetSettingsProvider = kotlinFacetSettingsProvider.getTargetPlatform()) == null) {
            Project project3 = key.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            kotlinFacetSettingsProvider = TargetPlatformDetectorUtils.getPlatform(project3);
            if (kotlinFacetSettingsProvider == null) {
                kotlinFacetSettingsProvider = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
            }
        }
        return kotlinFacetSettingsProvider;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/project/ModulePlatformCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/project/ModulePlatformCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.facet"})
    @SourceDebugExtension(value={"SMAP\nModulePlatformCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulePlatformCache.kt\norg/jetbrains/kotlin/idea/project/ModulePlatformCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,43:1\n30#2,3:44\n*S KotlinDebug\n*F\n+ 1 ModulePlatformCache.kt\norg/jetbrains/kotlin/idea/project/ModulePlatformCache$Companion\n*L\n41#1:44,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModulePlatformCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ModulePlatformCache> serviceClass$iv = ModulePlatformCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ModulePlatformCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/project/ModulePlatformCache$ModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ModuleEntityChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/module/Module;", "kotlin.base.facet"})
    public static final class ModelChangeListener
    extends ModuleEntityChangeListener {
        public ModelChangeListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(project2, false, 2, null);
        }

        @Override
        protected void entitiesChanged(@NotNull List<? extends Module> outdated) {
            Intrinsics.checkNotNullParameter(outdated, (String)"outdated");
            ModulePlatformCache platformCache = Companion.getInstance(this.getProject());
            FineGrainedEntityCache.invalidateKeys$default(platformCache, outdated, null, 2, null);
        }
    }
}

