/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ItemPresentation;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotatedFilePresentation;", "Lcom/intellij/navigation/ItemPresentation;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getIcon", "Ljavax/swing/Icon;", "unused", "", "getLocationString", "", "getPresentableText", "kotlin.idea"})
public final class KtJvmNameAnnotatedFilePresentation
implements ItemPresentation {
    @NotNull
    private final KtAnnotationEntry annotationEntry;
    @NotNull
    private final KtFile containingFile;

    public KtJvmNameAnnotatedFilePresentation(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        this.annotationEntry = annotationEntry2;
        KtFile ktFile = this.annotationEntry.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        this.containingFile = ktFile;
    }

    @Nullable
    public String getPresentableText() {
        return JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(this.annotationEntry);
    }

    @NotNull
    public String getLocationString() {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.containingFile.getName(), (String)"getName(...)");
        objectArray[1] = this.containingFile.getPackageFqName();
        return KotlinBundle.message("presentation.text.in.container", objectArray);
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon = KotlinIcons.FILE;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FILE");
        return icon;
    }
}

