/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.AbstractKotlinApplicableIntentionWithContext;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicabilityRangeKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.RemoveArgumentNamesUtils;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.RemoveSingleArgumentNameIntention;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/AbstractKotlinApplicableIntentionWithContext;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention$SingleArgumentContext;", "()V", "apply", "", "element", "context", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getActionName", "", "getApplicabilityRange", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicabilityRange;", "getFamilyName", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention$SingleArgumentContext;", "SingleArgumentContext", "kotlin.code-insight.intentions-k2"})
@SourceDebugExtension(value={"SMAP\nRemoveSingleArgumentNameIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveSingleArgumentNameIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,84:1\n1855#2,2:85\n959#2,7:88\n1747#2,3:95\n1747#2,3:98\n142#3:87\n*S KotlinDebug\n*F\n+ 1 RemoveSingleArgumentNameIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention\n*L\n50#1:85,2\n67#1:88,7\n71#1:95,3\n73#1:98,3\n62#1:87\n*E\n"})
public final class RemoveSingleArgumentNameIntention
extends AbstractKotlinApplicableIntentionWithContext<KtValueArgument, SingleArgumentContext> {
    public RemoveSingleArgumentNameIntention() {
        super(Reflection.getOrCreateKotlinClass(KtValueArgument.class));
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("remove.argument.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName(@NotNull KtValueArgument element3, @NotNull SingleArgumentContext context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getFamilyName();
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtValueArgument element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!element3.isNamed() || element3.getArgumentExpression() == null) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        KtValueArgumentList ktValueArgumentList = psiElement2 instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement2 : null;
        return (ktValueArgumentList != null ? ktValueArgumentList.getParent() : null) instanceof KtCallElement;
    }

    @Override
    public void apply(@NotNull KtValueArgument element3, @NotNull SingleArgumentContext context2, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiElement psiElement2 = element3.getParent();
        KtValueArgumentList ktValueArgumentList = psiElement2 instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement2 : null;
        if (ktValueArgumentList == null) {
            return;
        }
        KtValueArgumentList argumentList2 = ktValueArgumentList;
        List<KtValueArgument> newArguments2 = KotlinPsiUtilsKt.createArgumentWithoutName(element3, context2.isVararg(), context2.isArrayOfCall());
        argumentList2.removeArgument(element3);
        Iterable $this$forEach$iv = CollectionsKt.asReversed(newArguments2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtValueArgument it = (KtValueArgument)element$iv;
            boolean bl = false;
            SmartPsiElementPointer<KtValueArgument> smartPsiElementPointer = context2.getAnchorArgumentPointer();
            argumentList2.addArgumentAfter(it, (KtValueArgument)(smartPsiElementPointer != null ? (KtValueArgument)smartPsiElementPointer.getElement() : null));
        }
    }

    @Override
    @NotNull
    public KotlinApplicabilityRange<KtValueArgument> getApplicabilityRange() {
        return KotlinApplicabilityRangeKt.applicabilityRange(getApplicabilityRange.1.INSTANCE);
    }

    @Override
    @Nullable
    public SingleArgumentContext prepareContext(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtValueArgument element3) {
        boolean nameCannotBeRemoved;
        List sortedArgumentsBeforeCurrent;
        boolean varargIsArrayOfCall;
        KtValueArgument vararg2;
        block14: {
            Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
            boolean $i$f$getStrictParentOfType = false;
            KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
            if (ktCallElement == null) {
                return null;
            }
            KtCallElement callElement2 = ktCallElement;
            RemoveArgumentNamesUtils.ArgumentsData argumentsData = RemoveArgumentNamesUtils.INSTANCE.collectSortedArgumentsThatCanBeUnnamed($context_receiver_0, callElement2);
            if (argumentsData == null) {
                return null;
            }
            RemoveArgumentNamesUtils.ArgumentsData argumentsData2 = argumentsData;
            List<KtValueArgument> sortedArguments = argumentsData2.component1();
            vararg2 = argumentsData2.component2();
            varargIsArrayOfCall = argumentsData2.component3();
            if (!sortedArguments.contains(element3)) {
                return null;
            }
            Object object = callElement2.getValueArgumentList();
            if (object == null || (object = object.getArguments()) == null) {
                return null;
            }
            Object allArguments = object;
            Iterable $this$takeWhile$iv = sortedArguments;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                KtValueArgument it = (KtValueArgument)item$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)element3))) break;
                list$iv.add(item$iv);
            }
            sortedArgumentsBeforeCurrent = list$iv;
            boolean supportsMixed = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element3).supportsFeature(LanguageFeature.MixedNamedArgumentsInTheirOwnPosition);
            if (supportsMixed) {
                $this$any$iv = CollectionsKt.withIndex((Iterable)sortedArgumentsBeforeCurrent);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument argument2;
                        IndexedValue bl = (IndexedValue)element$iv;
                        boolean bl2 = false;
                        int parameterIndex2 = bl.component1();
                        if (!(parameterIndex2 != allArguments.indexOf(argument2 = (KtValueArgument)bl.component2()))) continue;
                        v3 = true;
                        break block14;
                    }
                    v3 = false;
                }
            } else {
                $this$any$iv = sortedArgumentsBeforeCurrent;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl = false;
                        if (!it.isNamed()) continue;
                        v3 = true;
                        break block14;
                    }
                    v3 = nameCannotBeRemoved = false;
                }
            }
        }
        if (nameCannotBeRemoved) {
            return null;
        }
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)sortedArgumentsBeforeCurrent);
        return new SingleArgumentContext((SmartPsiElementPointer<KtValueArgument>)(ktValueArgument != null ? UtilsKt.createSmartPointer((PsiElement)((PsiElement)ktValueArgument)) : null), Intrinsics.areEqual((Object)element3, (Object)vararg2), Intrinsics.areEqual((Object)element3, (Object)vararg2) && varargIsArrayOfCall);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention$SingleArgumentContext;", "", "anchorArgumentPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "isVararg", "", "isArrayOfCall", "(Lcom/intellij/psi/SmartPsiElementPointer;ZZ)V", "getAnchorArgumentPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "()Z", "kotlin.code-insight.intentions-k2"})
    public static final class SingleArgumentContext {
        @Nullable
        private final SmartPsiElementPointer<KtValueArgument> anchorArgumentPointer;
        private final boolean isVararg;
        private final boolean isArrayOfCall;

        public SingleArgumentContext(@Nullable SmartPsiElementPointer<KtValueArgument> anchorArgumentPointer, boolean isVararg, boolean isArrayOfCall) {
            this.anchorArgumentPointer = anchorArgumentPointer;
            this.isVararg = isVararg;
            this.isArrayOfCall = isArrayOfCall;
        }

        @Nullable
        public final SmartPsiElementPointer<KtValueArgument> getAnchorArgumentPointer() {
            return this.anchorArgumentPointer;
        }

        public final boolean isVararg() {
            return this.isVararg;
        }

        public final boolean isArrayOfCall() {
            return this.isArrayOfCall;
        }
    }
}

