/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"backingName", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "canIntroduceBackingProperty", "", "createBackingProperty", "", "createGetter", "element", "createSetter", "introduceBackingProperty", "replaceFieldReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "propertyName", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nIntroduceBackingPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntentionKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n142#2:133\n2624#3,3:134\n*S KotlinDebug\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntentionKt\n*L\n40#1:133\n42#1:134,3\n*E\n"})
public final class IntroduceBackingPropertyIntentionKt {
    private static final boolean canIntroduceBackingProperty(KtProperty property2) {
        boolean bl;
        block10: {
            String string = property2.getName();
            if (string == null) {
                return false;
            }
            String name2 = string;
            if (property2.hasModifier(KtTokens.CONST_KEYWORD)) {
                return false;
            }
            if (ModifierListModifactorKt.hasJvmFieldAnnotation((KtAnnotated)property2)) {
                return false;
            }
            BindingContext bindingContext2 = ResolutionFacade.analyzeWithAllCompilerChecks$default(ResolutionUtils.getResolutionFacade((KtElement)property2), (KtElement)property2, null, 2, null).getBindingContext();
            Object object = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property2);
            PropertyDescriptor propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            if (propertyDescriptor == null) {
                return false;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            if (!Intrinsics.areEqual((Object)bindingContext2.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)descriptor2), (Object)true)) {
                return false;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)property2;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            if (ktClassOrObject == null) {
                return false;
            }
            KtClassOrObject containingClass = ktClassOrObject;
            if (ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)containingClass)) {
                return false;
            }
            Iterable $this$none$iv = containingClass.getDeclarations();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)("_" + name2)))) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void introduceBackingProperty(KtProperty property2) {
        KtPropertyAccessor getter2;
        IntroduceBackingPropertyIntentionKt.createBackingProperty(property2);
        property2.removeModifier(KtTokens.LATEINIT_KEYWORD);
        if (property2.getTypeReference() == null) {
            KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration((KtCallableDeclaration)property2);
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(null, (KtCallableDeclaration)property2, type2);
        }
        if ((getter2 = property2.getGetter()) == null) {
            IntroduceBackingPropertyIntentionKt.createGetter(property2);
        } else {
            KtElement ktElement = (KtElement)getter2;
            String string = property2.getName();
            Intrinsics.checkNotNull((Object)string);
            IntroduceBackingPropertyIntentionKt.replaceFieldReferences(ktElement, string);
        }
        if (property2.isVar()) {
            KtPropertyAccessor setter2 = property2.getSetter();
            if (setter2 == null) {
                IntroduceBackingPropertyIntentionKt.createSetter(property2);
            } else {
                KtElement ktElement = (KtElement)setter2;
                String string = property2.getName();
                Intrinsics.checkNotNull((Object)string);
                IntroduceBackingPropertyIntentionKt.replaceFieldReferences(ktElement, string);
            }
        }
        property2.setInitializer(null);
    }

    private static final void createGetter(KtProperty element3) {
        String body2 = "get() = " + IntroduceBackingPropertyIntentionKt.backingName(element3);
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project2, false, 2, null).createProperty("val x " + body2).getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newGetter = ktPropertyAccessor;
        IntroduceBackingPropertyIntentionKt.addAccessor(element3, newGetter);
    }

    private static final void createSetter(KtProperty element3) {
        String body2 = "set(value) { " + IntroduceBackingPropertyIntentionKt.backingName(element3) + " = value }";
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project2, false, 2, null).createProperty("val x " + body2).getSetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newSetter = ktPropertyAccessor;
        IntroduceBackingPropertyIntentionKt.addAccessor(element3, newSetter);
    }

    private static final void addAccessor(KtProperty $this$addAccessor, KtPropertyAccessor newAccessor) {
        ASTNode semicolon = $this$addAccessor.getNode().findChildByType((IElementType)KtTokens.SEMICOLON);
        ASTNode aSTNode = semicolon;
        $this$addAccessor.addBefore((PsiElement)newAccessor, (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
    }

    private static final void createBackingProperty(KtProperty property2) {
        Project project2 = property2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtDeclaration backingProperty2 = CreateByPatternKt.buildDeclaration((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (Function1)((Function1)new Function1<BuilderByPattern<KtDeclaration>, Unit>(property2){
            final /* synthetic */ KtProperty $property;
            {
                this.$property = $property;
                super(1);
            }

            public final void invoke(@NotNull BuilderByPattern<KtDeclaration> $this$buildDeclaration) {
                Intrinsics.checkNotNullParameter($this$buildDeclaration, (String)"$this$buildDeclaration");
                $this$buildDeclaration.appendFixedText("private ");
                String string = this.$property.getValOrVarKeyword().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                $this$buildDeclaration.appendFixedText(string);
                $this$buildDeclaration.appendFixedText(" ");
                $this$buildDeclaration.appendNonFormattedText(IntroduceBackingPropertyIntentionKt.access$backingName(this.$property));
                if (this.$property.getTypeReference() != null) {
                    $this$buildDeclaration.appendFixedText(": ");
                    $this$buildDeclaration.appendTypeReference(this.$property.getTypeReference());
                }
                if (this.$property.getInitializer() != null) {
                    $this$buildDeclaration.appendFixedText(" = ");
                    $this$buildDeclaration.appendExpression(this.$property.getInitializer());
                }
            }
        }));
        if (property2.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            backingProperty2.addModifier(KtTokens.LATEINIT_KEYWORD);
        }
        property2.getParent().addBefore((PsiElement)backingProperty2, (PsiElement)property2);
    }

    private static final String backingName(KtProperty property2) {
        Object object = property2.getNameIdentifier();
        return (object != null && (object = object.getText()) != null ? StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)'`', (boolean)false, (int)2, null) : false) ? "`_" + property2.getName() + "`" : "_" + property2.getName();
    }

    private static final void replaceFieldReferences(KtElement element3, String propertyName) {
        element3.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(element3, propertyName){
            final /* synthetic */ KtElement $element;
            final /* synthetic */ String $propertyName;
            {
                this.$element = $element;
                this.$propertyName = $propertyName;
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                CallableDescriptor target2;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)expression2, null, 1, null);
                Object object = target2 = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                if (target2 instanceof SyntheticFieldDescriptor) {
                    Project project2 = this.$element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    expression2.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createSimpleName("_" + this.$propertyName));
                }
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
            }
        });
    }

    public static final /* synthetic */ boolean access$canIntroduceBackingProperty(KtProperty property2) {
        return IntroduceBackingPropertyIntentionKt.canIntroduceBackingProperty(property2);
    }

    public static final /* synthetic */ void access$introduceBackingProperty(KtProperty property2) {
        IntroduceBackingPropertyIntentionKt.introduceBackingProperty(property2);
    }

    public static final /* synthetic */ String access$backingName(KtProperty property2) {
        return IntroduceBackingPropertyIntentionKt.backingName(property2);
    }
}

