/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IndentRawStringIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nIndentRawStringIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentRawStringIntention.kt\norg/jetbrains/kotlin/idea/intentions/IndentRawStringIntention\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,50:1\n1247#2,2:51\n12474#3,2:53\n13374#3,3:55\n*S KotlinDebug\n*F\n+ 1 IndentRawStringIntention.kt\norg/jetbrains/kotlin/idea/intentions/IndentRawStringIntention\n*L\n24#1:51,2\n27#1:53,2\n39#1:55,3\n*E\n"})
public final class IndentRawStringIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression> {
    public IndentRawStringIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage("indent.raw.string", new Object[0]), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)element3));
        boolean $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            boolean bl;
            PsiElement it = (PsiElement)element$iv;
            boolean bl2 = false;
            if (it instanceof KtAnnotationEntry) return false;
            KtProperty ktProperty = it instanceof KtProperty ? (KtProperty)it : null;
            if (ktProperty != null) {
                if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
            boolean bl3 = false;
            if (!bl3) continue;
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element3)) != null) {
            return false;
        }
        KtStringTemplateEntry[] entries2 = element3.getEntries();
        if (entries2.length <= 1) return false;
        Intrinsics.checkNotNull((Object)entries2);
        KtStringTemplateEntry[] $this$any$iv2 = entries2;
        boolean $i$f$any2 = false;
        int n = 0;
        int n2 = $this$any$iv2.length;
        while (n < n2) {
            KtStringTemplateEntry element$iv;
            KtStringTemplateEntry it = element$iv = $this$any$iv2[n];
            boolean bl4 = false;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string2, (String)" ", (boolean)false, (int)2, null)) return false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string3, (String)"\t", (boolean)false, (int)2, null)) {
                return false;
            }
            boolean bl5 = false;
            if (bl5) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)((PsiFile)file2));
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project3);
        PsiFile psiFile2 = (PsiFile)file2;
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        String string = codeStyleManager.getLineIndent(psiFile2, PsiUtilsKt.getStartOffset((PsiElement)psiElement2));
        if (string == null) {
            string = "";
        }
        String parentIndent = string;
        String indent = indentOptions2.USE_TAB_CHARACTER ? parentIndent + "\t" : parentIndent + StringsKt.repeat((CharSequence)" ", (int)indentOptions2.INDENT_SIZE);
        StringBuilder $this$applyTo_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int maxIndex = element3.getEntries().length - 1;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$forEachIndexed$iv = ktStringTemplateEntryArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n = index$iv++;
            KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index == 0) {
                $this$applyTo_u24lambda_u243.append("\n" + indent);
            }
            $this$applyTo_u24lambda_u243.append(entry.getText());
            if (Intrinsics.areEqual((Object)entry.getText(), (Object)"\n")) {
                $this$applyTo_u24lambda_u243.append(indent);
            }
            if (index != maxIndex) continue;
            $this$applyTo_u24lambda_u243.append("\n" + indent);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String newString = string2;
        element3.replace((PsiElement)new KtPsiFactory(project3, false, 2, null).createExpression("\"\"\"" + newString + "\"\"\".trimIndent()"));
    }
}

