/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.ChangeVariableMutabilityFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.ValVarExpression;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001b\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction;", "", "canInvoke", "", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "AnnotationClassConstructorNotValPropertyQuickFixFactory", "DataClassConstructorNotPropertyQuickFixFactory", "Intention", "QuickFix", "ValueClassConstructorNotValPropertyQuickFixFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddValVarToConstructorParameterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddValVarToConstructorParameterAction.kt\norg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public interface AddValVarToConstructorParameterAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean canInvoke(@NotNull KtParameter element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.getValOrVarKeyword() != null) return false;
        PsiElement psiElement2 = element3.getParent();
        KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
        PsiElement psiElement3 = ktParameterList != null ? ktParameterList.getParent() : null;
        if (!(psiElement3 instanceof KtPrimaryConstructor)) return false;
        KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)psiElement3;
        if (ktPrimaryConstructor == null) return false;
        PsiElement it = psiElement3 = ktPrimaryConstructor;
        boolean bl = false;
        if (!KotlinPsiUtils.mustHaveValOrVar((KtPrimaryConstructor)it)) {
            if (ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)it)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        PsiElement psiElement4 = psiElement3;
        if (psiElement4 == null) return false;
        return true;
    }

    default public void invoke(@NotNull KtParameter element3, @Nullable Editor editor2) {
        TemplateBuilderImpl templateBuilderImpl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        element3.addBefore(new KtPsiFactory(project3, false, 2, null).createValKeyword(), element3.getNameIdentifier());
        KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)element3));
        boolean bl = ktClass2 != null ? KotlinPsiUtils.mustHaveOnlyValPropertiesInPrimaryConstructor(ktClass2) : false;
        if (bl || editor2 == null) {
            return;
        }
        SmartPsiElementPointer it = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)element3));
        boolean bl2 = false;
        PsiDocumentManager.getInstance((Project)project3).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        KtParameter ktParameter = (KtParameter)it.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter2 = ktParameter;
        editor2.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)parameter2)));
        TemplateBuilderImpl $this$invoke_u24lambda_u242 = templateBuilderImpl = new TemplateBuilderImpl((PsiElement)parameter2);
        boolean bl3 = false;
        PsiElement psiElement2 = parameter2.getValOrVarKeyword();
        if (psiElement2 != null) {
            $this$invoke_u24lambda_u242.replaceElement(psiElement2, (Expression)ValVarExpression.INSTANCE);
        }
        Template it2 = templateBuilderImpl.buildInlineTemplate();
        boolean bl4 = false;
        TemplateManager.getInstance((Project)project3).startTemplate(editor2, it2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$AnnotationClassConstructorNotValPropertyQuickFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$QuickFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class AnnotationClassConstructorNotValPropertyQuickFixFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final AnnotationClassConstructorNotValPropertyQuickFixFactory INSTANCE = new AnnotationClassConstructorNotValPropertyQuickFixFactory();

        private AnnotationClassConstructorNotValPropertyQuickFixFactory() {
        }

        @Override
        @NotNull
        protected QuickFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((SimpleDiagnostic)Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-psiElement>(...)");
            return new QuickFix((KtParameter)psiElement2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$DataClassConstructorNotPropertyQuickFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$QuickFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class DataClassConstructorNotPropertyQuickFixFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final DataClassConstructorNotPropertyQuickFixFactory INSTANCE = new DataClassConstructorNotPropertyQuickFixFactory();

        private DataClassConstructorNotPropertyQuickFixFactory() {
        }

        @Override
        @NotNull
        protected QuickFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((SimpleDiagnostic)Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-psiElement>(...)");
            return new QuickFix((KtParameter)psiElement2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$Intention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddValVarToConstructorParameterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddValVarToConstructorParameterAction.kt\norg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$Intention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,109:1\n142#2:110\n*S KotlinDebug\n*F\n+ 1 AddValVarToConstructorParameterAction.kt\norg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$Intention\n*L\n60#1:110\n*E\n"})
    public static final class Intention
    extends SelfTargetingRangeIntention<KtParameter>
    implements AddValVarToConstructorParameterAction {
        public Intention() {
            super(KtParameter.class, KotlinBundle.lazyMessage("add.val.var.to.primary.constructor.parameter", new Object[0]), null, 4, null);
        }

        @Override
        @Nullable
        public TextRange applicabilityRange(@NotNull KtParameter element3) {
            KtClass containingClass;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!this.canInvoke(element3)) {
                return null;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
            boolean $i$f$getStrictParentOfType = false;
            KtClass ktClass2 = containingClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            boolean bl = ktClass2 != null ? KotlinPsiUtils.mustHaveOnlyPropertiesInPrimaryConstructor(ktClass2) : false;
            if (bl) {
                return null;
            }
            Object[] objectArray = new Object[1];
            String string = element3.getName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            this.setTextGetter(KotlinBundle.lazyMessage("add.val.var.to.parameter.0", objectArray));
            PsiElement psiElement2 = element3.getNameIdentifier();
            return psiElement2 != null ? psiElement2.getTextRange() : null;
        }

        @Override
        public void applyTo(@NotNull KtParameter element3, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            this.invoke(element3, editor2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$QuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction;", "parameter", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddValVarToConstructorParameterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddValVarToConstructorParameterAction.kt\norg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$QuickFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,109:1\n142#2:110\n*S KotlinDebug\n*F\n+ 1 AddValVarToConstructorParameterAction.kt\norg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$QuickFix\n*L\n77#1:110\n*E\n"})
    public static final class QuickFix
    extends KotlinQuickFixAction<KtParameter>
    implements AddValVarToConstructorParameterAction {
        public QuickFix(@NotNull KtParameter parameter2) {
            Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
            super((PsiElement)parameter2);
        }

        @NotNull
        public String getText() {
            KtParameter ktParameter = (KtParameter)this.getElement();
            if (ktParameter == null) {
                return "";
            }
            KtParameter element3 = ktParameter;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
            boolean $i$f$getStrictParentOfType = false;
            KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            String key = (ktClass2 != null ? KotlinPsiUtils.mustHaveOnlyValPropertiesInPrimaryConstructor(ktClass2) : false) ? "add.val.to.parameter.0" : "add.val.var.to.parameter.0";
            Object[] objectArray = new Object[1];
            String string = element3.getName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            return KotlinBundle.message(key, objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("add.val.var.to.primary.constructor.parameter", new Object[0]);
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtParameter ktParameter = (KtParameter)this.getElement();
            if (ktParameter == null) {
                return;
            }
            this.invoke(ktParameter, editor2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddValVarToConstructorParameterAction$ValueClassConstructorNotValPropertyQuickFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class ValueClassConstructorNotValPropertyQuickFixFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final ValueClassConstructorNotValPropertyQuickFixFactory INSTANCE = new ValueClassConstructorNotValPropertyQuickFixFactory();

        private ValueClassConstructorNotValPropertyQuickFixFactory() {
        }

        @Override
        @NotNull
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((SimpleDiagnostic)Errors.VALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-psiElement>(...)");
            KtParameter parameter2 = (KtParameter)psiElement2;
            return parameter2.isMutable() ? (IntentionAction)new ChangeVariableMutabilityFix((KtValVarKeywordOwner)parameter2, false, null, false, 12, null) : (IntentionAction)new QuickFix(parameter2);
        }
    }
}

