/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithEnumMapInspectionKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithEnumMapInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceWithEnumMapFix", "kotlin.idea"})
public final class ReplaceWithEnumMapInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtCallExpression element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)element3))) {
                    return;
                }
                BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)element3, null, 1, null);
                Object object = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)context2);
                if (object == null || (object = object.getResultingDescriptor()) == null || (object = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
                    return;
                }
                Object fqName2 = object;
                if (!ReplaceWithEnumMapInspectionKt.access$getHashMapCreationFqNames$p().contains(fqName2)) {
                    return;
                }
                List list2 = element3.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                if (!((Collection)list2).isEmpty()) {
                    return;
                }
                KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.EXPECTED_EXPRESSION_TYPE, (Object)element3);
                if (kotlinType == null) {
                    return;
                }
                KotlinType expectedType = kotlinType;
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull((List)expectedType.getArguments());
                if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
                    return;
                }
                TypeProjection firstArgType = typeProjection;
                if (!TypeUtilsKt.isEnum((KotlinType)firstArgType)) {
                    return;
                }
                Object object2 = firstArgType.getConstructor().getDeclarationDescriptor();
                if (object2 == null || (object2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)object2))) == null || (object2 = object2.asString()) == null) {
                    return;
                }
                Object enumClassName = object2;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceWithEnumMapFix((String)enumClassName)};
                this.$holder.registerProblem((PsiElement)element3, KotlinBundle.message("replaceable.with.enummap", new Object[0]), localQuickFixArray);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithEnumMapInspection$ReplaceWithEnumMapFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "enumClassName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class ReplaceWithEnumMapFix
    implements LocalQuickFix {
        @NotNull
        private final String enumClassName;

        public ReplaceWithEnumMapFix(@NotNull String enumClassName) {
            Intrinsics.checkNotNullParameter((Object)enumClassName, (String)"enumClassName");
            this.enumClassName = enumClassName;
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.enum.map.fix.text", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call = ktCallExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            KtFile ktFile = call.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtFile file2 = ktFile;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ResolutionUtils.resolveImportReference(file2, new FqName("java.util.EnumMap")));
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor enumMapDescriptor = declarationDescriptor;
            ImportInsertHelper importInsertHelper = ImportInsertHelper.Companion.getInstance(project2);
            KtFile ktFile2 = call.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
            ImportInsertHelper.importDescriptor$default(importInsertHelper, ktFile2, enumMapDescriptor, false, 4, null);
            Object[] objectArray = new Object[]{this.enumClassName};
            call.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"EnumMap($0::class.java)", (Object[])objectArray, (boolean)false, (int)4, null));
        }
    }
}

