/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.inspections.AddKotlinLibQuickFix;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "getText", "Companion", "kotlin.jvm"})
public final class AddScriptRuntimeQuickFix
extends AddKotlinLibQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddScriptRuntimeQuickFix(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super(element3, LibraryJarDescriptor.SCRIPT_RUNTIME_JAR, DependencyScope.COMPILE);
    }

    @NotNull
    public String getText() {
        return KotlinJvmBundle.message("classpath.add.script.runtime", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected AddKotlinLibQuickFix.MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        return AddKotlinLibQuickFix.MavenExternalLibraryDescriptor.Companion.create("org.jetbrains.kotlin", "kotlin-script-runtime", ideKotlinVersion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nAddKotlinLibQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddKotlinLibQuickFix.kt\norg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix$Companion\n+ 2 quickfixUtil.kt\norg/jetbrains/kotlin/idea/util/QuickfixUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,152:1\n25#2:153\n146#3:154\n*S KotlinDebug\n*F\n+ 1 AddKotlinLibQuickFix.kt\norg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix$Companion\n*L\n63#1:153\n63#1:154\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtElement> createAction(@NotNull Diagnostic diagnostic) {
            KotlinQuickFixAction kotlinQuickFixAction;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Diagnostic $this$createIntentionForFirstParentOfType$iv = diagnostic;
            boolean $i$f$createIntentionForFirstParentOfType = false;
            PsiElement $this$getNonStrictParentOfType$iv$iv = $this$createIntentionForFirstParentOfType$iv.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtElement.class, (boolean)false);
            if (psiElement2 != null) {
                KtElement p0 = (KtElement)psiElement2;
                boolean bl = false;
                kotlinQuickFixAction = new AddScriptRuntimeQuickFix(p0);
            } else {
                kotlinQuickFixAction = null;
            }
            return kotlinQuickFixAction;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

