/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixUpdater;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticKt;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixService;
import org.jetbrains.kotlin.idea.highlighting.KotlinDiagnosticHighlightVisitor;
import org.jetbrains.kotlin.idea.inspections.suppress.CompilerWarningIntentionAction;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.statistics.compilationError.KotlinCompilationErrorFrequencyStatsCollector;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0019\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020!*\u00020\"H\u0003J\u0019\u0010#\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010$J\u0019\u0010%\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u000fH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010$R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "()V", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "getHolder", "()Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "setHolder", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "addDiagnostic", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "diagnostic", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "analyze", "", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "action", "Ljava/lang/Runnable;", "clone", "isInternalOrUnitTestMode", "suitableForFile", "visit", "element", "Lcom/intellij/psi/PsiElement;", "getHighlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "getMessageToRender", "", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic;", "isDeprecatedDiagnostic", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;)Z", "isUnresolvedDiagnostic", "kotlin.highlighting.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinDiagnosticHighlightVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDiagnosticHighlightVisitor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n27#2,2:161\n55#3:163\n69#3,8:164\n1#4:172\n1855#5,2:173\n*S KotlinDebug\n*F\n+ 1 KotlinDiagnosticHighlightVisitor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor\n*L\n58#1:161,2\n58#1:163\n58#1:164,8\n80#1:173,2\n*E\n"})
public final class KotlinDiagnosticHighlightVisitor
implements HighlightVisitor {
    @Nullable
    private HighlightInfoHolder holder;

    @Nullable
    public final HighlightInfoHolder getHolder() {
        return this.holder;
    }

    public final void setHolder(@Nullable HighlightInfoHolder highlightInfoHolder) {
        this.holder = highlightInfoHolder;
    }

    public boolean suitableForFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof KtFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance((Project)file2.getProject());
        if (highlightingLevelManager.runEssentialHighlightingOnly((PsiElement)file2)) {
            return true;
        }
        this.holder = holder;
        try {
            action2.run();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw e;
        }
        finally {
            this.holder = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void analyze(KtFile file2) {
        void this_$iv$iv$iv;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)file2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)file2);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$analyze_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl = false;
            Collection<KtDiagnosticWithPsi<?>> diagnostics2 = $this$analyze_u24lambda_u240.collectDiagnosticsForFile(file2, KtDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            for (KtDiagnosticWithPsi<?> diagnostic : diagnostics2) {
                HighlightInfoHolder highlightInfoHolder = this.holder;
                Intrinsics.checkNotNull((Object)highlightInfoHolder);
                this.addDiagnostic($this$analyze_u24lambda_u240, file2, diagnostic, highlightInfoHolder);
            }
            KotlinCompilationErrorFrequencyStatsCollector.INSTANCE.recordCompilationErrorsHappened((Sequence<String>)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)diagnostics2), (Function1)analyze.1.1.INSTANCE), (Function1)((Function1)analyze.1.2.INSTANCE)), file2);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final void addDiagnostic(KtAnalysisSession $context_receiver_0, KtFile file2, KtDiagnosticWithPsi<?> diagnostic, HighlightInfoHolder holder) {
        List list2;
        boolean isWarning = diagnostic.getSeverity() == Severity.WARNING;
        Object psiElement2 = diagnostic.getPsi();
        String factoryName = diagnostic.getFactoryName();
        List it = list2 = KotlinQuickFixService.Companion.getInstance().getQuickFixesFor($context_receiver_0, diagnostic);
        boolean bl = false;
        List list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            list3 = isWarning && factoryName != null ? CollectionsKt.listOf((Object)((Object)new CompilerWarningIntentionAction(factoryName))) : CollectionsKt.emptyList();
        }
        List fixes2 = list3;
        KotlinSuppressableWarningProblemGroup problemGroup = isWarning && factoryName != null ? new KotlinSuppressableWarningProblemGroup(factoryName) : null;
        Iterable $this$forEach$iv = diagnostic.getTextRanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HighlightInfo.Builder infoBuilder;
            TextRange range2 = (TextRange)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)HighlightInfo.newHighlightInfo((HighlightInfoType)this.getHighlightInfoType($context_receiver_0, diagnostic)).descriptionAndTooltip(this.getMessageToRender(diagnostic)).range(range2), (String)"range(...)");
            if (problemGroup != null) {
                infoBuilder.problemGroup((ProblemGroup)problemGroup);
            }
            for (IntentionAction quickFixInfo : fixes2) {
                if (quickFixInfo.asModCommandAction() != null && !quickFixInfo.isAvailable(file2.getProject(), null, (PsiFile)file2)) continue;
                List options2 = new ArrayList();
                if (quickFixInfo instanceof IntentionActionWithOptions) {
                    Collection collection = options2;
                    List list4 = ((IntentionActionWithOptions)quickFixInfo).getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getOptions(...)");
                    CollectionsKt.addAll((Collection)collection, (Iterable)list4);
                }
                if (problemGroup != null) {
                    CollectionsKt.addAll((Collection)options2, (Object[])problemGroup.getSuppressActions((PsiElement)psiElement2));
                }
                infoBuilder.registerFix(quickFixInfo, options2, null, null, null);
            }
            if (diagnostic instanceof KtFirDiagnostic.UnresolvedImport || diagnostic instanceof KtFirDiagnostic.UnresolvedReference) {
                if (psiElement2.getReference() != null) {
                    PsiReference it2;
                    boolean bl3 = false;
                    UnresolvedReferenceQuickFixUpdater.getInstance((Project)holder.getProject()).registerQuickFixesLater(it2, infoBuilder);
                }
            }
            holder.add(infoBuilder.create());
        }
    }

    @NlsSafe
    private final String getMessageToRender(KtDiagnostic $this$getMessageToRender) {
        return this.isInternalOrUnitTestMode() ? KtDiagnosticKt.getDefaultMessageWithFactoryName($this$getMessageToRender) : $this$getMessageToRender.getDefaultMessage();
    }

    private final boolean isInternalOrUnitTestMode() {
        Application application = ApplicationManager.getApplication();
        return application.isInternal() || application.isUnitTestMode();
    }

    private final HighlightInfoType getHighlightInfoType(KtAnalysisSession $context_receiver_0, KtDiagnosticWithPsi<?> $this$getHighlightInfoType) {
        HighlightInfoType highlightInfoType;
        if (this.isUnresolvedDiagnostic($context_receiver_0, $this$getHighlightInfoType)) {
            HighlightInfoType highlightInfoType2 = HighlightInfoType.WRONG_REF;
            highlightInfoType = highlightInfoType2;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType2, (String)"WRONG_REF");
        } else if (this.isDeprecatedDiagnostic($context_receiver_0, $this$getHighlightInfoType)) {
            HighlightInfoType highlightInfoType3 = HighlightInfoType.DEPRECATED;
            highlightInfoType = highlightInfoType3;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType3, (String)"DEPRECATED");
        } else {
            HighlightInfoType highlightInfoType4 = switch (WhenMappings.$EnumSwitchMapping$0[$this$getHighlightInfoType.getSeverity().ordinal()]) {
                case 1 -> HighlightInfoType.INFORMATION;
                case 2 -> HighlightInfoType.ERROR;
                case 3 -> HighlightInfoType.WARNING;
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)highlightInfoType4);
            highlightInfoType = highlightInfoType4;
        }
        return highlightInfoType;
    }

    private final boolean isUnresolvedDiagnostic(KtAnalysisSession $context_receiver_0, KtDiagnosticWithPsi<?> $this$isUnresolvedDiagnostic) {
        KtDiagnosticWithPsi<?> ktDiagnosticWithPsi = $this$isUnresolvedDiagnostic;
        return ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedReference ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedLabel ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedReferenceWrongReceiver ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedImport ? true : ktDiagnosticWithPsi instanceof KtFirDiagnostic.MissingStdlibClass)));
    }

    private final boolean isDeprecatedDiagnostic(KtAnalysisSession $context_receiver_0, KtDiagnosticWithPsi<?> $this$isDeprecatedDiagnostic) {
        return $this$isDeprecatedDiagnostic instanceof KtFirDiagnostic.Deprecation;
    }

    public void visit(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtFile) {
            this.analyze((KtFile)element3);
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return new KotlinDiagnosticHighlightVisitor();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

