/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfoSearcher;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfoSearcher$checkIfInReceiverTypeReference$;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher;", "", "()V", "checkIfInReceiverTypeReference", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "target", "Lcom/intellij/psi/PsiElement;", "checkIfInThisReference", "findReceiverByThisCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "refExpr", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findReceiverByThisRef", "findReceiverInfoForUsageHighlighting", "isReceiverReference", "", "element", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "toInfo", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinHighlightReceiverUsagesHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinHighlightReceiverUsagesHandlerFactory.kt\norg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n473#2:289\n179#2,2:290\n1#3:292\n*S KotlinDebug\n*F\n+ 1 KotlinHighlightReceiverUsagesHandlerFactory.kt\norg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher\n*L\n52#1:289\n53#1:290,2\n*E\n"})
public final class ReceiverInfoSearcher {
    @NotNull
    public static final ReceiverInfoSearcher INSTANCE = new ReceiverInfoSearcher();

    private ReceiverInfoSearcher() {
    }

    @Nullable
    public final ReceiverInfo findReceiverInfoForUsageHighlighting(@NotNull PsiElement target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        ReceiverInfo receiverInfo = this.checkIfInThisReference(target2);
        if (receiverInfo == null) {
            receiverInfo = this.checkIfInReceiverTypeReference(target2);
        }
        return receiverInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ReceiverInfo checkIfInReceiverTypeReference(PsiElement target2) {
        ReceiverInfo receiverInfo;
        Object v1;
        block3: {
            Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)target2, (boolean)true), (Function1)checkIfInReceiverTypeReference.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkIfInReceiverTypeReference$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtTypeReference e = (KtTypeReference)element$iv;
                boolean bl = false;
                if (!INSTANCE.isReceiverReference(e)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        KtTypeReference ktTypeReference = v1;
        if (ktTypeReference == null) return null;
        KtTypeReference receiverRef = ktTypeReference;
        boolean bl = false;
        PsiElement psiElement2 = receiverRef.getParent();
        if (!(psiElement2 instanceof KtCallableDeclaration)) return null;
        KtCallableDeclaration ktCallableDeclaration2 = (KtCallableDeclaration)psiElement2;
        KtCallableDeclaration ktCallableDeclaration3 = ktCallableDeclaration2;
        if (ktCallableDeclaration3 == null) return null;
        KtCallableDeclaration callable2 = ktCallableDeclaration3;
        boolean bl2 = false;
        psiElement2 = callable2;
        if (psiElement2 instanceof KtNamedFunction) {
            ReceiverInfo.Function function2;
            ReceiverInfo.Function it = function2 = new ReceiverInfo.Function((KtFunction)callable2);
            boolean bl3 = false;
            receiverInfo = ((KtNamedFunction)callable2).hasBody() ? function2 : null;
            return receiverInfo;
        } else {
            ReceiverInfo.Property property2;
            if (!(psiElement2 instanceof KtProperty)) return null;
            ReceiverInfo.Property it = property2 = new ReceiverInfo.Property((KtProperty)callable2);
            boolean bl4 = false;
            List list2 = ((KtProperty)callable2).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            receiverInfo = !((Collection)list2).isEmpty() ? property2 : null;
        }
        return receiverInfo;
    }

    private final boolean isReceiverReference(KtTypeReference element3) {
        PsiElement psiElement2 = element3.getParent();
        Object object = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
        if (object == null) {
            psiElement2 = element3.getParent();
            object = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
        }
        if (object == null) {
            return false;
        }
        KtCallableDeclaration callable2 = (KtCallableDeclaration)object;
        return Intrinsics.areEqual((Object)callable2.getReceiverTypeReference(), (Object)element3);
    }

    private final ReceiverInfo checkIfInThisReference(PsiElement target2) {
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)target2), (Object)KtTokens.THIS_KEYWORD)) {
            return null;
        }
        PsiElement psiElement2 = target2.getParent();
        KtReferenceExpression ktReferenceExpression = psiElement2 instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement2 : null;
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression refExpr = ktReferenceExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)refExpr, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)refExpr), (BindingContext)bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        ReceiverInfo receiverInfo = this.findReceiverByThisRef((ResolvedCall<? extends CallableDescriptor>)resolvedCall3);
        if (receiverInfo != null) {
            ReceiverInfo receiverTypeReference = receiverInfo;
            boolean bl = false;
            return receiverTypeReference;
        }
        receiverInfo = this.findReceiverByThisCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall3, refExpr, bindingContext2);
        if (receiverInfo != null) {
            ReceiverInfo receiverTypeReference = receiverInfo;
            boolean bl = false;
            return receiverTypeReference;
        }
        return null;
    }

    private final ReceiverInfo findReceiverByThisCall(ResolvedCall<? extends CallableDescriptor> resolvedCall2, KtReferenceExpression refExpr, BindingContext bindingContext2) {
        ReceiverValue receiverValue;
        PsiElement psiElement2 = refExpr.getParent();
        KtThisExpression ktThisExpression = psiElement2 instanceof KtThisExpression ? (KtThisExpression)psiElement2 : null;
        if (!((ktThisExpression != null ? ktThisExpression.getParent() : null) instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call = ResolutionUtils.variableCallOrThis(resolvedCall2);
        ReceiverValue extensionReceiver = call.getExtensionReceiver();
        ReceiverValue dispatchReceiver = call.getDispatchReceiver();
        if (extensionReceiver == null && dispatchReceiver == null) {
            return null;
        }
        ReceiverValue receiverValue2 = extensionReceiver;
        if (receiverValue2 == null) {
            receiverValue2 = dispatchReceiver;
        }
        if ((receiverValue = receiverValue2) instanceof ImplicitReceiver) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = ExtensionUtils.getReceiverTargetDescriptor(receiverValue, bindingContext2);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor functionDescriptor2 = declarationDescriptor;
        return this.toInfo(functionDescriptor2);
    }

    private final ReceiverInfo findReceiverByThisRef(ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        ReceiverParameterDescriptor receiverParameterDescriptor = callableDescriptor instanceof ReceiverParameterDescriptor ? (ReceiverParameterDescriptor)callableDescriptor : null;
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        DeclarationDescriptor declarationDescriptor = receiverParameterDescriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        return this.toInfo(descriptor2);
    }

    private final ReceiverInfo toInfo(DeclarationDescriptor $this$toInfo) {
        PsiElement psi2 = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)$this$toInfo);
        return psi2 instanceof KtFunctionLiteral ? (ReceiverInfo)new ReceiverInfo.Lambda((KtFunctionLiteral)psi2) : (psi2 instanceof KtNamedFunction ? (ReceiverInfo)new ReceiverInfo.Function((KtFunction)psi2) : (psi2 instanceof KtProperty ? (ReceiverInfo)new ReceiverInfo.Property((KtProperty)psi2) : null));
    }
}

