/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinRecursiveCallLineMarkerProviderKt;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"getCallNameFromPsi", "Lorg/jetbrains/kotlin/name/Name;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getElementForLineMark", "Lcom/intellij/psi/PsiElement;", "callElement", "getLineNumber", "", "kotlin.idea"})
public final class KotlinRecursiveCallLineMarkerProviderKt {
    @NotNull
    public static final PsiElement getElementForLineMark(@NotNull PsiElement callElement2) {
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        return callElement2 instanceof KtSimpleNameExpression ? ((KtSimpleNameExpression)callElement2).getReferencedNameElement() : (PsiElement)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)callElement2, (Function1)getElementForLineMark.1.INSTANCE));
    }

    private static final int getLineNumber(PsiElement $this$getLineNumber) {
        Document document = PsiDocumentManager.getInstance((Project)$this$getLineNumber.getProject()).getDocument($this$getLineNumber.getContainingFile());
        Intrinsics.checkNotNull((Object)document);
        return document.getLineNumber($this$getLineNumber.getTextOffset());
    }

    private static final Name getCallNameFromPsi(KtElement element3) {
        KtElement ktElement = element3;
        if (ktElement instanceof KtSimpleNameExpression) {
            Lazy identifier2 = LazyKt.lazy((Function0)((Function0)new Function0<Name>(element3){
                final /* synthetic */ KtElement $element;
                {
                    this.$element = $element;
                    super(0);
                }

                @NotNull
                public final Name invoke() {
                    String string = ((KtSimpleNameExpression)this.$element).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    return Name.identifier((String)KotlinPsiModificationUtils.unquoteKotlinIdentifier(string));
                }
            }));
            PsiElement elementParent = element3.getParent();
            if (elementParent instanceof KtCallExpression) {
                return (Name)identifier2.getValue();
            }
            if (elementParent instanceof KtOperationExpression) {
                KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)elementParent).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
                KtSimpleNameExpression operationReference = ktSimpleNameExpression;
                if (Intrinsics.areEqual((Object)element3, (Object)operationReference)) {
                    Name name2;
                    IElementType node2 = operationReference.getReferencedNameElementType();
                    if (node2 instanceof KtToken) {
                        Name conventionName = elementParent instanceof KtPrefixExpression ? OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)node2), (boolean)true, (boolean)false) : OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)node2));
                        name2 = conventionName;
                        if (name2 == null) {
                            Object object = identifier2.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                            name2 = (Name)object;
                        }
                    } else {
                        name2 = (Name)identifier2.getValue();
                    }
                    return name2;
                }
            }
        } else {
            if (ktElement instanceof KtArrayAccessExpression) {
                return OperatorNameConventions.GET;
            }
            if (ktElement instanceof KtThisExpression && element3.getParent() instanceof KtCallExpression) {
                return OperatorNameConventions.INVOKE;
            }
        }
        return null;
    }

    public static final /* synthetic */ int access$getLineNumber(PsiElement $receiver) {
        return KotlinRecursiveCallLineMarkerProviderKt.getLineNumber($receiver);
    }

    public static final /* synthetic */ Name access$getCallNameFromPsi(KtElement element3) {
        return KotlinRecursiveCallLineMarkerProviderKt.getCallNameFromPsi(element3);
    }
}

