/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtil;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005%&'()B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0012J#\u0010\u0018\u001a\u00020\u00192\u001b\u0010\u001a\u001a\u0017\u0012\b\u0012\u00060\u001cR\u00020\u0000\u0012\u0004\u0012\u00020\u00190\u001b\u00a2\u0006\u0002\b\u001dJ\"\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\"\u001a\u00020 J#\u0010#\u001a\u00020\u00192\u001b\u0010\u001a\u001a\u0017\u0012\b\u0012\u00060$R\u00020\u0000\u0012\u0004\u0012\u00020\u00190\u001b\u00a2\u0006\u0002\b\u001dR\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "", "commonCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "spacingBuilderUtil", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;)V", "builders", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "Lkotlin/collections/ArrayList;", "getCommonCodeStyleSettings", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getSpacingBuilderUtil", "()Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "createSpacing", "Lcom/intellij/formatting/Spacing;", "minSpaces", "", "maxSpaces", "minLineFeeds", "keepLineBreaks", "", "keepBlankLines", "custom", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$CustomSpacingBuilder;", "Lkotlin/ExtensionFunctionType;", "getSpacing", "parent", "Lcom/intellij/formatting/Block;", "child1", "child2", "simple", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$BasicSpacingBuilder;", "BasicSpacingBuilder", "Builder", "Condition", "CustomSpacingBuilder", "Rule", "kotlin.formatter"})
public final class KotlinSpacingBuilder {
    @NotNull
    private final CommonCodeStyleSettings commonCodeStyleSettings;
    @NotNull
    private final KotlinSpacingBuilderUtil spacingBuilderUtil;
    @NotNull
    private final ArrayList<Builder> builders;

    public KotlinSpacingBuilder(@NotNull CommonCodeStyleSettings commonCodeStyleSettings, @NotNull KotlinSpacingBuilderUtil spacingBuilderUtil) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        Intrinsics.checkNotNullParameter((Object)spacingBuilderUtil, (String)"spacingBuilderUtil");
        this.commonCodeStyleSettings = commonCodeStyleSettings;
        this.spacingBuilderUtil = spacingBuilderUtil;
        this.builders = new ArrayList();
    }

    @NotNull
    public final CommonCodeStyleSettings getCommonCodeStyleSettings() {
        return this.commonCodeStyleSettings;
    }

    @NotNull
    public final KotlinSpacingBuilderUtil getSpacingBuilderUtil() {
        return this.spacingBuilderUtil;
    }

    @Nullable
    public final Spacing getSpacing(@NotNull Block parent2, @Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (!(parent2 instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        for (Builder builder2 : this.builders) {
            Spacing spacing2 = builder2.getSpacing((ASTBlock)parent2, (ASTBlock)child1, (ASTBlock)child2);
            if (spacing2 == null) continue;
            if (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode((ASTBlock)child1).getElementType(), (Object)KtTokens.EOL_COMMENT) && StringsKt.contains$default((CharSequence)spacing2.toString(), (CharSequence)"minLineFeeds=0", (boolean)false, (int)2, null)) {
                ASTNode aSTNode;
                boolean isBeforeBlock = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode((ASTBlock)child2).getElementType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)((aSTNode = FormatterUtilKt.requireNode((ASTBlock)child2).getFirstChildNode()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.BLOCK);
                int keepBlankLines = isBeforeBlock ? 0 : this.commonCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE;
                return KotlinSpacingBuilder.createSpacing$default(this, 0, 0, 1, true, keepBlankLines, 2, null);
            }
            return spacing2;
        }
        return null;
    }

    public final void simple(@NotNull Function1<? super BasicSpacingBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        BasicSpacingBuilder builder2 = new BasicSpacingBuilder();
        init2.invoke((Object)builder2);
        this.builders.add(builder2);
    }

    public final void custom(@NotNull Function1<? super CustomSpacingBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        CustomSpacingBuilder builder2 = new CustomSpacingBuilder();
        init2.invoke((Object)builder2);
        this.builders.add(builder2);
    }

    @NotNull
    public final Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        Spacing spacing2 = Spacing.createSpacing((int)minSpaces, (int)maxSpaces, (int)minLineFeeds, (boolean)keepLineBreaks, (int)keepBlankLines);
        Intrinsics.checkNotNullExpressionValue((Object)spacing2, (String)"createSpacing(...)");
        return spacing2;
    }

    public static /* synthetic */ Spacing createSpacing$default(KotlinSpacingBuilder kotlinSpacingBuilder, int n, int n2, int n3, boolean bl, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n2 = n;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            bl = kotlinSpacingBuilder.commonCodeStyleSettings.KEEP_LINE_BREAKS;
        }
        if ((n5 & 0x10) != 0) {
            n4 = kotlinSpacingBuilder.commonCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE;
        }
        return kotlinSpacingBuilder.createSpacing(n, n2, n3, bl, n4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$BasicSpacingBuilder;", "Lcom/intellij/formatting/SpacingBuilder;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "(Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;)V", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/ASTBlock;", "left", "right", "kotlin.formatter"})
    public final class BasicSpacingBuilder
    extends SpacingBuilder
    implements Builder {
        public BasicSpacingBuilder() {
            super(KotlinSpacingBuilder.this.getCommonCodeStyleSettings());
        }

        @Override
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock parent2, @NotNull ASTBlock left, @NotNull ASTBlock right) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return super.getSpacing((Block)parent2, (Block)left, (Block)right);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/ASTBlock;", "left", "right", "kotlin.formatter"})
    private static interface Builder {
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock var1, @NotNull ASTBlock var2, @NotNull ASTBlock var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BM\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003JQ\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J&\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010%J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "Lkotlin/Function3;", "Lcom/intellij/formatting/ASTBlock;", "", "parent", "Lcom/intellij/psi/tree/IElementType;", "left", "right", "parentSet", "Lcom/intellij/psi/tree/TokenSet;", "leftSet", "rightSet", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/TokenSet;Lcom/intellij/psi/tree/TokenSet;Lcom/intellij/psi/tree/TokenSet;)V", "getLeft", "()Lcom/intellij/psi/tree/IElementType;", "getLeftSet", "()Lcom/intellij/psi/tree/TokenSet;", "getParent", "getParentSet", "getRight", "getRightSet", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "invoke", "p", "l", "r", "(Lcom/intellij/formatting/ASTBlock;Lcom/intellij/formatting/ASTBlock;Lcom/intellij/formatting/ASTBlock;)Ljava/lang/Boolean;", "toString", "", "kotlin.formatter"})
    private static final class Condition
    implements Function3<ASTBlock, ASTBlock, ASTBlock, Boolean> {
        @Nullable
        private final IElementType parent;
        @Nullable
        private final IElementType left;
        @Nullable
        private final IElementType right;
        @Nullable
        private final TokenSet parentSet;
        @Nullable
        private final TokenSet leftSet;
        @Nullable
        private final TokenSet rightSet;

        public Condition(@Nullable IElementType parent2, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            this.parent = parent2;
            this.left = left;
            this.right = right;
            this.parentSet = parentSet;
            this.leftSet = leftSet;
            this.rightSet = rightSet;
        }

        public /* synthetic */ Condition(IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                iElementType = null;
            }
            if ((n & 2) != 0) {
                iElementType2 = null;
            }
            if ((n & 4) != 0) {
                iElementType3 = null;
            }
            if ((n & 8) != 0) {
                tokenSet = null;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = null;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = null;
            }
            this(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        @Nullable
        public final IElementType getParent() {
            return this.parent;
        }

        @Nullable
        public final IElementType getLeft() {
            return this.left;
        }

        @Nullable
        public final IElementType getRight() {
            return this.right;
        }

        @Nullable
        public final TokenSet getParentSet() {
            return this.parentSet;
        }

        @Nullable
        public final TokenSet getLeftSet() {
            return this.leftSet;
        }

        @Nullable
        public final TokenSet getRightSet() {
            return this.rightSet;
        }

        @NotNull
        public Boolean invoke(@NotNull ASTBlock p, @NotNull ASTBlock l, @NotNull ASTBlock r) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return !(this.parent != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(p).getElementType(), (Object)this.parent) || this.left != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(l).getElementType(), (Object)this.left) || this.right != null && !Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(r).getElementType(), (Object)this.right) || this.parentSet != null && !this.parentSet.contains(FormatterUtilKt.requireNode(p).getElementType()) || this.leftSet != null && !this.leftSet.contains(FormatterUtilKt.requireNode(l).getElementType()) || this.rightSet != null && !this.rightSet.contains(FormatterUtilKt.requireNode(r).getElementType()));
        }

        @Nullable
        public final IElementType component1() {
            return this.parent;
        }

        @Nullable
        public final IElementType component2() {
            return this.left;
        }

        @Nullable
        public final IElementType component3() {
            return this.right;
        }

        @Nullable
        public final TokenSet component4() {
            return this.parentSet;
        }

        @Nullable
        public final TokenSet component5() {
            return this.leftSet;
        }

        @Nullable
        public final TokenSet component6() {
            return this.rightSet;
        }

        @NotNull
        public final Condition copy(@Nullable IElementType parent2, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            return new Condition(parent2, left, right, parentSet, leftSet, rightSet);
        }

        public static /* synthetic */ Condition copy$default(Condition condition2, IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = condition2.parent;
            }
            if ((n & 2) != 0) {
                iElementType2 = condition2.left;
            }
            if ((n & 4) != 0) {
                iElementType3 = condition2.right;
            }
            if ((n & 8) != 0) {
                tokenSet = condition2.parentSet;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = condition2.leftSet;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = condition2.rightSet;
            }
            return condition2.copy(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        @NotNull
        public String toString() {
            return "Condition(parent=" + this.parent + ", left=" + this.left + ", right=" + this.right + ", parentSet=" + this.parentSet + ", leftSet=" + this.leftSet + ", rightSet=" + this.rightSet + ")";
        }

        public int hashCode() {
            int result2 = this.parent == null ? 0 : this.parent.hashCode();
            result2 = result2 * 31 + (this.left == null ? 0 : this.left.hashCode());
            result2 = result2 * 31 + (this.right == null ? 0 : this.right.hashCode());
            result2 = result2 * 31 + (this.parentSet == null ? 0 : this.parentSet.hashCode());
            result2 = result2 * 31 + (this.leftSet == null ? 0 : this.leftSet.hashCode());
            result2 = result2 * 31 + (this.rightSet == null ? 0 : this.rightSet.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Condition)) {
                return false;
            }
            Condition condition2 = (Condition)other2;
            if (!Intrinsics.areEqual((Object)this.parent, (Object)condition2.parent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.left, (Object)condition2.left)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.right, (Object)condition2.right)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentSet, (Object)condition2.parentSet)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.leftSet, (Object)condition2.leftSet)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rightSet, (Object)condition2.rightSet);
        }

        public Condition() {
            this(null, null, null, null, null, null, 63, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JU\u0010\t\u001a\u00020\n2M\u0010\u000b\u001aI\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\fJ\"\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0016J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016JR\u0010\u001a\u001a\u00060\u0000R\u00020\u001b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001eJ\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\"\u001a\u00020#J*\u0010$\u001a\u00020\n2 \u0010%\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00130\fH\u0002J\u000e\u0010&\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0013R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u00020\b`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$CustomSpacingBuilder;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Builder;", "(Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;)V", "conditions", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "Lkotlin/collections/ArrayList;", "rules", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule;", "customRule", "", "block", "Lkotlin/Function3;", "Lcom/intellij/formatting/ASTBlock;", "Lkotlin/ParameterName;", "name", "parent", "left", "right", "Lcom/intellij/formatting/Spacing;", "emptyLinesIfLineBreakInLeft", "emptyLines", "", "numberOfLineFeedsOtherwise", "numSpacesOtherwise", "getSpacing", "inPosition", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "Lcom/intellij/psi/tree/IElementType;", "parentSet", "Lcom/intellij/psi/tree/TokenSet;", "leftSet", "rightSet", "lineBreakIfLineBreakInParent", "allowBlankLines", "", "newRule", "rule", "spacing", "kotlin.formatter"})
    public final class CustomSpacingBuilder
    implements Builder {
        @NotNull
        private final ArrayList<Rule> rules = new ArrayList();
        @NotNull
        private ArrayList<Condition> conditions = new ArrayList();

        @Override
        @Nullable
        public Spacing getSpacing(@NotNull ASTBlock parent2, @NotNull ASTBlock left, @NotNull ASTBlock right) {
            Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            for (Rule rule : this.rules) {
                Spacing spacing2 = rule.invoke(parent2, left, right);
                if (spacing2 == null) continue;
                return spacing2;
            }
            return null;
        }

        @NotNull
        public final CustomSpacingBuilder inPosition(@Nullable IElementType parent2, @Nullable IElementType left, @Nullable IElementType right, @Nullable TokenSet parentSet, @Nullable TokenSet leftSet, @Nullable TokenSet rightSet) {
            this.conditions.add(new Condition(parent2, left, right, parentSet, leftSet, rightSet));
            return this;
        }

        public static /* synthetic */ CustomSpacingBuilder inPosition$default(CustomSpacingBuilder customSpacingBuilder, IElementType iElementType, IElementType iElementType2, IElementType iElementType3, TokenSet tokenSet, TokenSet tokenSet2, TokenSet tokenSet3, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = null;
            }
            if ((n & 2) != 0) {
                iElementType2 = null;
            }
            if ((n & 4) != 0) {
                iElementType3 = null;
            }
            if ((n & 8) != 0) {
                tokenSet = null;
            }
            if ((n & 0x10) != 0) {
                tokenSet2 = null;
            }
            if ((n & 0x20) != 0) {
                tokenSet3 = null;
            }
            return customSpacingBuilder.inPosition(iElementType, iElementType2, iElementType3, tokenSet, tokenSet2, tokenSet3);
        }

        public final void lineBreakIfLineBreakInParent(int numSpacesOtherwise, boolean allowBlankLines) {
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(numSpacesOtherwise, KotlinSpacingBuilder.this, allowBlankLines){
                final /* synthetic */ int $numSpacesOtherwise;
                final /* synthetic */ KotlinSpacingBuilder this$0;
                final /* synthetic */ boolean $allowBlankLines;
                {
                    this.$numSpacesOtherwise = $numSpacesOtherwise;
                    this.this$0 = $receiver;
                    this.$allowBlankLines = $allowBlankLines;
                    super(3);
                }

                @Nullable
                public final Spacing invoke(@NotNull ASTBlock p, @NotNull ASTBlock aSTBlock, @NotNull ASTBlock aSTBlock2) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<anonymous parameter 1>");
                    Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<anonymous parameter 2>");
                    return Spacing.createDependentLFSpacing((int)this.$numSpacesOtherwise, (int)this.$numSpacesOtherwise, (TextRange)p.getTextRange(), (boolean)this.this$0.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)(this.$allowBlankLines ? this.this$0.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE : 0));
                }
            }));
        }

        public static /* synthetic */ void lineBreakIfLineBreakInParent$default(CustomSpacingBuilder customSpacingBuilder, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            customSpacingBuilder.lineBreakIfLineBreakInParent(n, bl);
        }

        public final void emptyLinesIfLineBreakInLeft(int emptyLines, int numberOfLineFeedsOtherwise, int numSpacesOtherwise) {
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(emptyLines, KotlinSpacingBuilder.this, numSpacesOtherwise, numberOfLineFeedsOtherwise){
                final /* synthetic */ int $emptyLines;
                final /* synthetic */ KotlinSpacingBuilder this$0;
                final /* synthetic */ int $numSpacesOtherwise;
                final /* synthetic */ int $numberOfLineFeedsOtherwise;
                {
                    this.$emptyLines = $emptyLines;
                    this.this$0 = $receiver;
                    this.$numSpacesOtherwise = $numSpacesOtherwise;
                    this.$numberOfLineFeedsOtherwise = $numberOfLineFeedsOtherwise;
                    super(3);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Spacing invoke(@NotNull ASTBlock var1_1, @NotNull ASTBlock left, @NotNull ASTBlock var3_3) {
                    Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                    Intrinsics.checkNotNullParameter((Object)var3_3, (String)"<anonymous parameter 2>");
                    v0 = left.getNode();
                    lastChild = v0 != null && (v0 = v0.getPsi()) != null ? v0.getLastChild() : null;
                    leftEndsWithComment = lastChild instanceof PsiComment != false && Intrinsics.areEqual((Object)((PsiComment)lastChild).getTokenType(), (Object)KtTokens.EOL_COMMENT) != false;
                    dependentSpacingRule = new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, this.$emptyLines + 1);
                    var9_7 = left.getNode();
                    if (var9_7 == null || (var10_8 = KotlinSpacingBuilderKt.startOfDeclaration(var9_7)) == null) ** GOTO lbl-1000
                    it = var10_8.getStartOffset();
                    $i$a$-let-KotlinSpacingBuilder$CustomSpacingBuilder$emptyLinesIfLineBreakInLeft$1$textRange$1 = false;
                    var11_11 = TextRange.create((int)it, (int)left.getTextRange().getEndOffset());
                    if (var11_11 != null) {
                        v1 = var11_11;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = left.getTextRange();
                    }
                    var8_12 = v1;
                    Intrinsics.checkNotNull((Object)var8_12);
                    textRange = var8_12;
                    v2 = this.this$0.getSpacingBuilderUtil();
                    v3 = leftEndsWithComment != false ? Math.max(1, this.$numberOfLineFeedsOtherwise) : this.$numberOfLineFeedsOtherwise;
                    v4 = this.this$0.getCommonCodeStyleSettings().KEEP_LINE_BREAKS;
                    v5 = this.this$0.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_DECLARATIONS;
                    Intrinsics.checkNotNull((Object)dependentSpacingRule);
                    return v2.createLineFeedDependentSpacing(this.$numSpacesOtherwise, this.$numSpacesOtherwise, v3, v4, v5, textRange, dependentSpacingRule);
                }
            }));
        }

        public static /* synthetic */ void emptyLinesIfLineBreakInLeft$default(CustomSpacingBuilder customSpacingBuilder, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n2 = 1;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            customSpacingBuilder.emptyLinesIfLineBreakInLeft(n, n2, n3);
        }

        public final void spacing(@NotNull Spacing spacing2) {
            Intrinsics.checkNotNullParameter((Object)spacing2, (String)"spacing");
            this.newRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(spacing2){
                final /* synthetic */ Spacing $spacing;
                {
                    this.$spacing = $spacing;
                    super(3);
                }

                @Nullable
                public final Spacing invoke(@NotNull ASTBlock aSTBlock, @NotNull ASTBlock aSTBlock2, @NotNull ASTBlock aSTBlock3) {
                    Intrinsics.checkNotNullParameter((Object)aSTBlock, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)aSTBlock2, (String)"<anonymous parameter 1>");
                    Intrinsics.checkNotNullParameter((Object)aSTBlock3, (String)"<anonymous parameter 2>");
                    return this.$spacing;
                }
            }));
        }

        public final void customRule(@NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> block2) {
            Intrinsics.checkNotNullParameter(block2, (String)"block");
            this.newRule(block2);
        }

        private final void newRule(Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> rule) {
            ArrayList savedConditions = new ArrayList(this.conditions);
            this.rules.add(new Rule(savedConditions, rule));
            this.conditions.clear();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001H\u00c6\u0003J=\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\"\b\u0002\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J#\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R+\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule;", "Lkotlin/Function3;", "Lcom/intellij/formatting/ASTBlock;", "Lcom/intellij/formatting/Spacing;", "conditions", "", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Condition;", "action", "(Ljava/util/List;Lkotlin/jvm/functions/Function3;)V", "getAction", "()Lkotlin/jvm/functions/Function3;", "getConditions", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "p", "l", "r", "toString", "", "kotlin.formatter"})
    @SourceDebugExtension(value={"SMAP\nKotlinSpacingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSpacingBuilder.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1726#2,3:214\n*S KotlinDebug\n*F\n+ 1 KotlinSpacingBuilder.kt\norg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder$Rule\n*L\n64#1:214,3\n*E\n"})
    private static final class Rule
    implements Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> {
        @NotNull
        private final List<Condition> conditions;
        @NotNull
        private final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> action;

        public Rule(@NotNull List<Condition> conditions, @NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> action2) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.conditions = conditions;
            this.action = action2;
        }

        @NotNull
        public final List<Condition> getConditions() {
            return this.conditions;
        }

        @NotNull
        public final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> getAction() {
            return this.action;
        }

        @Nullable
        public Spacing invoke(@NotNull ASTBlock p, @NotNull ASTBlock l, @NotNull ASTBlock r) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Iterable $this$all$iv = this.conditions;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Condition it = (Condition)element$iv;
                        boolean bl2 = false;
                        if (it.invoke(p, l, r).booleanValue()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl ? (Spacing)this.action.invoke((Object)p, (Object)l, (Object)r) : null;
        }

        @NotNull
        public final List<Condition> component1() {
            return this.conditions;
        }

        @NotNull
        public final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> component2() {
            return this.action;
        }

        @NotNull
        public final Rule copy(@NotNull List<Condition> conditions, @NotNull Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing> action2) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return new Rule(conditions, action2);
        }

        public static /* synthetic */ Rule copy$default(Rule rule, List list2, Function3 function3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = rule.conditions;
            }
            if ((n & 2) != 0) {
                function3 = rule.action;
            }
            return rule.copy(list2, function3);
        }

        @NotNull
        public String toString() {
            return "Rule(conditions=" + this.conditions + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.conditions).hashCode();
            result2 = result2 * 31 + this.action.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Rule)) {
                return false;
            }
            Rule rule = (Rule)other2;
            if (!Intrinsics.areEqual(this.conditions, rule.conditions)) {
                return false;
            }
            return Intrinsics.areEqual(this.action, rule.action);
        }
    }
}

