/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.SlowFacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;", "Lcom/intellij/facet/ui/libraries/FrameworkLibraryValidator;", "Lcom/intellij/facet/ui/SlowFacetEditorValidator;", "context", "Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;", "validatorsManager", "Lcom/intellij/facet/ui/FacetValidatorsManager;", "libraryCategoryName", "", "getPlatform", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "(Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;Lcom/intellij/facet/ui/FacetValidatorsManager;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "libraryDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryDescription", "(Lorg/jetbrains/kotlin/platform/IdePlatformKind;)Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "check", "Lcom/intellij/facet/ui/ValidationResult;", "checkLibraryIsConfigured", "", "platform", "LibrariesQuickFix", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nFrameworkLibraryValidatorWithDynamicDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkLibraryValidatorWithDynamicDescription.kt\norg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1747#2,3:104\n766#2:107\n857#2,2:108\n1620#2,3:110\n*S KotlinDebug\n*F\n+ 1 FrameworkLibraryValidatorWithDynamicDescription.kt\norg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription\n*L\n37#1:104,3\n65#1:107\n65#1:108,2\n71#1:110,3\n*E\n"})
public final class FrameworkLibraryValidatorWithDynamicDescription
extends FrameworkLibraryValidator
implements SlowFacetEditorValidator {
    @NotNull
    private final LibrariesValidatorContext context;
    @NotNull
    private final FacetValidatorsManager validatorsManager;
    @NotNull
    private final String libraryCategoryName;
    @NotNull
    private final Function0<TargetPlatform> getPlatform;

    public FrameworkLibraryValidatorWithDynamicDescription(@NotNull LibrariesValidatorContext context2, @NotNull FacetValidatorsManager validatorsManager, @NotNull String libraryCategoryName, @NotNull Function0<? extends TargetPlatform> getPlatform) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)validatorsManager, (String)"validatorsManager");
        Intrinsics.checkNotNullParameter((Object)libraryCategoryName, (String)"libraryCategoryName");
        Intrinsics.checkNotNullParameter(getPlatform, (String)"getPlatform");
        this.context = context2;
        this.validatorsManager = validatorsManager;
        this.libraryCategoryName = libraryCategoryName;
        this.getPlatform = getPlatform;
    }

    private final CustomLibraryDescription getLibraryDescription(IdePlatformKind $this$libraryDescription) {
        Project project2 = this.context.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return KotlinProjectConfigurationUtils.getLibraryDescription(project2, $this$libraryDescription);
    }

    private final boolean checkLibraryIsConfigured(IdePlatformKind platform2) {
        boolean bl;
        block6: {
            if (CommonIdePlatformUtil.isCommon((IdePlatformKind)platform2)) {
                return true;
            }
            Iterable $this$any$iv = KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinVersionInfoProvider it = (KotlinVersionInfoProvider)element$iv;
                    boolean bl2 = false;
                    Module module2 = this.context.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"getModule(...)");
                    if (!SequencesKt.any(it.getLibraryVersionsSequence(module2, platform2, this.context.getRootModel()))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        CustomLibraryDescription customLibraryDescription = this.getLibraryDescription(platform2);
        if (customLibraryDescription == null) {
            return true;
        }
        CustomLibraryDescription libraryDescription = customLibraryDescription;
        Set set2 = libraryDescription.getSuitableLibraryKinds();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getSuitableLibraryKinds(...)");
        Set libraryKinds = set2;
        Ref.BooleanRef found2 = new Ref.BooleanRef();
        LibraryPresentationManager presentationManager = LibraryPresentationManager.getInstance();
        this.context.getRootModel().orderEntries().using((RootModelProvider)this.context.getModulesProvider()).recursively().librariesOnly().forEachLibrary(arg_0 -> FrameworkLibraryValidatorWithDynamicDescription.checkLibraryIsConfigured$lambda$1((Function1)new Function1<Library, Boolean>(presentationManager, this, (Set<? extends LibraryKind>)libraryKinds, found2){
            final /* synthetic */ LibraryPresentationManager $presentationManager;
            final /* synthetic */ FrameworkLibraryValidatorWithDynamicDescription this$0;
            final /* synthetic */ Set<? extends LibraryKind> $libraryKinds;
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$presentationManager = $presentationManager;
                this.this$0 = $receiver;
                this.$libraryKinds = $libraryKinds;
                this.$found = $found;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library library2) {
                if (this.$presentationManager.isLibraryOfKind(library2, FrameworkLibraryValidatorWithDynamicDescription.access$getContext$p(this.this$0).getLibrariesContainer(), this.$libraryKinds)) {
                    this.$found.element = true;
                }
                return !this.$found.element;
            }
        }, arg_0));
        return found2.element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValidationResult check() {
        TargetPlatform targetPlatform = (TargetPlatform)this.getPlatform.invoke();
        if (targetPlatform == null) {
            return new ValidationResult(KotlinJvmBundle.message("no.target.platforms.selected", new Object[0]));
        }
        TargetPlatform targetPlatform2 = targetPlatform;
        if (this.checkLibraryIsConfigured(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform2))) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = IdePlatformKind.Companion.getALL_KINDS();
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IdePlatformKind it = (IdePlatformKind)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !CommonIdePlatformUtil.isCommon((IdePlatformKind)it) && !Intrinsics.areEqual((Object)it.getName(), (Object)IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform2).getName()) && this.getLibraryDescription(it) != null && this.checkLibraryIsConfigured(it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List conflictingPlatforms = (List)destination$iv$iv;
            if (!((Collection)conflictingPlatforms).isEmpty()) {
                void $this$mapTo$iv;
                Iterable $i$f$filter2 = conflictingPlatforms;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Object element$iv$iv;
                    element$iv$iv = (IdePlatformKind)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                String platformText = CollectionsKt.joinToString$default((Iterable)destination$iv, null, null, null, (int)0, null, null, (int)63, null);
                Object[] objectArray = new Object[]{platformText};
                return new ValidationResult(KotlinJvmBundle.message("libraries.for.the.following.platform.are.also.present.in.the.module.dependencies.0", objectArray));
            }
            ValidationResult validationResult2 = ValidationResult.OK;
            Intrinsics.checkNotNullExpressionValue((Object)validationResult2, (String)"OK");
            return validationResult2;
        }
        Object[] objectArray = new Object[]{this.libraryCategoryName};
        String string = KotlinJvmBundle.message("label.missed.libraries.text", objectArray);
        CustomLibraryDescription customLibraryDescription = this.getLibraryDescription(IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform2));
        Intrinsics.checkNotNull((Object)customLibraryDescription);
        return new ValidationResult(string, (FacetConfigurationQuickFix)new LibrariesQuickFix(customLibraryDescription));
    }

    private static final boolean checkLibraryIsConfigured$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription$LibrariesQuickFix;", "Lcom/intellij/facet/ui/FacetConfigurationQuickFix;", "myDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "(Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;)V", "run", "", "place", "Ljavax/swing/JComponent;", "kotlin.jvm"})
    private final class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        @NotNull
        private final CustomLibraryDescription myDescription;

        public LibrariesQuickFix(CustomLibraryDescription myDescription) {
            Intrinsics.checkNotNullParameter((Object)myDescription, (String)"myDescription");
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.myDescription = myDescription;
        }

        public void run(@NotNull JComponent place) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            AddCustomLibraryDialog dialog2 = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)this.myDescription, (LibrariesContainer)FrameworkLibraryValidatorWithDynamicDescription.this.context.getLibrariesContainer(), (Module)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModule(), (ModifiableRootModel)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModifiableRootModel(), null);
            dialog2.show();
            FrameworkLibraryValidatorWithDynamicDescription.this.validatorsManager.validate();
        }
    }
}

