/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.formatter.DocumentUtilsKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001eJ-\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b!J \u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandlerHelper;", "", "()V", "PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_idea", "()Lcom/intellij/openapi/util/Key;", "autoIndentCase", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "klass", "Ljava/lang/Class;", "forFirstElement", "autoIndentCase$kotlin_idea", "autoPopupAt", "", "autoPopupAt$kotlin_idea", "autoPopupCallableReferenceLookup", "autoPopupCallableReferenceLookup$kotlin_idea", "autoPopupMemberLookup", "autoPopupMemberLookup$kotlin_idea", "autoPopupParameterInfo", "autoPopupParameterInfo$kotlin_idea", "dataClassValParameterInsert", "beforeType", "dataClassValParameterInsert$kotlin_idea", "endsWith", "chars", "", "offset", "text", "", "isLabelCompletion", "kotlin.idea"})
public final class KotlinTypedHandlerHelper {
    @NotNull
    public static final KotlinTypedHandlerHelper INSTANCE = new KotlinTypedHandlerHelper();
    @NotNull
    private static final Key<Integer> PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY;

    private KotlinTypedHandlerHelper() {
    }

    @NotNull
    public final Key<Integer> getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_idea() {
        return PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY;
    }

    public final void autoPopupParameterInfo$kotlin_idea(@NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == 0) {
            return;
        }
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset2 - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator2 = highlighterIterator;
        IElementType tokenType = iterator2.getTokenType();
        if (KtTokens.COMMENTS.contains(tokenType) || tokenType == KtTokens.REGULAR_STRING_PART || tokenType == KtTokens.OPEN_QUOTE || tokenType == KtTokens.CHARACTER_LITERAL) {
            return;
        }
        AutoPopupController.getInstance((Project)project2).autoPopupParameterInfo(editor2, null);
    }

    public final void autoPopupMemberLookup$kotlin_idea(@NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, arg_0 -> KotlinTypedHandlerHelper.autoPopupMemberLookup$lambda$0((Function1)new Function1<PsiFile, Boolean>(editor2){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                int offset2 = this.$editor.getCaretModel().getOffset();
                PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement lastToken = psiElement2;
                IElementType iElementType = lastToken.getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                IElementType elementType = iElementType;
                if (elementType == KtTokens.DOT || elementType == KtTokens.SAFE_ACCESS) {
                    return true;
                }
                if (elementType == KtTokens.REGULAR_STRING_PART && lastToken.getTextRange().getStartOffset() == offset2 - 1) {
                    PsiElement prevSibling2 = lastToken.getParent().getPrevSibling();
                    return prevSibling2 instanceof KtSimpleNameStringTemplateEntry;
                }
                return false;
            }
        }, arg_0));
    }

    private final boolean isLabelCompletion(CharSequence chars, int offset2) {
        return this.endsWith(chars, offset2, "this@") || this.endsWith(chars, offset2, "return@") || this.endsWith(chars, offset2, "break@") || this.endsWith(chars, offset2, "continue@");
    }

    public final void autoPopupAt$kotlin_idea(@NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, arg_0 -> KotlinTypedHandlerHelper.autoPopupAt$lambda$1((Function1)new Function1<PsiFile, Boolean>(editor2){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                int offset2 = this.$editor.getCaretModel().getOffset();
                CharSequence charSequence = this.$editor.getDocument().getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
                CharSequence chars = charSequence;
                PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                if (psiElement2 == null || (psiElement2 = psiElement2.getNode()) == null || (psiElement2 = psiElement2.getElementType()) == null) {
                    return false;
                }
                PsiElement lastNodeType = psiElement2;
                return lastNodeType == KDocTokens.TEXT || lastNodeType == KtTokens.AT && KotlinTypedHandlerHelper.access$isLabelCompletion(KotlinTypedHandlerHelper.INSTANCE, chars, offset2);
            }
        }, arg_0));
    }

    public final void autoPopupCallableReferenceLookup$kotlin_idea(@NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, arg_0 -> KotlinTypedHandlerHelper.autoPopupCallableReferenceLookup$lambda$2((Function1)new Function1<PsiFile, Boolean>(editor2){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                int offset2 = this.$editor.getCaretModel().getOffset();
                PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement lastElement = psiElement2;
                return lastElement.getNode().getElementType() == KtTokens.COLONCOLON;
            }
        }, arg_0));
    }

    private final boolean endsWith(CharSequence chars, int offset2, String text2) {
        return offset2 < text2.length() ? false : Intrinsics.areEqual((Object)((Object)chars.subSequence(offset2 - text2.length(), offset2)).toString(), (Object)text2);
    }

    public final void dataClassValParameterInsert$kotlin_idea(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, boolean beforeType) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!KotlinEditorOptions.getInstance().isAutoAddValKeywordToDataClassParameters()) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        int commaOffset = editor2.getCaretModel().getOffset();
        if (!beforeType) {
            --commaOffset;
        }
        if (commaOffset < 1) {
            return;
        }
        PsiElement psiElement2 = file2.findElementAt(commaOffset);
        if (psiElement2 == null) {
            return;
        }
        PsiElement elementOnCaret = psiElement2;
        boolean contextMatched = false;
        PsiElement parentElement = elementOnCaret.getParent();
        if (parentElement instanceof KtParameterList && (parentElement = parentElement.getParent()) instanceof KtPrimaryConstructor && (parentElement = parentElement.getParent()) instanceof KtClass) {
            PsiElement klassElement = parentElement;
            contextMatched = KotlinPsiUtils.mustHaveNonEmptyPrimaryConstructor((KtClass)klassElement);
        }
        if (!contextMatched) {
            return;
        }
        PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementOnCaret);
        KtParameter ktParameter = psiElement3 instanceof KtParameter ? (KtParameter)psiElement3 : null;
        if (ktParameter == null) {
            return;
        }
        KtParameter leftElement = ktParameter;
        KtTypeReference ktTypeReference = leftElement.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        if (leftElement.hasValOrVar()) {
            return;
        }
        if (typeReference2.getTextLength() == 0) {
            return;
        }
        document2.insertString(leftElement.getTextOffset(), (CharSequence)"val ");
    }

    public final boolean autoIndentCase$kotlin_idea(@NotNull Editor editor2, @NotNull Project project2, @NotNull PsiFile file2, @NotNull Class<?> klass2, boolean forFirstElement) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(klass2, (String)"klass");
        int offset2 = editor2.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
        PsiElement currElement = file2.findElementAt(offset2 - 1);
        if (currElement != null) {
            PsiElement prevLeaf2 = PsiTreeUtil.prevLeaf((PsiElement)currElement);
            if (!(!forFirstElement || prevLeaf2 instanceof PsiWhiteSpace && ((PsiWhiteSpace)prevLeaf2).textContains('\n'))) {
                return false;
            }
            PsiElement parent2 = currElement.getParent();
            if (klass2.isInstance(parent2)) {
                int curElementLength = currElement.getText().length();
                if (offset2 < curElementLength) {
                    return false;
                }
                if (forFirstElement) {
                    CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, offset2 - curElementLength);
                } else {
                    Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
                    if (document != null) {
                        DocumentUtilsKt.adjustLineIndent(document, project2, offset2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean autoIndentCase$kotlin_idea$default(KotlinTypedHandlerHelper kotlinTypedHandlerHelper, Editor editor2, Project project2, PsiFile psiFile2, Class clazz, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return kotlinTypedHandlerHelper.autoIndentCase$kotlin_idea(editor2, project2, psiFile2, clazz, bl);
    }

    private static final boolean autoPopupMemberLookup$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean autoPopupAt$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean autoPopupCallableReferenceLookup$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isLabelCompletion(KotlinTypedHandlerHelper $this, CharSequence chars, int offset2) {
        return $this.isLabelCompletion(chars, offset2);
    }

    static {
        Key key = Key.create((String)"PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY = key;
    }
}

