/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.BatchTemplateRunner;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0006\u0010\u0014\u001a\u00020\rJ.\u0010\u0014\u001a\u00020\r2$\u0010\u0015\u001a \u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u00070\u0016H\u0002RN\u0010\u0005\u001aB\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u00070\u0006j \u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/editor/BatchTemplateRunner;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "elementsAndFactories", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lkotlin/Function0;", "Lcom/intellij/codeInsight/template/Template;", "Lkotlin/collections/ArrayList;", "addTemplateFactory", "", "element", "Lcom/intellij/psi/PsiElement;", "factory", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "pointer", "runTemplates", "iterator", "", "kotlin.idea"})
public final class BatchTemplateRunner {
    @NotNull
    private final Project project;
    @NotNull
    private final ArrayList<Pair<SmartPsiElementPointer<?>, Function0<Template>>> elementsAndFactories;

    public BatchTemplateRunner(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.elementsAndFactories = new ArrayList();
    }

    public final void addTemplateFactory(@NotNull PsiElement element3, @NotNull Function0<? extends Template> factory2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        this.elementsAndFactories.add(TuplesKt.to((Object)PsiUtilsKt.createSmartPointer((PsiElement)element3), factory2));
    }

    public final void runTemplates() {
        Iterator<Pair<SmartPsiElementPointer<?>, Function0<Template>>> iterator2 = this.elementsAndFactories.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        this.runTemplates(iterator2);
    }

    private final Editor getEditor(SmartPsiElementPointer<?> pointer) {
        PsiElement psiElement2 = pointer.getElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element3 = psiElement2;
        PsiFile psiFile2 = element3.getContainingFile();
        Object object = psiFile2 != null ? psiFile2.getVirtualFile() : null;
        if (object == null) {
            return null;
        }
        VirtualFile virtualFile2 = object;
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.project, virtualFile2, element3.getTextRange().getStartOffset());
        return FileEditorManager.getInstance((Project)this.project).openTextEditor(descriptor2, true);
    }

    private final void runTemplates(Iterator<? extends Pair<? extends SmartPsiElementPointer<?>, ? extends Function0<? extends Template>>> iterator2) {
        if (!iterator2.hasNext()) {
            return;
        }
        TemplateManager manager = TemplateManager.getInstance((Project)this.project);
        ApplicationUtilsKt.executeWriteCommand(this.project, "", (Function0<Unit>)((Function0)new Function0<Unit>(iterator2, this, manager){
            final /* synthetic */ Iterator<Pair<SmartPsiElementPointer<?>, Function0<Template>>> $iterator;
            final /* synthetic */ BatchTemplateRunner this$0;
            final /* synthetic */ TemplateManager $manager;
            {
                this.$iterator = $iterator;
                this.this$0 = $receiver;
                this.$manager = $manager;
                super(0);
            }

            public final void invoke() {
                Pair<SmartPsiElementPointer<?>, Function0<Template>> pair = this.$iterator.next();
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)pair.component1();
                Function0 factory2 = (Function0)pair.component2();
                Editor editor2 = BatchTemplateRunner.access$getEditor(this.this$0, pointer);
                if (editor2 == null) {
                    return;
                }
                Editor editor3 = editor2;
                PsiDocumentManager.getInstance((Project)BatchTemplateRunner.access$getProject$p(this.this$0)).doPostponedOperationsAndUnblockDocument(editor3.getDocument());
                Template template2 = (Template)factory2.invoke();
                if (template2 == null) {
                    return;
                }
                Template template3 = template2;
                this.$manager.startTemplate(editor3, template3, (TemplateEditingListener)new TemplateEditingAdapter(this.this$0, this.$iterator){
                    final /* synthetic */ BatchTemplateRunner this$0;
                    final /* synthetic */ Iterator<Pair<SmartPsiElementPointer<?>, Function0<Template>>> $iterator;
                    {
                        this.this$0 = $receiver;
                        this.$iterator = $iterator;
                    }

                    public void templateFinished(@NotNull Template template2, boolean brokenOff) {
                        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                        if (brokenOff) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(() -> runTemplates.1.templateFinished$lambda$0(this.this$0, this.$iterator));
                    }

                    private static final void templateFinished$lambda$0(BatchTemplateRunner this$0, Iterator $iterator) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$iterator, (String)"$iterator");
                        BatchTemplateRunner.access$runTemplates(this$0, $iterator);
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ Editor access$getEditor(BatchTemplateRunner $this, SmartPsiElementPointer pointer) {
        return $this.getEditor(pointer);
    }

    public static final /* synthetic */ Project access$getProject$p(BatchTemplateRunner $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$runTemplates(BatchTemplateRunner $this, Iterator iterator2) {
        $this.runTemplates(iterator2);
    }
}

