/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ,\u0010\u001c\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J,\u0010\u001e\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer;", "", "targets", "", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Ljava/util/List;Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "functionCounter", "", "", "", "targetWasVisited", "", "getUnvisitedTargets", "primaryConstructorMatches", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "owner", "name", "signature", "reset", "", "visitInlineFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitOrdinaryFunction", "matches", "currentCount", "shouldBeVisited", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartStepTargetFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n350#2,7:111\n777#2:118\n788#2:119\n1864#2,2:120\n789#2,2:122\n1866#2:124\n791#2:125\n*S KotlinDebug\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFilterer\n*L\n24#1:111,7\n76#1:118\n76#1:119\n76#1:120,2\n76#1:122,2\n76#1:124\n76#1:125\n*E\n"})
public final class KotlinSmartStepTargetFilterer {
    @NotNull
    private final List<KotlinMethodSmartStepTarget> targets;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final Map<String, Integer> functionCounter;
    @NotNull
    private final boolean[] targetWasVisited;

    public KotlinSmartStepTargetFilterer(@NotNull List<KotlinMethodSmartStepTarget> targets, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.targets = targets;
        this.debugProcess = debugProcess;
        this.functionCounter = new LinkedHashMap();
        int n = 0;
        int n2 = this.targets.size();
        boolean[] blArray = new boolean[n2];
        KotlinSmartStepTargetFilterer kotlinSmartStepTargetFilterer = this;
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        kotlinSmartStepTargetFilterer.targetWasVisited = blArray;
    }

    public final void visitInlineFunction(@NotNull KtNamedFunction function2) {
        int matchedSteppingTargetIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)function2);
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            String label2 = KotlinMethodSmartStepTarget.Companion.calcLabel(descriptor2);
            int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, label2) - 1;
            List<KotlinMethodSmartStepTarget> $this$indexOfFirst$iv = this.targets;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<KotlinMethodSmartStepTarget> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinMethodSmartStepTarget item$iv;
                KotlinMethodSmartStepTarget it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getDeclaration() == function2 && it.getOrdinal() == currentCount) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = matchedSteppingTargetIndex = -1;
        }
        if (matchedSteppingTargetIndex < 0) {
            return;
        }
        this.targetWasVisited[matchedSteppingTargetIndex] = true;
    }

    public final void visitOrdinaryFunction(@NotNull String owner, @NotNull String name2, @NotNull String signature2) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        int currentCount = KotlinSmartStepTargetFiltererKt.access$increment(this.functionCounter, owner + "." + name2 + signature2) - 1;
        Iterator<KotlinMethodSmartStepTarget> iterator2 = this.targets.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            KotlinMethodSmartStepTarget target2 = iterator2.next();
            if (!this.shouldBeVisited(target2, owner, name2, signature2, currentCount)) continue;
            this.targetWasVisited[i2] = true;
            break;
        }
    }

    private final boolean shouldBeVisited(KotlinMethodSmartStepTarget $this$shouldBeVisited, String owner, String name2, String signature2, int currentCount) {
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, $this$shouldBeVisited.getMethodInfo().isNameMangledInBytecode());
        if ($this$shouldBeVisited.getMethodInfo().isInlineClassMember()) {
            return this.matches($this$shouldBeVisited, owner, actualName, KotlinSmartStepTargetFiltererKt.access$getSignatureWithoutFirstArgument(signature2), currentCount);
        }
        return this.matches($this$shouldBeVisited, owner, actualName, signature2, currentCount);
    }

    private final boolean matches(KotlinMethodSmartStepTarget $this$matches, String owner, String name2, String signature2, int currentCount) {
        if (Intrinsics.areEqual((Object)$this$matches.getMethodInfo().getName(), (Object)name2) && $this$matches.getOrdinal() == currentCount) {
            KtDeclaration ktDeclaration2 = $this$matches.getDeclaration();
            if (ktDeclaration2 == null) {
                return false;
            }
            KtDeclaration declaration2 = ktDeclaration2;
            if (declaration2 instanceof KtClass) {
                return this.primaryConstructorMatches((KtClass)declaration2, owner, name2, signature2);
            }
            PsiMethod psiMethod = KotlinSmartStepTargetFiltererKt.access$getLightClassMethod(declaration2);
            if (psiMethod == null) {
                return false;
            }
            PsiMethod lightClassMethod = psiMethod;
            return KotlinSmartStepTargetFiltererKt.access$matches(lightClassMethod, owner, name2, signature2, this.debugProcess);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean primaryConstructorMatches(KtClass declaration2, String owner, String name2, String signature2) {
        if (!Intrinsics.areEqual((Object)name2, (Object)"<init>")) return false;
        if (!Intrinsics.areEqual((Object)signature2, (Object)"()V")) return false;
        FqName fqName2 = declaration2.getFqName();
        if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), (Object)(fqName2 != null ? fqName2.asString() : null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinMethodSmartStepTarget> getUnvisitedTargets() {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = this.targets;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            KotlinMethodSmartStepTarget cfr_ignored_0 = (KotlinMethodSmartStepTarget)element$iv$iv;
            int i2 = index$iv$iv;
            boolean bl2 = false;
            if (!(!this.targetWasVisited[i2])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void reset() {
        Arrays.fill(this.targetWasVisited, false);
        this.functionCounter.clear();
    }
}

