/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/resolve/FilteredMapResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "resolve", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "kotlin.jvm-debugger.sequence"})
public final class FilteredMapResolver
implements ValuesOrderResolver {
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Map map2 = info2.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getValuesOrderBefore(...)");
        Map before2 = map2;
        Map map3 = info2.getValuesOrderAfter();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getValuesOrderAfter(...)");
        Map after = map3;
        Map invertedOrder = new LinkedHashMap();
        int[] beforeTimes = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)before2.keySet()));
        int[] afterTimes = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)after.keySet()));
        int beforeIndex = 0;
        for (int afterTime : afterTimes) {
            while (beforeIndex < beforeTimes.length && afterTime > beforeTimes[beforeIndex]) {
                ++beforeIndex;
            }
            int beforeTime = beforeTimes[beforeIndex - 1];
            if (beforeTime >= afterTime) continue;
            Integer n = afterTime;
            Integer n2 = beforeTime;
            invertedOrder.put(n, n2);
        }
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        for (Map.Entry entry : invertedOrder.entrySet()) {
            int afterTime = ((Number)entry.getKey()).intValue();
            int beforeTime = ((Number)entry.getValue()).intValue();
            TraceElement beforeElement = (TraceElement)MapsKt.getValue((Map)before2, (Object)beforeTime);
            TraceElement afterElement = (TraceElement)MapsKt.getValue((Map)after, (Object)afterTime);
            Intrinsics.checkNotNull((Object)beforeElement);
            direct.put(beforeElement, CollectionsKt.listOf((Object)afterElement));
            Intrinsics.checkNotNull((Object)afterElement);
            reverse.put(afterElement, CollectionsKt.listOf((Object)beforeElement));
        }
        ValuesOrderResolver.Result result2 = ValuesOrderResolver.Result.of((Map)direct, (Map)reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"of(...)");
        return result2;
    }
}

