/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.FragmentProjectFileDependencyCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenExceptionKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.FragmentCompilerCodegen;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRFragmentCompilerCodegen;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OldCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\nH\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "compilerBackend", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/FragmentCompilerCodegen;", "getCompilerBackend", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/FragmentCompilerCodegen;", "beforeAnalyzingCodeFragment", "", "beforeRunningFallback", "getFallbackStrategy", "getFilesToCompile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isFallbackDisabled", "", "onSuccess", "processError", "e", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCompilingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,157:1\n85#2:158\n77#2:159\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n*L\n133#1:158\n140#1:159\n*E\n"})
public final class IRCodeFragmentCompilingStrategy
extends CodeFragmentCompilingStrategy {
    @NotNull
    private final FragmentCompilerCodegen compilerBackend;

    public IRCodeFragmentCompilingStrategy(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        super(codeFragment);
        this.compilerBackend = new IRFragmentCompilerCodegen();
    }

    @Override
    @NotNull
    public FragmentCompilerCodegen getCompilerBackend() {
        return this.compilerBackend;
    }

    @Override
    @NotNull
    public List<KtFile> getFilesToCompile(@NotNull ResolutionFacade resolutionFacade2, @NotNull BindingContext bindingContext2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        List $this$getFilesToCompile_u24lambda_u240 = list2 = CollectionsKt.toMutableList((Collection)FragmentProjectFileDependencyCollectorKt.gatherProjectFilesDependedOnByFragment(this.getCodeFragment(), bindingContext2));
        boolean bl = false;
        IRCodeFragmentCompilingStrategy.getFilesToCompile$moveToLast($this$getFilesToCompile_u24lambda_u240, this.getCodeFragment());
        return list2;
    }

    @Override
    public void onSuccess() {
        KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation(this.getCodeFragment().getProject(), StatisticsEvaluator.IR, StatisticsEvaluationResult.SUCCESS, this.getStats$kotlin_jvm_debugger_evaluation());
    }

    @Override
    public void processError(@NotNull Throwable e, @NotNull KtCodeFragment codeFragment, @NotNull ExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation(codeFragment.getProject(), StatisticsEvaluator.IR, StatisticsEvaluationResult.FAILURE, this.getStats$kotlin_jvm_debugger_evaluation());
        if (this.isFallbackDisabled()) {
            throw e;
        }
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            CodeFragmentCodegenExceptionKt.reportErrorWithAttachments(executionContext2, codeFragment, e);
        }
    }

    @Override
    @Nullable
    public CodeFragmentCompilingStrategy getFallbackStrategy() {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return new OldCodeFragmentCompilingStrategy(this.getCodeFragment());
    }

    @Override
    public void beforeRunningFallback() {
        KotlinDebuggerEvaluatorStatisticsCollector.logFallbackToOldEvaluator(this.getCodeFragment().getProject());
    }

    private final boolean isFallbackDisabled() {
        return Registry.is((String)"debugger.kotlin.evaluator.disable.fallback.to.old.backend");
    }

    @Override
    public void beforeAnalyzingCodeFragment() {
        this.getCodeFragment().putCopyableUserData(CodeFragmentUtils.INSTANCE.getUSED_FOR_COMPILATION_IN_IR_EVALUATOR(), (Object)true);
    }

    private static final <T> void getFilesToCompile$moveToLast(List<T> $this$getFilesToCompile_u24moveToLast, T element3) {
        $this$getFilesToCompile_u24moveToLast.removeAll(CollectionsKt.listOf(element3));
        $this$getFilesToCompile_u24moveToLast.add(element3);
    }
}

