/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.BaseContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.BaseMirror;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.FieldVariable;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "debugMetadata", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugMetadata;", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "findStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider$CoroutineStackFrames;", "mirror", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfCoroutineInfo;", "getSpilledVariablesForNFrames", "", "Lcom/intellij/debugger/engine/JavaValue;", "lastObservedFrame", "Lcom/sun/jdi/ObjectReference;", "n", "", "toJavaValues", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/FieldVariable;", "continuation", "Companion", "CoroutineStackFrames", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackTraceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackTraceProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1549#2:75\n1620#2,3:76\n*S KotlinDebug\n*F\n+ 1 CoroutineStackTraceProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider\n*L\n70#1:75\n70#1:76,3\n*E\n"})
public final class CoroutineStackTraceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultExecutionContext executionContext;
    @NotNull
    private final LocationCache locationCache;
    @Nullable
    private final DebugMetadata debugMetadata;
    @NotNull
    private static final String[] METHOD_PREFIXES_TO_SKIP;

    public CoroutineStackTraceProvider(@NotNull DefaultExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        this.executionContext = executionContext2;
        this.locationCache = new LocationCache(this.executionContext);
        this.debugMetadata = DebugMetadata.Companion.instance(this.executionContext);
    }

    @Nullable
    public final CoroutineStackFrames findStackFrames(@NotNull MirrorOfCoroutineInfo mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        return (CoroutineStackFrames)DebuggerUtil.invokeInManagerThread(this.executionContext.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, CoroutineStackFrames>(mirror, this){
            final /* synthetic */ MirrorOfCoroutineInfo $mirror;
            final /* synthetic */ CoroutineStackTraceProvider this$0;
            {
                this.$mirror = $mirror;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CoroutineStackFrames invoke(@NotNull DebuggerContextImpl it) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                int n;
                void $this$mapIndexedTo$iv$iv2;
                void $this$mapIndexed$iv2;
                int n2;
                Object item$iv3;
                List frames;
                Collection collection;
                Object element$iv;
                int n3;
                block14: {
                    Collection destination$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    List<MirrorOfStackTraceElement> list2 = this.$mirror.getEnhancedStackTraceProvider().getStackTrace();
                    if (list2 != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object $this$any$iv;
                        void $this$dropWhile$iv;
                        Iterable iterable = list2;
                        boolean $i$f$dropWhile22 = false;
                        boolean yielding$iv = false;
                        ArrayList<T> list$iv = new ArrayList<T>();
                        for (T item$iv2 : $this$dropWhile$iv) {
                            boolean bl;
                            block13: {
                                if (yielding$iv) {
                                    list$iv.add(item$iv2);
                                    continue;
                                }
                                MirrorOfStackTraceElement frame = (MirrorOfStackTraceElement)item$iv2;
                                boolean bl2 = false;
                                $this$any$iv = CoroutineStackTraceProvider.Companion.getMETHOD_PREFIXES_TO_SKIP();
                                boolean $i$f$any = false;
                                n3 = ((String[])$this$any$iv).length;
                                for (int j = 0; j < n3; ++j) {
                                    element$iv = $this$any$iv[j];
                                    String it2 = element$iv;
                                    boolean bl3 = false;
                                    if (!StringsKt.contains$default((CharSequence)frame.getMethodName(), (CharSequence)it2, (boolean)false, (int)2, null)) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                            if (bl) continue;
                            list$iv.add(item$iv2);
                            yielding$iv = true;
                        }
                        Iterable $i$f$dropWhile22 = list$iv;
                        boolean $i$f$map = false;
                        list$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            $this$any$iv = (MirrorOfStackTraceElement)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it3.stackTraceElement());
                        }
                    } else {
                        return null;
                    }
                    List $this$indexOfFirst$iv = frames = (List)destination$iv$iv;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv3 : $this$indexOfFirst$iv) {
                        StackTraceElement it4 = (StackTraceElement)item$iv3;
                        boolean bl = false;
                        if (CoroutineUtilsKt.isCreationSeparatorFrame(it4)) {
                            n2 = index$iv;
                            break block14;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int index = n2;
                List restoredStackTraceElements = index >= 0 ? CollectionsKt.take((Iterable)frames, (int)index) : frames;
                List spilledVariablesPerFrame = CoroutineStackTraceProvider.access$getSpilledVariablesForNFrames(this.this$0, this.$mirror.getLastObservedFrame(), restoredStackTraceElements.size());
                Iterable $i$f$map = restoredStackTraceElements;
                item$iv3 = this.this$0;
                boolean $i$f$mapIndexed = false;
                void bl = $this$mapIndexed$iv2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void element3;
                    void ix2;
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    element$iv = (StackTraceElement)item$iv$iv;
                    int it2 = n3;
                    collection = destination$iv$iv;
                    n = 0;
                    List list3 = (List)CollectionsKt.getOrNull((List)spilledVariablesPerFrame, (int)ix2);
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    List variables2 = list3;
                    collection.add(new SuspendCoroutineStackFrameItem((StackTraceElement)element3, CoroutineStackTraceProvider.access$getLocationCache$p(item$iv3).createLocation((StackTraceElement)element3), variables2));
                }
                List restoredStackFrames = (List)destination$iv$iv;
                item$iv3 = frames.subList(index + 1, frames.size());
                CoroutineStackTraceProvider coroutineStackTraceProvider = this.this$0;
                boolean $i$f$mapIndexed2 = false;
                destination$iv$iv = $this$mapIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void ix;
                    void element4;
                    int n4;
                    if ((n4 = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    StackTraceElement ix2 = (StackTraceElement)item$iv$iv;
                    n = n4;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(new CreationCoroutineStackFrameItem((StackTraceElement)element4, CoroutineStackTraceProvider.access$getLocationCache$p(coroutineStackTraceProvider).createLocation((StackTraceElement)element4), ix == false));
                }
                List creationStackFrames = (List)destination$iv$iv2;
                return new CoroutineStackFrames(restoredStackFrames, creationStackFrames);
            }
        });
    }

    private final List<List<JavaValue>> getSpilledVariablesForNFrames(ObjectReference lastObservedFrame, int n) {
        BaseMirror baseMirror = this.debugMetadata;
        if (baseMirror == null || (baseMirror = ((DebugMetadata)baseMirror).getBaseContinuationImpl()) == null) {
            return CollectionsKt.emptyList();
        }
        BaseMirror baseContinuationImpl = baseMirror;
        List spilledVariablesPerFrame = new ArrayList();
        ObjectReference observedFrame = lastObservedFrame;
        while (observedFrame != null && spilledVariablesPerFrame.size() < n) {
            List<FieldVariable> spilledVariables = this.debugMetadata.getBaseContinuationImpl().getSpilledVariableFieldMapping(observedFrame, this.executionContext);
            spilledVariablesPerFrame.add(this.toJavaValues(spilledVariables, observedFrame));
            observedFrame = ((BaseContinuationImpl)baseContinuationImpl).getNextContinuation(observedFrame, this.executionContext);
        }
        return spilledVariablesPerFrame;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaValue> toJavaValues(List<FieldVariable> $this$toJavaValues, ObjectReference continuation2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toJavaValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldVariable fieldVariable = (FieldVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ContinuationHolderKt.toJavaValue((FieldVariable)it, continuation2, this.executionContext));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ List access$getSpilledVariablesForNFrames(CoroutineStackTraceProvider $this, ObjectReference lastObservedFrame, int n) {
        return $this.getSpilledVariablesForNFrames(lastObservedFrame, n);
    }

    public static final /* synthetic */ LocationCache access$getLocationCache$p(CoroutineStackTraceProvider $this) {
        return $this.locationCache;
    }

    static {
        String[] stringArray = new String[]{"getStackTrace", "enhanceStackTraceWithThreadDump"};
        METHOD_PREFIXES_TO_SKIP = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider$Companion;", "", "()V", "METHOD_PREFIXES_TO_SKIP", "", "", "getMETHOD_PREFIXES_TO_SKIP", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getMETHOD_PREFIXES_TO_SKIP() {
            return METHOD_PREFIXES_TO_SKIP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackTraceProvider$CoroutineStackFrames;", "", "restoredStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendCoroutineStackFrameItem;", "creationStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "(Ljava/util/List;Ljava/util/List;)V", "getCreationStackFrames", "()Ljava/util/List;", "getRestoredStackFrames", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
    public static final class CoroutineStackFrames {
        @NotNull
        private final List<SuspendCoroutineStackFrameItem> restoredStackFrames;
        @NotNull
        private final List<CreationCoroutineStackFrameItem> creationStackFrames;

        public CoroutineStackFrames(@NotNull List<SuspendCoroutineStackFrameItem> restoredStackFrames, @NotNull List<CreationCoroutineStackFrameItem> creationStackFrames) {
            Intrinsics.checkNotNullParameter(restoredStackFrames, (String)"restoredStackFrames");
            Intrinsics.checkNotNullParameter(creationStackFrames, (String)"creationStackFrames");
            this.restoredStackFrames = restoredStackFrames;
            this.creationStackFrames = creationStackFrames;
        }

        @NotNull
        public final List<SuspendCoroutineStackFrameItem> getRestoredStackFrames() {
            return this.restoredStackFrames;
        }

        @NotNull
        public final List<CreationCoroutineStackFrameItem> getCreationStackFrames() {
            return this.creationStackFrames;
        }

        @NotNull
        public final List<SuspendCoroutineStackFrameItem> component1() {
            return this.restoredStackFrames;
        }

        @NotNull
        public final List<CreationCoroutineStackFrameItem> component2() {
            return this.creationStackFrames;
        }

        @NotNull
        public final CoroutineStackFrames copy(@NotNull List<SuspendCoroutineStackFrameItem> restoredStackFrames, @NotNull List<CreationCoroutineStackFrameItem> creationStackFrames) {
            Intrinsics.checkNotNullParameter(restoredStackFrames, (String)"restoredStackFrames");
            Intrinsics.checkNotNullParameter(creationStackFrames, (String)"creationStackFrames");
            return new CoroutineStackFrames(restoredStackFrames, creationStackFrames);
        }

        public static /* synthetic */ CoroutineStackFrames copy$default(CoroutineStackFrames coroutineStackFrames, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = coroutineStackFrames.restoredStackFrames;
            }
            if ((n & 2) != 0) {
                list3 = coroutineStackFrames.creationStackFrames;
            }
            return coroutineStackFrames.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "CoroutineStackFrames(restoredStackFrames=" + this.restoredStackFrames + ", creationStackFrames=" + this.creationStackFrames + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.restoredStackFrames).hashCode();
            result2 = result2 * 31 + ((Object)this.creationStackFrames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof CoroutineStackFrames)) {
                return false;
            }
            CoroutineStackFrames coroutineStackFrames = (CoroutineStackFrames)other2;
            if (!Intrinsics.areEqual(this.restoredStackFrames, coroutineStackFrames.restoredStackFrames)) {
                return false;
            }
            return Intrinsics.areEqual(this.creationStackFrames, coroutineStackFrames.creationStackFrames);
        }
    }
}

