/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ2\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0013\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0013\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "()V", "getStepIntoCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreFilters", "", "smartStepFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepSize", "", "getStepOutCommand", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getStepOverCommand", "ignoreBreakpoints", "kotlin.jvm-debugger.core"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition3);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepIntoCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepIntoCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        return DebuggerSteppingHelper.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return DebuggerSteppingHelper.createStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition2 = debugContext.getSourcePosition();
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"getSourcePosition(...)");
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition2 = suspendContext.getDebugProcess().getDebuggerContext().getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        if (!(sourcePosition3.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOutCommand(suspendContext, sourcePosition3);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition2) {
        if (sourcePosition2.getLine() < 0) {
            return null;
        }
        return DebuggerSteppingHelper.createStepOutCommand(suspendContext, true);
    }
}

