/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointType;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0004\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "id", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "createJavaBreakpoint", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaMethodBreakpointProperties;", "getPriority", "isFunctionBreakpointApplicable", "isKtFileWithCommonOrJvmPlatform", "kotlin.jvm-debugger.core"})
public class KotlinFunctionBreakpointType
extends JavaMethodBreakpointType
implements KotlinBreakpointType {
    protected KotlinFunctionBreakpointType(@NotNull String id, @Nls @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(id, message2);
    }

    public KotlinFunctionBreakpointType() {
        this("kotlin-function", KotlinDebuggerCoreBundle.message("function.breakpoint.tab.title", new Object[0]));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinFunctionBreakpoint createJavaBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return new KotlinFunctionBreakpoint(project2, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.isKtFileWithCommonOrJvmPlatform(file2, project2) && this.isFunctionBreakpointApplicable(file2, line, project2);
    }

    private final boolean isKtFileWithCommonOrJvmPlatform(VirtualFile file2, Project project2) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return false;
        }
        KtFile psiFile3 = ktFile;
        TargetPlatform platform2 = TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile3);
        return TargetPlatformKt.isCommon((TargetPlatform)platform2) || JvmPlatformKt.isJvm((TargetPlatform)platform2);
    }

    public boolean isFunctionBreakpointApplicable(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)isFunctionBreakpointApplicable.1.INSTANCE));
    }
}

