/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Range;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.FileApplicabilityChecker;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils$isInCrossInlineArgument$;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerLegacyFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J8\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J4\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0007J>\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u00103\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u000104*\u000205J\f\u00106\u001a\u00020\u0016*\u00020\u0016H\u0002J\n\u00107\u001a\u00020\u0006*\u00020\u0016J\u0012\u00108\u001a\u00020\u0016*\u00020\u00162\u0006\u00109\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils;", "", "()V", "IR_BACKEND_LAMBDA_REGEX", "Lkotlin/text/Regex;", "<set-?>", "", "forceRanking", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "chooseApplicableFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "location", "Lcom/sun/jdi/Location;", "findFilesByNameInPackage", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "findSourceFileForClassIncludeLibrarySources", "scope", "getLocationsOfInlinedLine", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "inlinedLinesNumbers", "", "inlineLineNumber", "inlineFileName", "destinationTypeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destinationFileName", "isCrossInlineArgument", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isInCrossInlineArgument", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isKotlinSourceFile", "getBorders", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/LocalVariable;", "getMethodNameWithoutMangling", "isGeneratedIrBackendLambdaMethodName", "trimIfMangledInBytecode", "isMangledInBytecode", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nDebuggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,225:1\n766#2:226\n857#2,2:227\n766#2:229\n857#2,2:230\n1360#2:236\n1446#2,5:237\n766#2:254\n857#2,2:255\n1360#2:257\n1446#2,5:258\n15#3,2:232\n1247#4,2:234\n473#4:242\n27#5,2:243\n55#6:245\n69#6,8:246\n*S KotlinDebug\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n*L\n80#1:226\n80#1:227,2\n120#1:229\n120#1:230,2\n169#1:236\n169#1:237,5\n218#1:254\n218#1:255,2\n219#1:257\n219#1:258,5\n155#1:232,2\n157#1:234,2\n173#1:242\n196#1:243,2\n196#1:245\n196#1:246,8\n*E\n"})
public final class DebuggerUtils {
    @NotNull
    public static final DebuggerUtils INSTANCE = new DebuggerUtils();
    private static boolean forceRanking;
    @NotNull
    private static final Regex IR_BACKEND_LAMBDA_REGEX;

    private DebuggerUtils() {
    }

    public final boolean getForceRanking() {
        return forceRanking;
    }

    @TestOnly
    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (KtFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(project2, scope2, className, fileName, location2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Location $location;
            {
                this.$project = $project;
                this.$scope = $scope;
                this.$className = $className;
                this.$fileName = $fileName;
                this.$location = $location;
                super(0);
            }

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, this.$location);
            }
        }));
    }

    public static /* synthetic */ KtFile findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils debuggerUtils, Project project2, GlobalSearchScope globalSearchScope, JvmClassName jvmClassName, String string, Location location2, int n, Object object) {
        if ((n & 0x10) != 0) {
            location2 = null;
        }
        return debuggerUtils.findSourceFileForClassIncludeLibrarySources(project2, globalSearchScope, jvmClassName, string, location2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes2, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return null;
        }
        if (DumbService.Companion.getInstance(project2).isDumb()) {
            return null;
        }
        FqName fqName2 = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameForClassNameWithoutDollars(...)");
        FqName partFqName = fqName2;
        for (GlobalSearchScope globalSearchScope : scopes2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.findFilesByNameInPackage(className, fileName, project2, globalSearchScope);
            boolean $i$f$filter = false;
            void var12_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!(JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)) || TargetPlatformKt.isCommon((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List files2 = (List)destination$iv$iv;
            if (files2.isEmpty()) continue;
            if (files2.size() == 1 && !forceRanking || location2 == null) {
                return (KtFile)CollectionsKt.first((List)files2);
            }
            KtFile singleFile2 = (KtFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(partFqName, project2, globalSearchScope, fileName){
                final /* synthetic */ FqName $partFqName;
                final /* synthetic */ Project $project;
                final /* synthetic */ GlobalSearchScope $scope;
                final /* synthetic */ String $fileName;
                {
                    this.$partFqName = $partFqName;
                    this.$project = $project;
                    this.$scope = $scope;
                    this.$fileName = $fileName;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final KtFile invoke() {
                    Object v1;
                    block2: {
                        void $this$singleOrNull$iv;
                        String string = this.$partFqName.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                        Collection<Key> matchingFiles = KotlinFileFacadeFqNameIndex.Helper.get(string, this.$project, this.$scope);
                        Iterable iterable = PackagePartClassUtils.getFilesWithCallables(matchingFiles);
                        String string2 = this.$fileName;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            KtFile it = (KtFile)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)string2)) continue;
                            if (found$iv) {
                                v1 = null;
                                break block2;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v1 = !found$iv ? null : single$iv;
                    }
                    return v1;
                }
            }));
            if (singleFile2 != null) {
                return singleFile2;
            }
            return this.chooseApplicableFile(files2, location2);
        }
        return null;
    }

    private final KtFile chooseApplicableFile(List<? extends KtFile> files2, Location location2) {
        Object object;
        if (Registry.is((String)"kotlin.debugger.analysis.api.file.applicability.checker")) {
            object = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files2, location2);
        } else {
            object = KotlinDebuggerLegacyFacade.Companion.getInstance();
            if (object == null || (object = object.getFileSelector()) == null || (object = object.chooseMostApplicableFile(files2, location2)) == null) {
                object = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files2, location2);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project2, GlobalSearchScope searchScope2) {
        void $this$filterTo$iv$iv;
        FqName fqName2 = className.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
        Iterable $this$filter$iv = KotlinPackageIndexUtils.INSTANCE.findFilesWithExactPackage(fqName2, searchScope2, project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)files2, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope2));
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String extension2 = string3;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(extension2);
    }

    @NotNull
    public final String trimIfMangledInBytecode(@NotNull String $this$trimIfMangledInBytecode, boolean isMangledInBytecode) {
        Intrinsics.checkNotNullParameter((Object)$this$trimIfMangledInBytecode, (String)"<this>");
        return isMangledInBytecode ? this.getMethodNameWithoutMangling($this$trimIfMangledInBytecode) : $this$trimIfMangledInBytecode;
    }

    private final String getMethodNameWithoutMangling(String $this$getMethodNameWithoutMangling) {
        return StringsKt.substringBefore$default((String)$this$getMethodNameWithoutMangling, (char)'-', null, (int)2, null);
    }

    public final boolean isGeneratedIrBackendLambdaMethodName(@NotNull String $this$isGeneratedIrBackendLambdaMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedIrBackendLambdaMethodName, (String)"<this>");
        CharSequence charSequence = $this$isGeneratedIrBackendLambdaMethodName;
        return IR_BACKEND_LAMBDA_REGEX.matches(charSequence);
    }

    @Nullable
    public final ClosedRange<Location> getBorders(@NotNull LocalVariable $this$getBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$getBorders, (String)"<this>");
        Range range2 = DebuggerUtilsImpl.getLocalVariableBorders((LocalVariable)$this$getBorders);
        if (range2 == null) {
            return null;
        }
        Range range3 = range2;
        Comparable comparable = range3.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getFrom(...)");
        Comparable comparable2 = range3.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getTo(...)");
        return RangesKt.rangeTo((Comparable)comparable, (Comparable)comparable2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @ApiStatus.Internal
    @NotNull
    public final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position, @NotNull GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        boolean isInCrossInlineArgument;
        boolean isInInline;
        KtElement ktElement;
        Object element$iv2;
        Project project2;
        int line;
        block8: {
            boolean bl;
            Object v4;
            PsiElement element3;
            block7: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)sourceSearchScope, (String)"sourceSearchScope");
                line = position.getLine();
                PsiFile psiFile2 = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
                PsiFile file2 = psiFile2;
                Project project3 = position.getFile().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                project2 = project3;
                Integer n = PsiLinesUtilsKt.getLineStartOffset(file2, line);
                if (n == null) {
                    return CollectionsKt.emptyList();
                }
                int lineStartOffset = n;
                PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
                if (psiElement2 == null) {
                    return CollectionsKt.emptyList();
                }
                element3 = psiElement2;
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv2 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv2 instanceof KtElement)) continue;
                    v4 = element$iv2;
                    break block7;
                }
                v4 = null;
            }
            KtElement ktElement2 = v4;
            if (ktElement2 == null) {
                return CollectionsKt.emptyList();
            }
            ktElement = ktElement2;
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv2;
                boolean bl2 = false;
                if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                bl = true;
                break block8;
            }
            bl = isInInline = false;
        }
        if (!isInInline && !(isInCrossInlineArgument = this.isInCrossInlineArgument(ktElement))) {
            return CollectionsKt.emptyList();
        }
        String string = position.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        FqName fqName2 = new FqName(type2.name());
        String string2 = type2.sourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceName(...)");
        List<Integer> lines = this.inlinedLinesNumbers(line + 1, string, fqName2, string2, project2, sourceSearchScope);
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            List list2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (int)it);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"locationsOfLineSync(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isInCrossInlineArgument(KtElement ktElement) {
        Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)ktElement));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isInCrossInlineArgument$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (KtFunction function2 : sequence2) {
            KtFunction ktFunction = function2;
            if (ktFunction instanceof KtFunctionLiteral) {
                KtLambdaExpression lambdaExpression2;
                PsiElement argumentExpression;
                PsiElement psiElement2 = ((KtFunctionLiteral)function2).getParent();
                KtLambdaExpression ktLambdaExpression2 = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
                if (ktLambdaExpression2 == null || !((argumentExpression = (lambdaExpression2 = ktLambdaExpression2).getParent()) instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)lambdaExpression2)) continue;
                return true;
            }
            if (!(ktFunction instanceof KtNamedFunction) || !(((KtNamedFunction)function2).getParent() instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)function2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isCrossInlineArgument(KtExpression argumentExpression) {
        boolean bl;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)argumentExpression);
        if (ktExpression == null) {
            return false;
        }
        KtExpression callExpression2 = ktExpression;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)callExpression2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        void var6_6 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression2);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            boolean bl2;
            KtAnalysisSession $this$isCrossInlineArgument_u24lambda_u244 = analysisSession$iv$iv$iv;
            boolean bl3 = false;
            KtLifetimeOwner ktLifetimeOwner = $this$isCrossInlineArgument_u24lambda_u244.resolveCall((KtElement)callExpression2);
            if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
                bl2 = false;
            } else {
                KtLifetimeOwner call = ktLifetimeOwner;
                KtLifetimeOwner ktLifetimeOwner2 = ((KtFunctionCall)call).getArgumentMapping().get(argumentExpression);
                if (ktLifetimeOwner2 == null || (ktLifetimeOwner2 = (KtValueParameterSymbol)((KtCallableSignature)ktLifetimeOwner2).getSymbol()) == null) {
                    bl2 = false;
                } else {
                    KtLifetimeOwner parameter2 = ktLifetimeOwner2;
                    bl2 = ((KtValueParameterSymbol)parameter2).isCrossinline();
                }
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project2, GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        String string = destinationTypeFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String internalName = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile ktFile = DebuggerUtils.findSourceFileForClassIncludeLibrarySources$default(this, project2, sourceSearchScope, jvmClassName2, destinationFileName, null, 16, null);
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        SMAP sMAP = KotlinSourceMapCache.Companion.getInstance(project2).getSourceMap(virtualFile3, jvmClassName2);
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP sourceMap = sMAP;
        Iterable $this$filter$iv = sourceMap.getFileMappings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = mappingsToInlinedFile;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv2;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), (Function1)((Function1)new Function1<RangeMapping, Boolean>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;
            {
                this.$inlineLineNumber = $inlineLineNumber;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.hasMappingForSource(this.$inlineLineNumber);
            }
        })), (Function1)((Function1)new Function1<RangeMapping, Integer>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;
            {
                this.$inlineLineNumber = $inlineLineNumber;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.mapSourceToDest(this.$inlineLineNumber);
            }
        })), (Function1)inlinedLinesNumbers.3.INSTANCE));
    }

    static {
        IR_BACKEND_LAMBDA_REGEX = new Regex(".+\\$lambda[$-]\\d+");
    }
}

