/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ANDROIDX_COMPOSE_PACKAGE_NAME", "", "COMPOSABLE_SINGLETONS_PREFIX", "computeComposableSingletonsClassName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassPrepareRequestForComposableSingletons", "Lcom/sun/jdi/request/ClassPrepareRequest;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "getComposableSingletonsClasses", "", "Lcom/sun/jdi/ReferenceType;", "isInsideProjectWithCompose", "", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\ncomposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 composeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/ComposeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1360#2:70\n1446#2,5:71\n*S KotlinDebug\n*F\n+ 1 composeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/ComposeUtilsKt\n*L\n54#1:70\n54#1:71,5\n*E\n"})
public final class ComposeUtilsKt {
    @NotNull
    private static final String COMPOSABLE_SINGLETONS_PREFIX = "ComposableSingletons";
    @NotNull
    private static final String ANDROIDX_COMPOSE_PACKAGE_NAME = "androidx.compose";

    @NotNull
    public static final String computeComposableSingletonsClassName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = file2.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = file2.getName();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        Object filePath2 = object2;
        char[] cArray = new char[]{'/'};
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)filePath2), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String shortName = PackagePartClassUtils.getFilePartShortName((String)fileName);
        FqName fileClassFqName2 = ((JvmFileClassInfo)ActionsKt.runReadAction((Function0)((Function0)new Function0<JvmFileClassInfo>(file2){
            final /* synthetic */ KtFile $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final JvmFileClassInfo invoke() {
                return JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)this.$file);
            }
        }))).getFacadeClassFqName();
        String classNameSuffix = "ComposableSingletons$" + shortName;
        FqName fqName2 = fileClassFqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
        FqName filePackageName = fqName2;
        if (filePackageName.isRoot()) {
            return classNameSuffix;
        }
        return filePackageName.asString() + "." + classNameSuffix;
    }

    public static final boolean isInsideProjectWithCompose(@NotNull SourcePosition $this$isInsideProjectWithCompose) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideProjectWithCompose, (String)"<this>");
        Object object = ReadAction.nonBlocking(() -> ComposeUtilsKt.isInsideProjectWithCompose$lambda$0($this$isInsideProjectWithCompose)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ReferenceType> getComposableSingletonsClasses(@NotNull DebugProcess debugProcess, @NotNull KtFile file2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualMachineProxy vm = debugProcess.getVirtualMachineProxy();
        String composableSingletonsClassName = ComposeUtilsKt.computeComposableSingletonsClassName(file2);
        List list2 = vm.classesByName(composableSingletonsClassName);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classesByName(...)");
        Iterable $this$flatMap$iv = list2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            List list3 = referenceType.isPrepared() ? vm.nestedTypes(referenceType) : CollectionsKt.emptyList();
            Intrinsics.checkNotNull((Object)list3);
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ClassPrepareRequest getClassPrepareRequestForComposableSingletons(@NotNull DebugProcess debugProcess, @NotNull ClassPrepareRequestor requestor, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return debugProcess.getRequestsManager().createClassPrepareRequest(requestor, ComposeUtilsKt.computeComposableSingletonsClassName(file2) + "$*");
    }

    private static final Boolean isInsideProjectWithCompose$lambda$0(SourcePosition $this_isInsideProjectWithCompose) {
        Intrinsics.checkNotNullParameter((Object)$this_isInsideProjectWithCompose, (String)"$this_isInsideProjectWithCompose");
        return JavaPsiFacade.getInstance((Project)$this_isInsideProjectWithCompose.getFile().getProject()).findPackage(ANDROIDX_COMPOSE_PACKAGE_NAME) != null;
    }
}

