/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "composeTopLevelClassNameVariants", "", "", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "findCompiledModuleClass", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findLibraryClass", "findSourceMap", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "getSourceMap", "parseSourceMap", "bytecode", "Companion", "kotlin.jvm-debugger.base.util"})
@SourceDebugExtension(value={"SMAP\nKotlinSourceMapCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class KotlinSourceMapCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public KotlinSourceMapCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Nullable
    public final SMAP getSourceMap(@NotNull VirtualFile file2, @NotNull JvmClassName jvmName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)this.project)};
        Object[] dependencies2 = objectArray;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)CacheUtilsKt.cacheByClass(this.project, KotlinSourceMapCache.class, Arrays.copyOf(dependencies2, dependencies2.length), (Function0)getSourceMap.cache.1.INSTANCE);
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"org/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$getSourceMap$Key", "", "path", "", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;)V", "getJvmName", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;)Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$getSourceMap$Key;", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.base.util"})
        public final class Key {
            @NotNull
            private final String path;
            @NotNull
            private final JvmClassName jvmName;

            public Key(@NotNull String path2, @NotNull JvmClassName jvmName) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
                this.path = path2;
                this.jvmName = jvmName;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final JvmClassName getJvmName() {
                return this.jvmName;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final JvmClassName component2() {
                return this.jvmName;
            }

            @NotNull
            public final Key copy(@NotNull String path2, @NotNull JvmClassName jvmName) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
                return new Key(path2, jvmName);
            }

            public static /* synthetic */ Key copy$default(Key key, String string, JvmClassName jvmClassName, int n, Object object) {
                if ((n & 1) != 0) {
                    string = key.path;
                }
                if ((n & 2) != 0) {
                    jvmClassName = key.jvmName;
                }
                return key.copy(string, jvmClassName);
            }

            @NotNull
            public String toString() {
                return "Key(path=" + this.path + ", jvmName=" + this.jvmName + ")";
            }

            public int hashCode() {
                int result2 = this.path.hashCode();
                result2 = result2 * 31 + this.jvmName.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof Key)) {
                    return false;
                }
                Key key = (Key)other2;
                if (!Intrinsics.areEqual((Object)this.path, (Object)key.path)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.jvmName, (Object)key.jvmName);
            }
        }
        Key key = new Key(string, jvmName);
        return ((Optional)cache2.get(key, (Function1)new Function1<Key, Optional<SMAP>>(this, file2, jvmName){
            final /* synthetic */ KotlinSourceMapCache this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ JvmClassName $jvmName;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$jvmName = $jvmName;
                super(1);
            }

            @NotNull
            public final Optional<SMAP> invoke(@NotNull Key it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Optional.ofNullable(KotlinSourceMapCache.access$findSourceMap(this.this$0, this.$file, this.$jvmName));
            }
        })).orElse(null);
    }

    private final SMAP findSourceMap(VirtualFile file2, JvmClassName jvmName) {
        SMAP sMAP;
        byte[] bytecode;
        if (bytecode != null) {
            byte[] p0 = bytecode = SourceKindFilterUtils.matches(RootKindFilter.projectSources, this.project, file2) ? this.findCompiledModuleClass(file2, jvmName) : (byte[])(SourceKindFilterUtils.matches(RootKindFilter.librarySources, this.project, file2) ? this.findLibraryClass(jvmName) : null);
            boolean bl = false;
            sMAP = this.parseSourceMap(p0);
        } else {
            sMAP = null;
        }
        return sMAP;
    }

    private final SMAP parseSourceMap(byte[] bytecode) {
        SMAP sMAP;
        Ref.ObjectRef debugInfo2 = new Ref.ObjectRef();
        new ClassReader(bytecode).accept(new ClassVisitor((Ref.ObjectRef<String>)debugInfo2){
            final /* synthetic */ Ref.ObjectRef<String> $debugInfo;
            {
                this.$debugInfo = $debugInfo;
                super(589824);
            }

            public void visitSource(@Nullable String source, @Nullable String debug) {
                this.$debugInfo.element = debug;
            }
        }, 0);
        String string = (String)debugInfo2.element;
        if (string != null) {
            String string2 = string;
            SMAPParser sMAPParser = SMAPParser.INSTANCE;
            String p0 = string2;
            boolean bl = false;
            sMAP = sMAPParser.parseOrNull(p0);
        } else {
            sMAP = null;
        }
        return sMAP;
    }

    private final byte[] findCompiledModuleClass(VirtualFile file2, JvmClassName jvmName) {
        Module module2 = ProjectFileIndex.getInstance((Project)this.project).getModuleForFile(file2);
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        Object object = this.findCompiledModuleClass(module3, jvmName);
        if (object != null) {
            byte[] it = object;
            boolean bl = false;
            return it;
        }
        object = KotlinFacetUtils.getImplementingModules(module3).iterator();
        while (object.hasNext()) {
            Module implementingModule = (Module)object.next();
            byte[] byArray = this.findCompiledModuleClass(implementingModule, jvmName);
            if (byArray == null) continue;
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final byte[] findCompiledModuleClass(Module module2, JvmClassName jvmName) {
        Module[] moduleArray = new Module[]{module2};
        String[] stringArray = CompilerPaths.getOutputPaths((Module[])moduleArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getOutputPaths(...)");
        for (String outputRoot : ArraysKt.toList((Object[])stringArray)) {
            String[] stringArray2 = new String[]{jvmName.getInternalName() + ".class"};
            Path path2 = Path.of(outputRoot, stringArray2);
            Intrinsics.checkNotNull((Object)path2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            try {
                byte[] byArray = Files.readAllBytes(path2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                return byArray;
            }
            catch (IOException e) {
                LOG.debug("Can't read class file " + jvmName, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private final byte[] findLibraryClass(JvmClassName jvmName) {
        String string = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        String classFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(this.project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        VirtualFileFinder fileFinder = virtualFileFinderFactory.create(globalSearchScope);
        for (String topLevelClassName : this.composeTopLevelClassNameVariants(jvmName)) {
            VirtualFile classFile;
            VirtualFile variantClassFile = fileFinder.findVirtualFileWithHeader(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)topLevelClassName, (boolean)false, (int)2, null));
            if (variantClassFile != null && Intrinsics.areEqual((Object)topLevelClassName, (Object)jvmName.getInternalName())) {
                return KotlinSourceMapCache.findLibraryClass$readFile(jvmName, variantClassFile);
            }
            VirtualFile virtualFile2 = variantClassFile;
            Object packageDir = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (packageDir == null || (classFile = packageDir.findChild(classFileName + ".class")) == null) continue;
            return KotlinSourceMapCache.findLibraryClass$readFile(jvmName, classFile);
        }
        return null;
    }

    private final List<String> composeTopLevelClassNameVariants(JvmClassName jvmName) {
        List list2;
        List $this$composeTopLevelClassNameVariants_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        String string = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        String jdiName = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
        int index = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)1, (boolean)false, (int)4, null);
        while (index >= 0) {
            $this$composeTopLevelClassNameVariants_u24lambda_u243.add(StringsKt.take((String)jdiName, (int)index));
            index = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)(index + 1), (boolean)false, (int)4, null);
        }
        String string2 = jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        $this$composeTopLevelClassNameVariants_u24lambda_u243.add(string2);
        return CollectionsKt.build((List)list2);
    }

    private static final byte[] findLibraryClass$readFile(JvmClassName $jvmName, VirtualFile file2) {
        try {
            return file2.contentsToByteArray(false);
        }
        catch (IOException e) {
            LOG.debug("Can't read class file " + $jvmName, (Throwable)e);
            return null;
        }
    }

    public static final /* synthetic */ SMAP access$findSourceMap(KotlinSourceMapCache $this, VirtualFile file2, JvmClassName jvmName) {
        return $this.findSourceMap(file2, jvmName);
    }

    static {
        Logger logger = Logger.getInstance(KotlinSourceMapCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm-debugger.base.util"})
    @SourceDebugExtension(value={"SMAP\nKotlinSourceMapCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n30#2,3:157\n*S KotlinDebug\n*F\n+ 1 KotlinSourceMapCache.kt\norg/jetbrains/kotlin/idea/debugger/base/util/KotlinSourceMapCache$Companion\n*L\n40#1:157,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSourceMapCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KotlinSourceMapCache> serviceClass$iv = KotlinSourceMapCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinSourceMapCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

